/*
 * Decompiled with CFR 0.152.
 */
package xyz.przemyk.simpleplanes.upgrades.banner;

import com.mojang.blaze3d.matrix.MatrixStack;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.tileentity.BannerTileEntityRenderer;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BannerItem;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.IItemProvider;
import xyz.przemyk.simpleplanes.MathUtil;
import xyz.przemyk.simpleplanes.entities.PlaneEntity;
import xyz.przemyk.simpleplanes.setup.SimplePlanesUpgrades;
import xyz.przemyk.simpleplanes.upgrades.Upgrade;
import xyz.przemyk.simpleplanes.upgrades.UpgradeType;
import xyz.przemyk.simpleplanes.upgrades.banner.BannerModel;

public class BannerUpgrade
extends Upgrade {
    public ItemStack banner = new ItemStack((IItemProvider)Items.field_196191_eg);
    public float rotation;
    public float prevRotation;

    public BannerUpgrade(PlaneEntity planeEntity) {
        super((UpgradeType)SimplePlanesUpgrades.BANNER.get(), planeEntity);
        this.prevRotation = planeEntity.field_70126_B;
        this.rotation = planeEntity.field_70126_B;
    }

    @Override
    public boolean tick() {
        this.prevRotation = this.rotation;
        this.rotation = MathUtil.lerpAngle(0.05f, this.rotation, this.planeEntity.field_70126_B);
        return super.tick();
    }

    @Override
    public CompoundNBT serializeNBT() {
        CompoundNBT compoundNBT = new CompoundNBT();
        compoundNBT.func_218657_a("banner", (INBT)this.banner.serializeNBT());
        return compoundNBT;
    }

    @Override
    public void deserializeNBT(CompoundNBT nbt) {
        INBT banner = nbt.func_74781_a("banner");
        if (banner instanceof CompoundNBT) {
            this.banner = ItemStack.func_199557_a((CompoundNBT)((CompoundNBT)banner));
        }
    }

    @Override
    public CompoundNBT serializeNBTData() {
        return this.serializeNBT();
    }

    @Override
    public void deserializeNBTData(CompoundNBT nbt) {
        this.deserializeNBT(nbt);
    }

    @Override
    public void render(MatrixStack matrixStack, IRenderTypeBuffer buffer, int packedLight, float partialticks) {
        BannerModel.renderBanner(this, partialticks, matrixStack, buffer, this.banner, packedLight, BannerTileEntityRenderer.func_228836_a_());
    }

    @Override
    public ItemStack getDrop() {
        return this.banner;
    }

    @Override
    public void onApply(ItemStack itemStack, PlayerEntity playerEntity) {
        if (itemStack.func_77973_b() instanceof BannerItem) {
            this.banner = itemStack.func_77946_l();
            this.banner.func_190920_e(1);
            this.planeEntity.upgradeChanged();
        }
    }
}

