/*
 * Decompiled with CFR 0.152.
 */
package xyz.przemyk.simpleplanes.upgrades.storage;

import com.mojang.blaze3d.matrix.MatrixStack;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.IInventoryChangedListener;
import net.minecraft.inventory.Inventory;
import net.minecraft.inventory.container.ChestContainer;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.tileentity.ChestTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.network.PacketDistributor;
import xyz.przemyk.simpleplanes.entities.PlaneEntity;
import xyz.przemyk.simpleplanes.handler.PlaneNetworking;
import xyz.przemyk.simpleplanes.render.BackSeatBlockModel;
import xyz.przemyk.simpleplanes.setup.SimplePlanesUpgrades;
import xyz.przemyk.simpleplanes.upgrades.Upgrade;
import xyz.przemyk.simpleplanes.upgrades.UpgradeType;

public class ChestUpgrade
extends Upgrade
implements IInventoryChangedListener,
INamedContainerProvider {
    ChestTileEntity tileEntity;
    public IInventory inventory;
    public float lidAngle;
    private float partialticks = 0.0f;
    private boolean open = false;
    private int size = 1;

    public ChestUpgrade(PlaneEntity planeEntity) {
        super((UpgradeType)SimplePlanesUpgrades.CHEST.get(), planeEntity);
        this.initChest();
        this.lidAngle = 0.0f;
    }

    protected void initChest() {
        IInventory inventory = this.inventory;
        this.inventory = new Inventory(this.size * 9){

            public void func_174889_b(PlayerEntity player) {
                ChestUpgrade.this.openInventory(player);
                PlaneNetworking.OPEN_INVENTORY.send(PacketDistributor.PLAYER.with(() -> (ServerPlayerEntity)player), (Object)true);
            }

            public void func_174886_c(PlayerEntity player) {
                ChestUpgrade.this.closeInventory(player);
                PlaneNetworking.OPEN_INVENTORY.send(PacketDistributor.PLAYER.with(() -> (ServerPlayerEntity)player), (Object)false);
            }
        };
        this.tileEntity = new ChestTileEntity(){

            public float func_195480_a(float partialTicks) {
                return ChestUpgrade.this.lidAngle;
            }

            public BlockState func_195044_w() {
                return Blocks.field_150486_ae.func_176223_P();
            }
        };
        if (inventory != null) {
            int j;
            int min_size = Math.min(inventory.func_70302_i_(), this.inventory.func_70302_i_());
            for (j = 0; j < min_size; ++j) {
                ItemStack itemstack = inventory.func_70301_a(j);
                if (itemstack.func_190926_b()) continue;
                this.inventory.func_70299_a(j, itemstack.func_77946_l());
            }
            int max_size = Math.max(inventory.func_70302_i_(), this.inventory.func_70302_i_());
            while (j < max_size) {
                ItemStack itemstack = inventory.func_70301_a(j);
                if (!itemstack.func_190926_b()) {
                    this.planeEntity.func_199701_a_(itemstack);
                }
                ++j;
            }
        }
    }

    public void func_76316_a(IInventory invBasic) {
    }

    @Override
    public boolean tick() {
        if (this.open && this.lidAngle == 0.0f) {
            this.planeEntity.func_184185_a(SoundEvents.field_187657_V, 0.5f, this.planeEntity.field_70170_p.field_73012_v.nextFloat() * 0.1f + 0.9f);
        }
        if (!this.open && this.lidAngle > 0.0f || this.open && this.lidAngle < 1.0f) {
            float prevLidAngle = this.lidAngle;
            this.lidAngle = this.open ? (this.lidAngle += 0.01f) : (this.lidAngle -= 0.01f);
            if (this.lidAngle > 1.0f) {
                this.lidAngle = 1.0f;
            }
            if (this.lidAngle < 0.5f && prevLidAngle >= 0.5f) {
                this.planeEntity.func_184185_a(SoundEvents.field_187651_T, 0.5f, this.planeEntity.field_70170_p.field_73012_v.nextFloat() * 0.1f + 0.9f);
            }
            if (this.lidAngle < 0.0f) {
                this.lidAngle = 0.0f;
            }
        }
        return super.tick();
    }

    public void openInventory(PlayerEntity player) {
        this.open = true;
        this.planeEntity.upgradeChanged();
    }

    public void closeInventory(PlayerEntity player) {
        this.open = false;
        this.planeEntity.upgradeChanged();
    }

    @Override
    public void deserializeNBT(CompoundNBT nbt) {
        ListNBT listnbt = nbt.func_150295_c("Items", 10);
        this.size = nbt.func_74762_e("size");
        this.initChest();
        for (int i = 0; i < listnbt.size(); ++i) {
            CompoundNBT compoundnbt = listnbt.func_150305_b(i);
            int j = compoundnbt.func_74771_c("Slot") & 0xFF;
            if (j >= this.inventory.func_70302_i_()) continue;
            this.inventory.func_70299_a(j, ItemStack.func_199557_a((CompoundNBT)compoundnbt));
        }
    }

    @Override
    public CompoundNBT serializeNBT() {
        CompoundNBT compound = new CompoundNBT();
        compound.func_74768_a("size", this.size);
        ListNBT listnbt = new ListNBT();
        for (int i = 0; i < this.inventory.func_70302_i_(); ++i) {
            ItemStack itemstack = this.inventory.func_70301_a(i);
            if (itemstack.func_190926_b()) continue;
            CompoundNBT compoundnbt = new CompoundNBT();
            compoundnbt.func_74774_a("Slot", (byte)i);
            itemstack.func_77955_b(compoundnbt);
            listnbt.add((Object)compoundnbt);
        }
        compound.func_218657_a("Items", (INBT)listnbt);
        return compound;
    }

    @Override
    public CompoundNBT serializeNBTData() {
        CompoundNBT compound = super.serializeNBTData();
        compound.func_74757_a("open", this.open);
        compound.func_74768_a("size", this.size);
        return compound;
    }

    @Override
    public void deserializeNBTData(CompoundNBT nbt) {
        this.open = this.planeEntity.field_70170_p.field_72995_K ? nbt.func_74767_n("open") : false;
        this.size = nbt.func_74762_e("size");
        super.deserializeNBTData(nbt);
    }

    @Override
    public void render(MatrixStack matrixStack, IRenderTypeBuffer buffer, int packedLight, float partialticks) {
        this.partialticks = partialticks;
        this.tileEntity.func_226984_a_(null, BlockPos.field_177992_a);
        BackSeatBlockModel.renderTileBlock(this.planeEntity, partialticks, matrixStack, buffer, packedLight, (TileEntity)this.tileEntity);
    }

    public ITextComponent func_145748_c_() {
        return new TranslationTextComponent("simpleplanes:chest", new Object[0]);
    }

    @Nullable
    public Container createMenu(int id, PlayerInventory playerInventoryIn, PlayerEntity playerEntity) {
        ContainerType type;
        switch (this.size) {
            case 1: {
                type = ContainerType.field_221507_a;
                break;
            }
            case 2: {
                type = ContainerType.field_221508_b;
                break;
            }
            case 3: {
                type = ContainerType.field_221509_c;
                break;
            }
            case 4: {
                type = ContainerType.field_221510_d;
                break;
            }
            case 5: {
                type = ContainerType.field_221511_e;
                break;
            }
            case 6: {
                type = ContainerType.field_221512_f;
                break;
            }
            default: {
                type = ContainerType.field_221513_g;
            }
        }
        return new ChestContainer(type, id, playerInventoryIn, this.inventory, this.size);
    }

    @Override
    public boolean onItemRightClick(PlayerInteractEvent.RightClickItem event) {
        if (event.getItemStack().func_77973_b() == Items.field_221675_bZ && this.size < 6 && !this.open && !this.planeEntity.isFull()) {
            ++this.size;
            this.initChest();
            event.getItemStack().func_190918_g(1);
            this.planeEntity.upgradeChanged();
        }
        return false;
    }

    @Override
    public NonNullList<ItemStack> getDrops() {
        int i;
        NonNullList items = NonNullList.func_191196_a();
        for (i = 0; i < this.inventory.func_70302_i_(); ++i) {
            ItemStack itemstack = this.inventory.func_70301_a(i);
            if (itemstack.func_190926_b()) continue;
            items.add((Object)itemstack);
        }
        for (i = 0; i < this.size; ++i) {
            items.add((Object)this.getType().getDrops());
        }
        return items;
    }

    @Override
    public int getSeats() {
        return this.size;
    }
}

