/*
 * Decompiled with CFR 0.152.
 */
package xyz.przemyk.simpleplanes;

import com.mojang.blaze3d.matrix.MatrixStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.screen.inventory.InventoryScreen;
import net.minecraft.client.settings.PointOfView;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Quaternion;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.EntityViewRenderEvent;
import net.minecraftforge.client.event.GuiOpenEvent;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import xyz.przemyk.simpleplanes.MathUtil;
import xyz.przemyk.simpleplanes.SimplePlanesMod;
import xyz.przemyk.simpleplanes.entities.PlaneEntity;
import xyz.przemyk.simpleplanes.handler.PlaneNetworking;
import xyz.przemyk.simpleplanes.setup.SimplePlanesUpgrades;
import xyz.przemyk.simpleplanes.upgrades.Upgrade;
import xyz.przemyk.simpleplanes.upgrades.storage.ChestUpgrade;

@OnlyIn(value=Dist.CLIENT)
@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class PlanesClientEvents {
    private static boolean playerRotationNeedToPop = false;
    static boolean old_sprint = false;

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onRenderPre(RenderLivingEvent.Pre event) {
        Entity entity = event.getEntity().func_184208_bv();
        if (entity instanceof PlaneEntity) {
            boolean isPlayerRidingInFirstPersonView;
            PlaneEntity planeEntity = (PlaneEntity)entity;
            MatrixStack matrixStack = event.getMatrixStack();
            matrixStack.func_227860_a_();
            playerRotationNeedToPop = true;
            double firstPersonYOffset = 0.7;
            boolean bl = isPlayerRidingInFirstPersonView = Minecraft.func_71410_x().field_71439_g != null && planeEntity.func_184196_w((Entity)Minecraft.func_71410_x().field_71439_g) && Minecraft.func_71410_x().field_71474_y.field_243228_bb == PointOfView.FIRST_PERSON;
            if (isPlayerRidingInFirstPersonView) {
                matrixStack.func_227861_a_(0.0, firstPersonYOffset, 0.0);
            }
            matrixStack.func_227861_a_(0.0, 0.7, 0.0);
            Quaternion quaternion = MathUtil.lerpQ(event.getPartialRenderTick(), planeEntity.getQ_Prev(), planeEntity.getQ_Client());
            quaternion.func_227066_a_(quaternion.func_195889_a(), -quaternion.func_195891_b(), -quaternion.func_195893_c(), quaternion.func_195894_d());
            matrixStack.func_227863_a_(quaternion);
            float rotationYaw = MathUtil.lerpAngle(event.getPartialRenderTick(), entity.field_70126_B, entity.field_70177_z);
            matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(rotationYaw));
            matrixStack.func_227861_a_(0.0, -0.7, 0.0);
            if (isPlayerRidingInFirstPersonView) {
                matrixStack.func_227861_a_(0.0, -firstPersonYOffset, 0.0);
            }
            if (MathUtil.func_203301_d((float)planeEntity.rotationRoll, (float)0.0f) > 90.0f) {
                event.getEntity().field_70759_as = planeEntity.field_70177_z * 2.0f - event.getEntity().field_70759_as;
            }
            if (MathUtil.func_203301_d((float)planeEntity.prevRotationRoll, (float)0.0f) > 90.0f) {
                event.getEntity().field_70758_at = planeEntity.field_70126_B * 2.0f - event.getEntity().field_70758_at;
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onRenderPost(RenderLivingEvent.Post event) {
        if (playerRotationNeedToPop) {
            playerRotationNeedToPop = false;
            event.getMatrixStack().func_227865_b_();
            Entity entity = event.getEntity().func_184208_bv();
            PlaneEntity planeEntity = (PlaneEntity)entity;
            if (MathUtil.func_203301_d((float)planeEntity.rotationRoll, (float)0.0f) > 90.0f) {
                event.getEntity().field_70759_as = planeEntity.field_70177_z * 2.0f - event.getEntity().field_70759_as;
            }
            if (MathUtil.func_203301_d((float)planeEntity.prevRotationRoll, (float)0.0f) > 90.0f) {
                event.getEntity().field_70758_at = planeEntity.field_70126_B * 2.0f - event.getEntity().field_70758_at;
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onClientPlayerTick(TickEvent.PlayerTickEvent event) {
        PlayerEntity player = event.player;
        if (event.phase == TickEvent.Phase.END && player instanceof ClientPlayerEntity) {
            if (player.func_184187_bx() instanceof PlaneEntity) {
                PlaneEntity planeEntity = (PlaneEntity)player.func_184187_bx();
                if (Minecraft.func_71410_x().field_71474_y.field_243228_bb == PointOfView.FIRST_PERSON) {
                    float yawDiff = planeEntity.field_70177_z - planeEntity.field_70126_B;
                    player.field_70177_z += yawDiff;
                    float relativePlayerYaw = MathHelper.func_76142_g((float)(player.field_70177_z - planeEntity.field_70177_z));
                    float clampedRelativePlayerYaw = MathHelper.func_76131_a((float)relativePlayerYaw, (float)-105.0f, (float)105.0f);
                    float diff = clampedRelativePlayerYaw - relativePlayerYaw;
                    player.field_70126_B += diff;
                    player.field_70177_z += diff;
                    player.func_70034_d(player.field_70177_z);
                    relativePlayerYaw = MathHelper.func_76142_g((float)(player.field_70125_A - 0.0f));
                    clampedRelativePlayerYaw = MathHelper.func_76131_a((float)relativePlayerYaw, (float)-50.0f, (float)50.0f);
                    float perc = (clampedRelativePlayerYaw - relativePlayerYaw) * 0.5f;
                    player.field_70127_C += perc;
                    player.field_70125_A += perc;
                } else {
                    planeEntity.applyYawToEntity((Entity)player);
                }
                boolean isSprinting = SimplePlanesMod.keyBind.func_151470_d();
                ClientPlayerEntity clientPlayerEntity = (ClientPlayerEntity)player;
                if (isSprinting != old_sprint || Math.random() < 0.1) {
                    PlaneNetworking.INSTANCE.sendToServer((Object)isSprinting);
                }
                old_sprint = isSprinting;
            } else {
                old_sprint = false;
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onCameraSetup(EntityViewRenderEvent.CameraSetup event) {
        Entity entity = event.getInfo().func_216773_g();
        if (entity instanceof ClientPlayerEntity && entity.func_184187_bx() instanceof PlaneEntity) {
            PlaneEntity planeEntity = (PlaneEntity)entity.func_184187_bx();
            ClientPlayerEntity playerEntity = (ClientPlayerEntity)entity;
            if (!event.getInfo().func_216770_i()) {
                double partialTicks = event.getRenderPartialTicks();
                Quaternion q_prev = planeEntity.getQ_Prev();
                int max = 105;
                float diff = MathHelper.func_76131_a((float)MathUtil.func_203302_c((float)planeEntity.field_70126_B, (float)playerEntity.field_70126_B), (float)(-max), (float)max);
                float pitch = MathHelper.func_76131_a((float)event.getPitch(), (float)-45.0f, (float)45.0f);
                q_prev.func_195890_a(Vector3f.field_229181_d_.func_229187_a_(diff));
                q_prev.func_195890_a(Vector3f.field_229179_b_.func_229187_a_(pitch));
                MathUtil.EulerAngles angles_prev = MathUtil.toEulerAngles(q_prev);
                Quaternion q_client = planeEntity.getQ_Client();
                diff = MathHelper.func_76131_a((float)MathUtil.func_203302_c((float)planeEntity.field_70177_z, (float)playerEntity.field_70177_z), (float)(-max), (float)max);
                q_client.func_195890_a(Vector3f.field_229181_d_.func_229187_a_(diff));
                q_client.func_195890_a(Vector3f.field_229179_b_.func_229187_a_(pitch));
                MathUtil.EulerAngles angles = MathUtil.toEulerAngles(q_client);
                event.setPitch(-((float)MathUtil.lerpAngle180(partialTicks, angles_prev.pitch, angles.pitch)));
                event.setYaw((float)MathUtil.lerpAngle(partialTicks, angles_prev.yaw, angles.yaw));
                event.setRoll(-((float)MathUtil.lerpAngle(partialTicks, angles_prev.roll, angles.roll)));
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void fovModifier(EntityViewRenderEvent.FOVModifier event) {
        Entity entity = event.getInfo().func_216773_g();
        if (!(entity instanceof ClientPlayerEntity) || !(entity.func_184187_bx() instanceof PlaneEntity) || event.getInfo().func_216770_i()) {
            // empty if block
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void planeInventory(GuiOpenEvent event) {
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        if (event.getGui() instanceof InventoryScreen && player.func_184187_bx() instanceof PlaneEntity) {
            PlaneEntity plane = (PlaneEntity)player.func_184187_bx();
            Upgrade chest = plane.upgrades.getOrDefault(SimplePlanesUpgrades.CHEST.getId(), null);
            if (chest instanceof ChestUpgrade) {
                ChestUpgrade chest1 = (ChestUpgrade)chest;
                IInventory inventory = chest1.inventory;
                if (inventory != null) {
                    event.setCanceled(true);
                    PlaneNetworking.OPEN_INVENTORY.sendToServer((Object)true);
                }
            }
        }
    }
}

