/*
 * Decompiled with CFR 0.152.
 */
package xyz.przemyk.simpleplanes;

import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.EntityType;
import net.minecraft.util.DamageSource;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLPaths;
import xyz.przemyk.simpleplanes.Config;
import xyz.przemyk.simpleplanes.handler.PlaneNetworking;
import xyz.przemyk.simpleplanes.render.HelicopterRenderer;
import xyz.przemyk.simpleplanes.render.LargePlaneRenderer;
import xyz.przemyk.simpleplanes.render.MegaPlaneRenderer;
import xyz.przemyk.simpleplanes.render.PlaneGui;
import xyz.przemyk.simpleplanes.render.PlaneRenderer;
import xyz.przemyk.simpleplanes.setup.SimplePlanesBlocks;
import xyz.przemyk.simpleplanes.setup.SimplePlanesDataSerializers;
import xyz.przemyk.simpleplanes.setup.SimplePlanesEntities;
import xyz.przemyk.simpleplanes.setup.SimplePlanesIntegrations;
import xyz.przemyk.simpleplanes.setup.SimplePlanesItems;
import xyz.przemyk.simpleplanes.setup.SimplePlanesSounds;
import xyz.przemyk.simpleplanes.setup.SimplePlanesUpgrades;

@Mod(value="simpleplanes")
public class SimplePlanesMod {
    public static final String MODID = "simpleplanes";
    public static final DamageSource DAMAGE_SOURCE_PLANE_CRASH = new DamageSource("plain_crash").func_76348_h();
    @OnlyIn(value=Dist.CLIENT)
    public static KeyBinding keyBind;

    public SimplePlanesMod() {
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, Config.CONFIG);
        Config.loadConfig(Config.CONFIG, FMLPaths.CONFIGDIR.get().resolve("simpleplanes-common.toml"));
        SimplePlanesEntities.init();
        SimplePlanesBlocks.init();
        SimplePlanesItems.init();
        SimplePlanesUpgrades.init();
        SimplePlanesSounds.init();
        SimplePlanesDataSerializers.init();
        PlaneNetworking.init();
        SimplePlanesIntegrations.init();
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::commonSetup);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::clientSetup);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
    }

    private void clientSetup(FMLClientSetupEvent event) {
        RenderingRegistry.registerEntityRenderingHandler((EntityType)((EntityType)SimplePlanesEntities.PLANE.get()), PlaneRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler((EntityType)((EntityType)SimplePlanesEntities.LARGE_PLANE.get()), LargePlaneRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler((EntityType)((EntityType)SimplePlanesEntities.HELICOPTER.get()), HelicopterRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler((EntityType)((EntityType)SimplePlanesEntities.MEGA_PLANE.get()), MegaPlaneRenderer::new);
        MinecraftForge.EVENT_BUS.register((Object)new PlaneGui());
        keyBind = new KeyBinding("key.plane_boost.desc", 32, "key.simpleplanes.category");
        ClientRegistry.registerKeyBinding((KeyBinding)keyBind);
    }
}

