/*
 * Decompiled with CFR 0.152.
 */
package xyz.przemyk.simpleplanes.entities;

import java.util.Map;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.Pose;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.world.World;
import net.minecraftforge.registries.ForgeRegistries;
import xyz.przemyk.simpleplanes.PlaneMaterial;
import xyz.przemyk.simpleplanes.entities.LargePlaneEntity;
import xyz.przemyk.simpleplanes.entities.PlaneEntity;
import xyz.przemyk.simpleplanes.upgrades.Upgrade;
import xyz.przemyk.simpleplanes.upgrades.UpgradeType;

public class MegaPlaneEntity
extends LargePlaneEntity {
    public static final EntitySize FLYING_SIZE = EntitySize.func_220314_b((float)6.0f, (float)1.5f);
    public static final EntitySize FLYING_SIZE_EASY = EntitySize.func_220314_b((float)6.0f, (float)2.5f);

    public MegaPlaneEntity(EntityType<? extends LargePlaneEntity> entityTypeIn, World worldIn) {
        super(entityTypeIn, worldIn);
    }

    public MegaPlaneEntity(EntityType<? extends LargePlaneEntity> entityTypeIn, World worldIn, PlaneMaterial material, double x, double y, double z) {
        super(entityTypeIn, worldIn, material, x, y, z);
    }

    @Override
    public EntitySize func_213305_a(Pose poseIn) {
        if (this.func_184179_bs() instanceof PlayerEntity) {
            return this.isEasy() ? FLYING_SIZE_EASY : FLYING_SIZE;
        }
        return super.func_213305_a(poseIn);
    }

    public MegaPlaneEntity(EntityType<? extends LargePlaneEntity> entityTypeIn, World worldIn, PlaneMaterial material) {
        super(entityTypeIn, worldIn, material);
    }

    @Override
    public boolean canAddUpgrade(UpgradeType upgradeType) {
        if (upgradeType.occupyBackSeat && this.isFull()) {
            return false;
        }
        return !this.upgrades.containsKey(upgradeType.getRegistryName()) && upgradeType.isPlaneApplicable(this);
    }

    @Override
    public int getFuelCost(PlaneEntity.Vars vars) {
        return super.getFuelCost(vars) * 2;
    }

    @Override
    protected float getGroundPitch() {
        return 4.0f;
    }

    @Override
    protected boolean isEasy() {
        return true;
    }

    @Override
    public void func_184232_k(Entity passenger) {
        super.func_184232_k(passenger);
        Vector3f pos = this.transformPos(this.getPassengerPos(passenger));
        passenger.func_70107_b(this.func_226277_ct_() + (double)pos.func_195899_a(), this.func_226278_cu_() + (double)pos.func_195900_b(), this.func_226281_cx_() + (double)pos.func_195902_c());
    }

    @Override
    public void updatePassengerTwo(Entity passenger) {
    }

    @Override
    protected Item getItem() {
        return (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("simpleplanes", this.getMaterial().name + "_mega_plane"));
    }

    @Override
    public double getCameraDistanceMultiplayer() {
        return 2.0;
    }

    @Override
    protected PlaneEntity.Vars getMotionVars() {
        PlaneEntity.Vars motionVars = super.getMotionVars();
        motionVars.max_push_speed *= 0.8;
        motionVars.yaw_multiplayer = (float)((double)motionVars.yaw_multiplayer * 0.3);
        motionVars.drag *= 4.0;
        motionVars.drag_mul *= 4.0;
        motionVars.drag_quad *= 4.0;
        return motionVars;
    }

    @Override
    protected void tickPitch(PlaneEntity.Vars vars) {
        float pitch = 0.0f;
        if (vars.moveForward > 0.0f) {
            pitch = vars.passengerSprinting ? 0.8f : 0.4f;
        } else if (vars.moveForward < 0.0f) {
            float f = pitch = vars.passengerSprinting ? -0.8f : -0.4f;
        }
        if (this.getOnGround() || this.isAboveWater()) {
            pitch *= 2.0f;
        }
        this.field_70125_A += pitch;
        if (this.field_70125_A > 20.0f) {
            this.field_70125_A = 20.0f;
        }
    }

    private Vector3f getPassengerPos(Entity passenger) {
        int i = this.func_184188_bt().indexOf(passenger);
        float z = (float)(-(i / 2)) * 1.5f;
        return new Vector3f(-0.5f + (float)(i % 2), (float)(this.func_70042_X() + passenger.func_70033_W()), z + 1.0f);
    }

    @Override
    public double func_70042_X() {
        return 0.4;
    }

    @Override
    protected int getLandingAngle() {
        return 20;
    }

    @Override
    protected boolean func_184219_q(Entity passenger) {
        return !this.isFull() && passenger.func_184187_bx() != this && !(passenger instanceof PlaneEntity);
    }

    @Override
    public boolean isFull() {
        int i = 0;
        for (Map.Entry entry : this.upgrades.entrySet()) {
            ResourceLocation resourceLocation = (ResourceLocation)entry.getKey();
            Upgrade value = (Upgrade)entry.getValue();
            if (!value.getType().occupyBackSeat) continue;
            i += value.getSeats();
        }
        i = (i + 1) / 4 + i / 4;
        return this.func_184188_bt().size() + i >= 6;
    }
}

