/*
 * Decompiled with CFR 0.152.
 */
package xyz.przemyk.simpleplanes.integration;

import com.mojang.blaze3d.matrix.MatrixStack;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.ObjectHolder;
import vazkii.botania.api.mana.ManaItemHandler;
import xyz.przemyk.simpleplanes.Config;
import xyz.przemyk.simpleplanes.PlaneMaterial;
import xyz.przemyk.simpleplanes.entities.HelicopterEntity;
import xyz.przemyk.simpleplanes.entities.LargePlaneEntity;
import xyz.przemyk.simpleplanes.entities.PlaneEntity;
import xyz.przemyk.simpleplanes.integration.IModIntegration;
import xyz.przemyk.simpleplanes.items.InformationItem;
import xyz.przemyk.simpleplanes.items.PlaneItem;
import xyz.przemyk.simpleplanes.setup.SimplePlanesEntities;
import xyz.przemyk.simpleplanes.setup.SimplePlanesItems;
import xyz.przemyk.simpleplanes.setup.SimplePlanesMaterials;
import xyz.przemyk.simpleplanes.upgrades.Upgrade;
import xyz.przemyk.simpleplanes.upgrades.UpgradeType;
import xyz.przemyk.simpleplanes.upgrades.energy.AbstractEngine;

public class BotaniaIntegration
implements IModIntegration {
    @ObjectHolder(value="simpleplanes:mana")
    public static final PlaneMaterial MANA = null;
    public static UpgradeType MANA_UPGRADE;
    RegistryObject<Item> MANA_UPGRADE_ITEM = null;

    @Override
    public void init() {
        System.out.println("Botania To The Sky");
        String name = "mana";
        SimplePlanesItems.ITEMS.register(name + "_plane", () -> new PlaneItem(new Item.Properties().func_200916_a(SimplePlanesItems.SIMPLE_PLANES_ITEM_GROUP), world -> {
            PlaneEntity planeEntity = new PlaneEntity((EntityType<? extends PlaneEntity>)((EntityType)SimplePlanesEntities.PLANE.get()), (World)world, SimplePlanesMaterials.getMaterial(name));
            this.add_mana(planeEntity);
            return planeEntity;
        }));
        SimplePlanesItems.ITEMS.register(name + "_large_plane", () -> new PlaneItem(new Item.Properties().func_200916_a(SimplePlanesItems.SIMPLE_PLANES_ITEM_GROUP), world -> {
            LargePlaneEntity planeEntity = new LargePlaneEntity((EntityType<? extends LargePlaneEntity>)((EntityType)SimplePlanesEntities.LARGE_PLANE.get()), (World)world, SimplePlanesMaterials.getMaterial(name));
            this.add_mana(planeEntity);
            return planeEntity;
        }));
        SimplePlanesItems.ITEMS.register(name + "_helicopter", () -> new PlaneItem(new Item.Properties().func_200916_a(SimplePlanesItems.SIMPLE_PLANES_ITEM_GROUP), world -> {
            HelicopterEntity planeEntity = new HelicopterEntity((EntityType<? extends HelicopterEntity>)((EntityType)SimplePlanesEntities.HELICOPTER.get()), (World)world, SimplePlanesMaterials.getMaterial(name));
            this.add_mana(planeEntity);
            return planeEntity;
        }));
        this.MANA_UPGRADE_ITEM = SimplePlanesItems.ITEMS.register("mana_upgrade", () -> new InformationItem((ITextComponent)new TranslationTextComponent("description.simpleplanes.mana_upgrade")));
        FMLJavaModLoadingContext.get().getModEventBus().register((Object)this);
    }

    private void add_mana(PlaneEntity planeEntity) {
        Upgrade upgrade = BotaniaIntegration.MANA_UPGRADE.instanceSupplier.apply(planeEntity);
        upgrade.onApply(null, null);
        planeEntity.upgrades.put(MANA_UPGRADE.getRegistryName(), upgrade);
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void registerUpgrade(RegistryEvent.Register<UpgradeType> event) {
        MANA_UPGRADE = new UpgradeType((Item)this.MANA_UPGRADE_ITEM.get(), ManaUpgrade::new){

            @Override
            public boolean isPlaneApplicable(PlaneEntity planeEntity) {
                return !planeEntity.func_230279_az_();
            }
        };
        MANA_UPGRADE.setRegistryName("mana");
        event.getRegistry().register((IForgeRegistryEntry)MANA_UPGRADE);
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void registerMaterial(RegistryEvent.Register<PlaneMaterial> event) {
        String name = "mana";
        event.getRegistry().register(new PlaneMaterial(name, false).setRegistryName("simpleplanes", name));
    }

    public static class ManaUpgrade
    extends AbstractEngine {
        public ManaUpgrade(UpgradeType type, PlaneEntity planeEntity) {
            super(type, planeEntity);
        }

        public ManaUpgrade(PlaneEntity planeEntity) {
            super(MANA_UPGRADE, planeEntity);
        }

        @Override
        public NonNullList<ItemStack> getDrops() {
            return NonNullList.func_191196_a();
        }

        @Override
        public boolean tick() {
            if (this.planeEntity.field_70170_p.field_72995_K) {
                return false;
            }
            PlayerEntity player = this.planeEntity.getPlayer();
            if (this.planeEntity.getFuel() <= 0 && player != null) {
                ItemStack itemStack = this.planeEntity.getItemStack();
                boolean got_mana = ((ManaItemHandler)ManaItemHandler.INSTANCE.func_179281_c()).requestManaExactForTool(itemStack, player, ((Integer)Config.MANA_COST.get()).intValue(), true);
                if (got_mana) {
                    this.planeEntity.addFuelMaxed((Integer)Config.FLY_TICKS_PER_MANA.get());
                }
            }
            return false;
        }

        @Override
        public void onApply(ItemStack itemStack, PlayerEntity playerEntity) {
            super.onApply(itemStack, playerEntity);
            this.planeEntity.setMaterial("mana");
        }

        @Override
        public void render(MatrixStack matrixStack, IRenderTypeBuffer buffer, int packedLight, float partialticks) {
        }
    }
}

