/*
 * Decompiled with CFR 0.152.
 */
package xyz.przemyk.simpleplanes.integration.energy;

import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import xyz.przemyk.simpleplanes.Config;
import xyz.przemyk.simpleplanes.entities.PlaneEntity;
import xyz.przemyk.simpleplanes.integration.energy.NbtEnergyStorage;
import xyz.przemyk.simpleplanes.setup.SimplePlanesBlocks;
import xyz.przemyk.simpleplanes.setup.SimplePlanesUpgrades;

public class ChargerTileEntity
extends TileEntity
implements ITickableTileEntity {
    private LazyOptional<IEnergyStorage> energy = LazyOptional.of(() -> new NbtEnergyStorage((Integer)Config.ENERGY_COST.get() * 10));

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (CapabilityEnergy.ENERGY == cap) {
            return this.energy.cast();
        }
        return super.getCapability(cap, side);
    }

    public ChargerTileEntity() {
        super((TileEntityType)SimplePlanesBlocks.CHARGER_TILE.get());
    }

    public void func_73660_a() {
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
            this.energy.ifPresent(energy -> {
                AtomicInteger capacity = new AtomicInteger(energy.getEnergyStored());
                NbtEnergyStorage energyStorage = (NbtEnergyStorage)((Object)energy);
                Integer cost = (Integer)Config.ENERGY_COST.get();
                List planes = this.field_145850_b.func_175647_a(PlaneEntity.class, new AxisAlignedBB(this.field_174879_c, this.field_174879_c).func_186662_g(5.0), playerEntity -> true);
                for (PlaneEntity planeEntity : planes) {
                    if (!planeEntity.upgrades.containsKey(SimplePlanesUpgrades.POWER_CELL.getId())) continue;
                    if (planeEntity.getFuel() < (Integer)Config.FLY_TICKS_PER_COAL.get() * 10) {
                        if (energyStorage.getEnergyStored() <= cost) continue;
                        planeEntity.addFuel((Integer)Config.ENERGY_FLY_TICKS.get());
                        capacity.addAndGet(-cost.intValue());
                        energyStorage.consumeEnergy(cost);
                        continue;
                    }
                    System.out.println("full");
                }
            });
        }
    }

    public void func_230337_a_(BlockState state, CompoundNBT compound) {
        CompoundNBT energyTag = compound.func_74775_l("energy");
        this.energy.ifPresent(h -> ((INBTSerializable)h).deserializeNBT((INBT)energyTag));
        super.func_230337_a_(state, compound);
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        this.energy.ifPresent(h -> {
            CompoundNBT tag = (CompoundNBT)((INBTSerializable)h).serializeNBT();
            compound.func_218657_a("energy", (INBT)tag);
        });
        return super.func_189515_b(compound);
    }
}

