/*
 * Decompiled with CFR 0.152.
 */
package xyz.przemyk.simpleplanes.render;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.settings.PointOfView;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Quaternion;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3f;
import xyz.przemyk.simpleplanes.MathUtil;
import xyz.przemyk.simpleplanes.entities.PlaneEntity;
import xyz.przemyk.simpleplanes.render.BackSeatBlockModel;
import xyz.przemyk.simpleplanes.render.PropellerModel;
import xyz.przemyk.simpleplanes.upgrades.Upgrade;

public abstract class AbstractPlaneRenderer<T extends PlaneEntity>
extends EntityRenderer<T> {
    protected EntityModel<PlaneEntity> propellerModel = new PropellerModel();

    protected AbstractPlaneRenderer(EntityRendererManager renderManager) {
        super(renderManager);
    }

    public Vector3d getRenderOffset(T entityIn, float partialTicks) {
        ClientPlayerEntity playerEntity;
        if (Minecraft.func_71410_x().field_71439_g != null && (playerEntity = Minecraft.func_71410_x().field_71439_g) == ((PlaneEntity)((Object)entityIn)).func_184179_bs() && Minecraft.func_71410_x().field_71474_y.field_243228_bb == PointOfView.FIRST_PERSON) {
            return new Vector3d(0.0, 0.0, 0.0);
        }
        return super.func_225627_b_(entityIn, partialTicks);
    }

    public void render(T planeEntity, float entityYaw, float partialTicks, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int packedLightIn) {
        boolean isPlayerRidingInFirstPersonView;
        matrixStackIn.func_227860_a_();
        matrixStackIn.func_227861_a_(0.0, 0.375, 0.0);
        matrixStackIn.func_227862_a_(-1.0f, -1.0f, 1.0f);
        matrixStackIn.func_227861_a_(0.0, -0.5, 0.0);
        matrixStackIn.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(180.0f));
        double firstPersonYOffset = -0.7;
        boolean bl = isPlayerRidingInFirstPersonView = Minecraft.func_71410_x().field_71439_g != null && planeEntity.func_184196_w((Entity)Minecraft.func_71410_x().field_71439_g) && Minecraft.func_71410_x().field_71474_y.field_243228_bb == PointOfView.FIRST_PERSON;
        if (isPlayerRidingInFirstPersonView) {
            matrixStackIn.func_227861_a_(0.0, firstPersonYOffset, 0.0);
        }
        Quaternion q = MathUtil.lerpQ(partialTicks, ((PlaneEntity)((Object)planeEntity)).getQ_Prev(), ((PlaneEntity)((Object)planeEntity)).getQ_Client());
        matrixStackIn.func_227863_a_(q);
        float rockingAngle = ((PlaneEntity)((Object)planeEntity)).getRockingAngle(partialTicks);
        if (!MathHelper.func_180185_a((float)rockingAngle, (float)0.0f)) {
            matrixStackIn.func_227863_a_(new Quaternion(new Vector3f(1.0f, 0.0f, 1.0f), rockingAngle, true));
        }
        float f = (float)((PlaneEntity)((Object)planeEntity)).getTimeSinceHit() - partialTicks;
        float f1 = ((PlaneEntity)((Object)planeEntity)).getDamageTaken() - partialTicks;
        if (f1 < 0.1f) {
            f1 = 0.1f;
        }
        if (f > 0.0f) {
            float angle = MathUtil.func_76131_a((float)(f * f1 / 200.0f), (float)-30.0f, (float)30.0f);
            f = (float)((PlaneEntity)((Object)planeEntity)).field_70173_aa + partialTicks;
            matrixStackIn.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(MathHelper.func_76126_a((float)f) * angle));
        }
        matrixStackIn.func_227861_a_(0.0, -0.6, 0.0);
        if (isPlayerRidingInFirstPersonView) {
            matrixStackIn.func_227861_a_(0.0, -firstPersonYOffset, 0.0);
        }
        EntityModel<T> planeModel = this.getModel();
        boolean enchanted_plane = ((PlaneEntity)((Object)planeEntity)).getHealth() > ((PlaneEntity)((Object)planeEntity)).getMaxHealth();
        IVertexBuilder ivertexbuilder = ItemRenderer.func_239386_a_((IRenderTypeBuffer)bufferIn, (RenderType)planeModel.func_228282_a_(this.func_110775_a((Entity)planeEntity)), (boolean)false, (boolean)enchanted_plane);
        planeModel.func_225597_a_(planeEntity, partialTicks, 0.0f, 0.0f, 0.0f, 0.0f);
        planeModel.func_225598_a_(matrixStackIn, ivertexbuilder, packedLightIn, OverlayTexture.field_229196_a_, 1.0f, 1.0f, 1.0f, 1.0f);
        int seat = 0;
        for (Upgrade upgrade : ((PlaneEntity)((Object)planeEntity)).upgrades.values()) {
            matrixStackIn.func_227860_a_();
            if (upgrade.getType().occupyBackSeat) {
                for (int i = 0; i < upgrade.getSeats(); ++i) {
                    matrixStackIn.func_227860_a_();
                    BackSeatBlockModel.moveMatrix(planeEntity, matrixStackIn, seat);
                    upgrade.render(matrixStackIn, bufferIn, packedLightIn, partialTicks);
                    ++seat;
                    matrixStackIn.func_227865_b_();
                }
            } else {
                upgrade.render(matrixStackIn, bufferIn, packedLightIn, partialTicks);
            }
            matrixStackIn.func_227865_b_();
        }
        String resourceName = ((PlaneEntity)((Object)planeEntity)).getMaterial().fireResistant ? "textures/block/netherite_block.png" : "textures/block/iron_block.png";
        ivertexbuilder = ItemRenderer.func_239386_a_((IRenderTypeBuffer)bufferIn, (RenderType)planeModel.func_228282_a_(new ResourceLocation(resourceName)), (boolean)false, (boolean)planeEntity.func_189652_ae());
        this.propellerModel.func_225597_a_(planeEntity, partialTicks, 0.0f, 0.0f, 0.0f, 0.0f);
        this.propellerModel.func_225598_a_(matrixStackIn, ivertexbuilder, packedLightIn, OverlayTexture.field_229196_a_, 1.0f, 1.0f, 1.0f, 1.0f);
        matrixStackIn.func_227860_a_();
        this.renderAdditional(planeEntity, partialTicks, matrixStackIn, bufferIn, packedLightIn);
        matrixStackIn.func_227865_b_();
        matrixStackIn.func_227865_b_();
        super.func_225623_a_(planeEntity, 0.0f, partialTicks, matrixStackIn, bufferIn, packedLightIn);
    }

    protected void renderAdditional(T planeEntity, float partialTicks, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int packedLightIn) {
    }

    protected abstract EntityModel<T> getModel();
}

