/*
 * Decompiled with CFR 0.152.
 */
package xyz.przemyk.simpleplanes.render;

import com.mojang.blaze3d.matrix.MatrixStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import xyz.przemyk.simpleplanes.SimplePlanesMod;
import xyz.przemyk.simpleplanes.entities.HelicopterEntity;
import xyz.przemyk.simpleplanes.entities.PlaneEntity;

@OnlyIn(value=Dist.CLIENT)
@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class PlaneGui
extends AbstractGui {
    private final ResourceLocation bar = new ResourceLocation("simpleplanes", "textures/gui/hpbar.png");
    private final int tex_width = 182;
    private final int tex_height = 5;
    private final int bar_width = 182;
    private final int bar_height = 6;

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void renderGameOverlayPre(RenderGameOverlayEvent.Pre event) {
        Minecraft mc = Minecraft.func_71410_x();
        int scaledWidth = mc.func_228018_at_().func_198107_o();
        int scaledHeight = mc.func_228018_at_().func_198087_p();
        MatrixStack mStack = event.getMatrixStack();
        if (mc.field_71439_g.func_184187_bx() instanceof PlaneEntity) {
            PlaneEntity planeEntity = (PlaneEntity)mc.field_71439_g.func_184187_bx();
            if (event.getType() == RenderGameOverlayEvent.ElementType.ALL && planeEntity.mountmassage) {
                planeEntity.mountmassage = false;
                if (planeEntity instanceof HelicopterEntity) {
                    Minecraft.func_71410_x().field_71456_v.func_175188_a((ITextComponent)new TranslationTextComponent("helicopter.onboard", new Object[]{mc.field_71474_y.field_228046_af_.func_238171_j_(), SimplePlanesMod.keyBind.func_238171_j_()}), false);
                } else {
                    Minecraft.func_71410_x().field_71456_v.func_175188_a((ITextComponent)new TranslationTextComponent("plane.onboard", new Object[]{mc.field_71474_y.field_228046_af_.func_238171_j_(), SimplePlanesMod.keyBind.func_238171_j_()}), false);
                }
            }
            if (event.getType() == RenderGameOverlayEvent.ElementType.EXPERIENCE) {
                event.setCanceled(true);
                int x = scaledWidth / 2 - 91;
                int y = scaledHeight - 32 + 3;
                mc.func_110434_K().func_110577_a(this.bar);
                float fuel = planeEntity.getFuel();
                float max_fuel = planeEntity.getMaxFuel();
                float part = fuel / max_fuel;
                part = (float)Math.pow(part, 0.5);
                part = MathHelper.func_76131_a((float)part, (float)0.0f, (float)1.0f);
                int currentWidth = (int)(182.0f * part);
                this.func_238474_b_(mStack, x, y, 0, 0, 182, 5);
                int bar_image_pos = planeEntity.func_70051_ag() ? 10 : 5;
                this.func_238474_b_(mStack, x, y, 0, bar_image_pos, currentWidth, 5);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void renderGameOverlayPost(RenderGameOverlayEvent.Post event) {
        Minecraft mc = Minecraft.func_71410_x();
        int scaledWidth = mc.func_228018_at_().func_198107_o();
        int scaledHeight = mc.func_228018_at_().func_198087_p();
        MatrixStack mStack = event.getMatrixStack();
        if (mc.field_71439_g.func_184187_bx() instanceof PlaneEntity) {
            PlaneEntity planeEntity = (PlaneEntity)mc.field_71439_g.func_184187_bx();
            if (event.getType() == RenderGameOverlayEvent.ElementType.ALL) {
                mc.func_110434_K().func_110577_a(this.bar);
                int left_align = scaledWidth / 2 + 91;
                int health = (int)Math.ceil(planeEntity.getHealth());
                float healthMax = planeEntity.getMaxHealth();
                int hearts = (int)healthMax;
                if (hearts > 10) {
                    hearts = 10;
                }
                boolean FULL = false;
                int EMPTY = 16;
                int GOLD = 32;
                int right_height = 39;
                int max_row_size = 5;
                int heart = 0;
                while (hearts > 0) {
                    int top = scaledHeight - right_height;
                    int rowCount = Math.min(hearts, max_row_size);
                    hearts -= rowCount;
                    for (int i = 0; i < rowCount; ++i) {
                        int x = left_align - i * 16 - 16;
                        if (i + heart + 10 < health) {
                            this.func_238474_b_(mStack, x, top, 32, 15, 16, 9);
                            continue;
                        }
                        if (i + heart < health) {
                            this.func_238474_b_(mStack, x, top, 0, 15, 16, 9);
                            continue;
                        }
                        this.func_238474_b_(mStack, x, top, 16, 15, 16, 9);
                    }
                    right_height += 10;
                    heart += max_row_size;
                }
            }
        }
    }
}

