/*
 * Decompiled with CFR 0.152.
 */
package xyz.przemyk.simpleplanes.setup;

import net.minecraft.item.Item;
import net.minecraft.item.Items;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import xyz.przemyk.simpleplanes.entities.LargePlaneEntity;
import xyz.przemyk.simpleplanes.entities.MegaPlaneEntity;
import xyz.przemyk.simpleplanes.setup.SimplePlanesItems;
import xyz.przemyk.simpleplanes.upgrades.UpgradeType;
import xyz.przemyk.simpleplanes.upgrades.banner.BannerUpgradeType;
import xyz.przemyk.simpleplanes.upgrades.cloud.CloudUpgrade;
import xyz.przemyk.simpleplanes.upgrades.dragon.DragonUpgrade;
import xyz.przemyk.simpleplanes.upgrades.energy.CoalEngine;
import xyz.przemyk.simpleplanes.upgrades.energy.FurnceJunkEngine;
import xyz.przemyk.simpleplanes.upgrades.energy.LavaEngine;
import xyz.przemyk.simpleplanes.upgrades.energy.PowerCell;
import xyz.przemyk.simpleplanes.upgrades.floating.FloatingUpgrade;
import xyz.przemyk.simpleplanes.upgrades.folding.FoldingUpgrade;
import xyz.przemyk.simpleplanes.upgrades.heal.HealUpgrade;
import xyz.przemyk.simpleplanes.upgrades.paint.PaintUpgradeType;
import xyz.przemyk.simpleplanes.upgrades.rocket.RocketUpgrade;
import xyz.przemyk.simpleplanes.upgrades.shooter.ShooterUpgrade;
import xyz.przemyk.simpleplanes.upgrades.sprayer.SprayerUpgrade;
import xyz.przemyk.simpleplanes.upgrades.storage.ChestUpgrade;
import xyz.przemyk.simpleplanes.upgrades.tnt.TNTUpgrade;

public class SimplePlanesUpgrades {
    public static final DeferredRegister<UpgradeType> UPGRADE_TYPES = DeferredRegister.create(UpgradeType.class, (String)"simpleplanes");
    public static final RegistryObject<UpgradeType> SPRAYER = UPGRADE_TYPES.register("sprayer", () -> new UpgradeType((Item)SimplePlanesItems.SPRAYER.get(), SprayerUpgrade::new){

        @Override
        public boolean isPlaneApplicable(MegaPlaneEntity planeEntity) {
            return false;
        }
    });
    public static final RegistryObject<UpgradeType> TNT = UPGRADE_TYPES.register("tnt", () -> new UpgradeType(Items.field_221649_bM, TNTUpgrade::new, true));
    public static final RegistryObject<UpgradeType> HEAL = UPGRADE_TYPES.register("heal", () -> new UpgradeType((Item)SimplePlanesItems.HEALING.get(), HealUpgrade::new));
    public static final RegistryObject<UpgradeType> FLOATING = UPGRADE_TYPES.register("floating", () -> new UpgradeType((Item)SimplePlanesItems.FLOATY_BEDDING.get(), FloatingUpgrade::new){

        @Override
        public boolean isPlaneApplicable(MegaPlaneEntity planeEntity) {
            return false;
        }
    });
    public static final RegistryObject<UpgradeType> BOOSTER = UPGRADE_TYPES.register("booster", () -> new UpgradeType((Item)SimplePlanesItems.BOOSTER.get(), RocketUpgrade::new){

        @Override
        public boolean isPlaneApplicable(LargePlaneEntity planeEntity) {
            return false;
        }

        @Override
        public boolean isPlaneApplicable(MegaPlaneEntity planeEntity) {
            return false;
        }
    });
    public static final RegistryObject<UpgradeType> SHOOTER = UPGRADE_TYPES.register("shooter", () -> new UpgradeType((Item)SimplePlanesItems.SHOOTER.get(), ShooterUpgrade::new){

        @Override
        public boolean isPlaneApplicable(MegaPlaneEntity planeEntity) {
            return false;
        }
    });
    public static final RegistryObject<UpgradeType> DRAGON = UPGRADE_TYPES.register("dragon", () -> new UpgradeType(Items.field_196151_dA, DragonUpgrade::new){

        @Override
        public boolean isPlaneApplicable(MegaPlaneEntity planeEntity) {
            return false;
        }
    });
    public static final RegistryObject<UpgradeType> FOLDING = UPGRADE_TYPES.register("folding", () -> new UpgradeType((Item)SimplePlanesItems.FOLDING.get(), FoldingUpgrade::new){

        @Override
        public boolean isPlaneApplicable(MegaPlaneEntity planeEntity) {
            return false;
        }
    });
    public static final RegistryObject<UpgradeType> BANNER = UPGRADE_TYPES.register("banner", BannerUpgradeType::new);
    public static final RegistryObject<UpgradeType> PAINT = UPGRADE_TYPES.register("paint", PaintUpgradeType::new);
    public static final RegistryObject<UpgradeType> CLOUD = UPGRADE_TYPES.register("cloud", () -> new UpgradeType((Item)SimplePlanesItems.CLOUD.get(), CloudUpgrade::new));
    public static final RegistryObject<UpgradeType> COAL_ENGINE = UPGRADE_TYPES.register("coal_engine", () -> new UpgradeType((Item)SimplePlanesItems.FURNACE_ENGINE.get(), CoalEngine::new));
    public static final RegistryObject<UpgradeType> SMOKER_ENGINE = UPGRADE_TYPES.register("smoker_engine", () -> new UpgradeType(Items.field_222101_pH, FurnceJunkEngine::new));
    public static final RegistryObject<UpgradeType> POWER_CELL = UPGRADE_TYPES.register("power_cell", () -> new UpgradeType(Items.field_221729_dA, PowerCell::new));
    public static final RegistryObject<UpgradeType> LAVA_ENGINE = UPGRADE_TYPES.register("lava_engine", () -> new UpgradeType(Items.field_222102_pI, LavaEngine::new));
    public static final RegistryObject<UpgradeType> CHEST = UPGRADE_TYPES.register("chest", () -> new UpgradeType(Items.field_221675_bZ, ChestUpgrade::new, true));

    public static void init() {
        UPGRADE_TYPES.register(FMLJavaModLoadingContext.get().getModEventBus());
    }
}

