/*
 * Decompiled with CFR 0.152.
 */
package xyz.przemyk.simpleplanes.upgrades.cloud;

import java.util.Random;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import xyz.przemyk.simpleplanes.setup.SimplePlanesBlocks;

public class CloudBlock
extends Block {
    public static final IntegerProperty AGE = BlockStateProperties.field_208168_U;
    protected static final VoxelShape ZERO_SHAPE = Block.func_208617_a((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)14.0, (double)15.0);
    protected static final VoxelShape ONE_SHAPE = Block.func_208617_a((double)2.0, (double)1.0, (double)2.0, (double)14.0, (double)13.0, (double)14.0);
    protected static final VoxelShape TWO_SHAPE = Block.func_208617_a((double)3.0, (double)2.0, (double)3.0, (double)13.0, (double)12.0, (double)13.0);
    protected static final VoxelShape THREE_SHAPE = Block.func_208617_a((double)4.0, (double)3.0, (double)4.0, (double)12.0, (double)11.0, (double)12.0);

    public CloudBlock() {
        super(AbstractBlock.Properties.func_200945_a((Material)Material.field_151597_y).func_200947_a(SoundType.field_185856_i).func_200948_a(1.0f, 1.0f).func_200944_c().func_200941_a(0.5f));
        this.func_180632_j((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)AGE, (Comparable)Integer.valueOf(0)));
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        switch ((Integer)state.func_177229_b((Property)AGE)) {
            case 1: {
                return ONE_SHAPE;
            }
            case 2: {
                return TWO_SHAPE;
            }
            case 3: {
                return THREE_SHAPE;
            }
        }
        return ZERO_SHAPE;
    }

    public void func_225542_b_(BlockState state, ServerWorld worldIn, BlockPos pos, Random random) {
        this.func_225534_a_(state, worldIn, pos, random);
    }

    public void func_196262_a(BlockState state, World worldIn, BlockPos pos, Entity entityIn) {
        if (entityIn.func_213322_ci().field_72448_b < 0.0) {
            entityIn.func_213295_a(state, new Vector3d(0.8, 0.3, 0.8));
        }
    }

    public boolean func_196253_a(BlockState state, BlockItemUseContext useContext) {
        return true;
    }

    public void func_225534_a_(BlockState state, ServerWorld worldIn, BlockPos pos, Random rand) {
        if (worldIn.field_72995_K) {
            return;
        }
        if (this.slightlyMelt((World)worldIn, pos)) {
            BlockPos.Mutable blockpos$mutable = new BlockPos.Mutable();
            for (Direction direction : Direction.values()) {
                blockpos$mutable.func_239622_a_((Vector3i)pos, direction);
                BlockState blockstate = worldIn.func_180495_p((BlockPos)blockpos$mutable);
                if (!blockstate.func_203425_a((Block)this)) continue;
                this.slightlyMelt((World)worldIn, (BlockPos)blockpos$mutable);
            }
        }
        worldIn.func_205220_G_().func_205360_a(pos, (Object)this, CloudBlock.getScheduledTime(rand, (Integer)state.func_177229_b((Property)AGE)));
    }

    private boolean slightlyMelt(World worldIn, BlockPos pos) {
        BlockState state = worldIn.func_180495_p(pos);
        int i = (Integer)state.func_177229_b((Property)AGE);
        if (i < 3) {
            worldIn.func_180501_a(pos, (BlockState)state.func_206870_a((Property)AGE, (Comparable)Integer.valueOf(i + 1)), 2);
            return false;
        }
        this.turnIntoAir(state, worldIn, pos);
        return true;
    }

    private boolean shouldMelt(IBlockReader worldIn, BlockPos pos, int neighborsRequired) {
        int i = 0;
        BlockPos.Mutable blockpos$mutable = new BlockPos.Mutable();
        for (Direction direction : Direction.values()) {
            blockpos$mutable.func_239622_a_((Vector3i)pos, direction);
            if (!worldIn.func_180495_p((BlockPos)blockpos$mutable).func_203425_a((Block)this) || ++i < neighborsRequired) continue;
            return false;
        }
        return true;
    }

    public boolean isLadder(BlockState state, IWorldReader world, BlockPos pos, LivingEntity entity) {
        return !entity.func_225608_bj_();
    }

    public static void placeCloud(BlockPos blockPos, World world) {
        if (world.field_72995_K) {
            return;
        }
        BlockPos.Mutable pos = blockPos.func_239590_i_();
        pos.func_189536_c(Direction.DOWN);
        int f = 2;
        for (BlockPos pos1 : BlockPos.func_218278_a((BlockPos)pos.func_177982_a(-f, -1, -f), (BlockPos)pos.func_177963_a((double)f, 0.0, (double)f))) {
            if (world.field_73012_v.nextInt(2) != 0 || !world.func_180495_p(pos1).isAir((IBlockReader)world, pos1)) continue;
            world.func_175656_a(pos1, ((Block)SimplePlanesBlocks.CLOUD.get()).func_176223_P());
            world.func_205220_G_().func_205360_a(pos1, (Object)SimplePlanesBlocks.CLOUD.get(), CloudBlock.getScheduledTime(world.field_73012_v, 0));
        }
    }

    private static int getScheduledTime(Random rand, int i) {
        return MathHelper.func_76136_a((Random)rand, (int)50, (int)100) * (5 - i);
    }

    private void turnIntoAir(BlockState state, World world, BlockPos pos) {
        world.func_217377_a(pos, false);
    }

    public void func_220069_a(BlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        super.func_220069_a(state, worldIn, pos, blockIn, fromPos, isMoving);
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{AGE});
    }

    public void func_176199_a(World worldIn, BlockPos pos, Entity entityIn) {
        if (!worldIn.field_72995_K && !entityIn.func_225608_bj_() && worldIn.field_73012_v.nextInt(20) == 0) {
            this.slightlyMelt(worldIn, pos);
        }
    }

    public void func_180658_a(World worldIn, BlockPos pos, Entity entityIn, float fallDistance) {
        entityIn.func_225503_b_(fallDistance, 0.1f);
        if (worldIn.field_73012_v.nextInt(4) == 0) {
            this.slightlyMelt(worldIn, pos);
        }
    }

    public ItemStack func_185473_a(IBlockReader worldIn, BlockPos pos, BlockState state) {
        return ItemStack.field_190927_a;
    }

    public VoxelShape func_220071_b(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        VoxelShape shape = this.func_220053_a(state, worldIn, pos, context);
        if (context.func_216378_a(shape, pos, true) && !context.func_225581_b_()) {
            return shape;
        }
        return VoxelShapes.func_197880_a();
    }
}

