/*
 * Decompiled with CFR 0.152.
 */
package xyz.przemyk.simpleplanes.upgrades.cloud;

import com.mojang.blaze3d.matrix.MatrixStack;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import xyz.przemyk.simpleplanes.entities.PlaneEntity;
import xyz.przemyk.simpleplanes.setup.SimplePlanesUpgrades;
import xyz.przemyk.simpleplanes.upgrades.Upgrade;
import xyz.przemyk.simpleplanes.upgrades.UpgradeType;
import xyz.przemyk.simpleplanes.upgrades.cloud.CloudBlock;

public class CloudUpgrade
extends Upgrade {
    private int cooldown = 16;
    private int height = 128;

    public CloudUpgrade(PlaneEntity planeEntity) {
        super((UpgradeType)SimplePlanesUpgrades.CLOUD.get(), planeEntity);
    }

    @Override
    public CompoundNBT serializeNBT() {
        CompoundNBT compoundNBT = new CompoundNBT();
        compoundNBT.func_74768_a("cooldown", this.cooldown);
        return compoundNBT;
    }

    @Override
    public void deserializeNBT(CompoundNBT compoundNBT) {
        this.cooldown = compoundNBT.func_74762_e("cooldown");
    }

    @Override
    public boolean tick() {
        if (this.cooldown <= 0 || this.planeEntity.getOnGround() && this.planeEntity.not_moving_time > 100) {
            return true;
        }
        this.planeEntity.func_213317_d(this.planeEntity.func_213322_ci().func_186678_a(0.9));
        if (this.planeEntity.field_70173_aa % 5 != 0 || this.planeEntity.field_70170_p.field_72995_K) {
            return false;
        }
        BlockPos.Mutable blockPos = this.planeEntity.func_233580_cy_().func_239590_i_();
        int planeHeight = blockPos.func_177956_o();
        if (planeHeight < this.height) {
            this.height = Math.max(planeHeight - 1, 1);
        }
        blockPos.func_185336_p(this.height);
        --this.cooldown;
        CloudBlock.placeCloud((BlockPos)blockPos, this.planeEntity.field_70170_p);
        return false;
    }

    @Override
    public void render(MatrixStack matrixStack, IRenderTypeBuffer buffer, int packedLight, float partialticks) {
    }

    @Override
    public NonNullList<ItemStack> getDrops() {
        return NonNullList.func_191196_a();
    }

    @Override
    public void onApply(ItemStack itemStack, PlayerEntity playerEntity) {
        this.height = Math.max(this.planeEntity.func_233580_cy_().func_177956_o() - 1, 1);
    }
}

