/*
 * Decompiled with CFR 0.152.
 */
package lakmoore.sel.client;

import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import lakmoore.sel.client.ClientProxy;
import lakmoore.sel.client.Config;
import lakmoore.sel.client.FMLEventHandler;
import lakmoore.sel.client.LightCache;
import lakmoore.sel.client.LightUtils;
import lakmoore.sel.client.SEL;
import lakmoore.sel.client.SELSourceContainer;
import lakmoore.sel.client.adaptors.BaseAdaptor;
import lakmoore.sel.client.adaptors.BrightAdaptor;
import lakmoore.sel.client.adaptors.CreeperAdaptor;
import lakmoore.sel.client.adaptors.EntityBurningAdaptor;
import lakmoore.sel.client.adaptors.EntityItemAdaptor;
import lakmoore.sel.client.adaptors.FloodLightAdaptor;
import lakmoore.sel.client.adaptors.MobLightAdaptor;
import lakmoore.sel.client.adaptors.PlayerOtherAdaptor;
import lakmoore.sel.client.adaptors.PlayerSelfAdaptor;
import lakmoore.sel.world.WorldSEL;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.entity.EntityOtherPlayerMP;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.entity.projectile.EntityFireball;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.common.IExtendedEntityProperties;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.PlaySoundAtEntityEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.event.world.ChunkEvent;

public class ForgeEventHandler {
    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onBlockBreak(BlockEvent.BreakEvent event) {
        FMLEventHandler.blocksToUpdate.addAll(LightUtils.getVolumeForRelight(event.x, event.y, event.z, 8));
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onBlockPlace(BlockEvent.PlaceEvent event) {
        FMLEventHandler.blocksToUpdate.addAll(LightUtils.getVolumeForRelight(event.x, event.y, event.z, 8));
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onChunkLoad(ChunkEvent.Load event) {
        if (event.world instanceof WorldSEL && SEL.enabledForDimension(ClientProxy.mcinstance.field_71439_g.field_71093_bK)) {
            Chunk chunk = event.getChunk();
            ChunkCoordIntPair coords = new ChunkCoordIntPair(chunk.field_76635_g, chunk.field_76647_h);
            if (!LightUtils.lightCache.containsKey(coords)) {
                LightUtils.lightCache.put(coords, new LightCache());
            }
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onChunkUnload(ChunkEvent.Unload event) {
        if (event.world instanceof WorldSEL) {
            Chunk chunk = event.getChunk();
            LightUtils.lightCache.remove(new ChunkCoordIntPair(chunk.field_76635_g, chunk.field_76647_h));
        }
    }

    @SubscribeEvent
    public void onDebugOverlay(RenderGameOverlayEvent.Text event) {
        if (Minecraft.func_71410_x().field_71474_y.field_74330_P) {
            event.left.add("DL " + (SEL.disabled ? "OFF" : "ON"));
            EntityClientPlayerMP player = Minecraft.func_71410_x().field_71439_g;
            WorldClient world = Minecraft.func_71410_x().field_71441_e;
            int x = (int)player.field_70165_t;
            int y = (int)player.field_70163_u;
            int z = (int)player.field_70161_v;
            Block block = world.func_147439_a(x, y, z);
            ChunkCoordIntPair coords = new ChunkCoordIntPair(x >> 4, z >> 4);
            event.left.add("Vanilla BL: " + block.getLightValue((IBlockAccess)world, x, y, z) + " SEL: " + (LightUtils.lightCache != null && LightUtils.lightCache.get(coords) != null ? (float)Math.round(10.0f * LightUtils.getEntityLightLevel((IBlockAccess)world, x, y, z)) / 10.0f + " Cached: " + (float)Math.round(10.0f * LightUtils.lightCache.get((Object)coords).lights[x & 0xF][y][z & 0xF]) / 10.0f : "Disabled for this dimension"));
            event.left.add("SEL avg blocks re-lit: " + (float)Math.round(10.0f * (float)FMLEventHandler.totalBlockCount() / (float)FMLEventHandler.counts.size()) / 10.0f);
        }
    }

    @SubscribeEvent
    public void onJoinWorld(EntityJoinWorldEvent event) {
        Entity entity = event.entity;
        if (entity == null || !entity.func_70089_S()) {
            return;
        }
        World world = entity.field_70170_p;
        if (world == null || !world.field_72995_K) {
            return;
        }
        if (!SEL.enabledForDimension(entity.field_71093_bK)) {
            return;
        }
        SELSourceContainer sources = (SELSourceContainer)entity.getExtendedProperties("sel");
        if (sources == null) {
            sources = new SELSourceContainer(entity, world);
            entity.registerExtendedProperties("sel", (IExtendedEntityProperties)sources);
        }
        if (entity instanceof EntityItem) {
            if (!Config.lightDroppedItems) {
                return;
            }
            EntityItemAdaptor adaptor = new EntityItemAdaptor((EntityItem)entity);
            sources.addLightSource(adaptor);
        } else if (entity instanceof EntityLivingBase && !(entity instanceof EntityPlayer)) {
            int value;
            int minLight = 0;
            int catchesFire = 0;
            if (Config.lightBurningEntities) {
                if (!SEL.lightValueMap.containsKey(entity.getClass())) {
                    value = Config.getMobFire(entity.getClass().getSimpleName());
                    SEL.lightValueMap.put(entity.getClass(), value != 0);
                    catchesFire = value;
                } else {
                    catchesFire = SEL.lightValueMap.get(entity.getClass()).booleanValue();
                }
            }
            if (Config.lightGlowingEntities) {
                if (!SEL.glowValueMap.containsKey(entity.getClass())) {
                    value = Config.getMobGlow(entity);
                    SEL.glowValueMap.put(entity.getClass(), value);
                    minLight = value;
                } else {
                    minLight = SEL.glowValueMap.get(entity.getClass());
                }
            }
            if (catchesFire != 0) {
                EntityBurningAdaptor adaptor = new EntityBurningAdaptor(entity);
                adaptor.minLight = minLight;
                sources.addLightSource(adaptor);
            } else if (minLight > 0) {
                BrightAdaptor adaptor = new BrightAdaptor(entity, minLight);
                sources.addLightSource(adaptor);
            }
            if (Config.lightMobEquipment) {
                MobLightAdaptor adaptor = new MobLightAdaptor((Entity)((EntityLivingBase)entity));
                sources.addLightSource(adaptor);
            }
        } else if (entity instanceof EntityArrow || entity instanceof EntityFireball) {
            if (!Config.lightFlamingArrows) {
                return;
            }
            EntityBurningAdaptor adaptor = new EntityBurningAdaptor(entity);
            sources.addLightSource(adaptor);
        } else if (entity instanceof EntityXPOrb) {
            if (!Config.lightXP) {
                return;
            }
            BrightAdaptor adaptor = new BrightAdaptor(entity, 10);
            sources.addLightSource(adaptor);
        } else if (entity instanceof EntityOtherPlayerMP) {
            if (!Config.lightOtherPlayers) {
                return;
            }
            PlayerOtherAdaptor adaptor = new PlayerOtherAdaptor((EntityPlayer)((EntityOtherPlayerMP)entity));
            sources.addLightSource(adaptor);
        } else if (entity instanceof EntityClientPlayerMP) {
            BaseAdaptor adaptor;
            if (Config.lightFloodLight) {
                adaptor = new FloodLightAdaptor(entity, Config.simpleMode);
                sources.addLightSource(adaptor);
            }
            if (!Config.lightThisPlayer) {
                return;
            }
            adaptor = new PlayerSelfAdaptor((EntityPlayer)entity);
            sources.addLightSource(adaptor);
            this.checkForOptifine();
        }
    }

    @SubscribeEvent
    public void onPlaySoundAtEntity(PlaySoundAtEntityEvent event) {
        if (!SEL.disabled && Config.lightChargingCreepers && event.name != null && event.name.equals("creeper.primed") && event.entity != null && event.entity instanceof EntityCreeper && event.entity.func_70089_S() && SEL.enabledForDimension(event.entity.field_71093_bK)) {
            SELSourceContainer sources = (SELSourceContainer)event.entity.getExtendedProperties("sel");
            if (sources == null) {
                return;
            }
            CreeperAdaptor creeper = new CreeperAdaptor((EntityCreeper)event.entity);
            sources.addLightSource(creeper);
        }
    }

    private void checkForOptifine() {
        if (FMLClientHandler.instance().hasOptifine() && !Config.optifineOverride) {
            ClientProxy.mcinstance.field_71456_v.func_146158_b().func_146227_a((IChatComponent)new ChatComponentText("Optifine is loaded.  Disabling Atomic Stryker's Dynamic Lights.  Check the config file to override."));
            SEL.disabled = true;
        }
    }
}

