/*
 * Decompiled with CFR 0.152.
 */
package lakmoore.sel.client;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import lakmoore.sel.client.LightCache;
import lakmoore.sel.client.SEL;
import lakmoore.sel.client.SELSourceContainer;
import lakmoore.sel.world.BlockPos;
import lakmoore.sel.world.DirtyRayTrace;
import net.minecraft.block.Block;
import net.minecraft.command.IEntitySelector;
import net.minecraft.entity.Entity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.Vec3;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;

public class LightUtils {
    @SideOnly(value=Side.CLIENT)
    public static HashMap<ChunkCoordIntPair, LightCache> lightCache = new HashMap();
    public static IEntitySelector selectEntityLights = new IEntitySelector(){

        public boolean func_82704_a(Entity entity) {
            return entity.getExtendedProperties("sel") != null;
        }
    };

    public static int getCombinedLight(float smoothBlockLight0to15, int combinedLight) {
        int blockLight;
        int light8bit;
        if (smoothBlockLight0to15 > 0.0f && (light8bit = (int)(smoothBlockLight0to15 * 16.0f)) > (blockLight = combinedLight & 0xFF)) {
            combinedLight &= 0xFFFFFF00;
            combinedLight |= light8bit;
        }
        return combinedLight;
    }

    public static int maxLight(int a, int b) {
        if (SEL.coloredLights) {
            if (((0x100000 | b) - a & 0x84210) > 0) {
                return a;
            }
            return b;
        }
        return Math.max(a, b);
    }

    public static float getEntityLightLevel(IBlockAccess world, int x, int y, int z) {
        float maxLight = 0.0f;
        if (SEL.disabled || world == null || world instanceof WorldServer) {
            return 0.0f;
        }
        if (world instanceof World) {
            int opacity = ((World)world).func_147439_a(x, y, z).func_149717_k();
            if (opacity > 14) {
                return 0.0f;
            }
            DirtyRayTrace rayTrace = new DirtyRayTrace(world);
            Vec3 target = Vec3.func_72443_a((double)((float)x + 0.5f), (double)((float)y + 0.5f), (double)((float)z + 0.5f));
            AxisAlignedBB bb = AxisAlignedBB.func_72330_a((double)(x - 8), (double)(y - 8), (double)(z - 8), (double)(x + 8), (double)(y + 8), (double)(z + 8));
            List entities = ((World)world).func_82733_a(Entity.class, bb, selectEntityLights);
            for (Entity entity : entities) {
                float lightValue;
                SELSourceContainer sources = (SELSourceContainer)entity.getExtendedProperties("sel");
                if (sources == null || (lightValue = (float)sources.getLastLightLevel()) <= 0.0f || (lightValue = Math.max(Math.min(lightValue - (float)opacity, 15.0f), 0.0f)) <= 0.0f) continue;
                float dx = (float)x + 0.5f - (float)entity.field_70165_t;
                float dy = (float)y + 0.5f - (float)entity.field_70163_u + entity.func_70047_e();
                float dz = (float)z + 0.5f - (float)entity.field_70161_v;
                float distSq = dx * dx + dy * dy + dz * dz;
                if (sources.isUnderwater()) {
                    distSq = (float)((double)distSq * 2.0);
                }
                if ((double)distSq > 56.25 || (lightValue = (1.0f - (float)Math.sqrt(distSq) / 7.5f) * lightValue) <= maxLight) continue;
                ArrayList<Block> blocksHit = rayTrace.rayTraceAllBlocks(Vec3.func_72443_a((double)entity.field_70165_t, (double)(entity.field_70163_u + (double)entity.func_70047_e()), (double)entity.field_70161_v), target);
                for (Block block : blocksHit) {
                    lightValue -= (float)block.func_149717_k();
                    if (!((lightValue = Math.max(0.0f, Math.min(15.0f, lightValue))) <= maxLight)) continue;
                    break;
                }
                if (lightValue <= maxLight || (maxLight = lightValue) != 15.0f) continue;
                break;
            }
        }
        return maxLight;
    }

    public static ArrayList<BlockPos> getVolumeForRelight(int x, int y, int z, int radius) {
        ArrayList<BlockPos> result = new ArrayList<BlockPos>();
        int minX = x - radius;
        int minY = y - radius;
        int minZ = z - radius;
        int maxX = x + radius;
        int maxY = y + radius;
        int maxZ = z + radius;
        for (int i = minX; i <= maxX; ++i) {
            for (int j = minY; j <= maxY; ++j) {
                for (int k = minZ; k <= maxZ; ++k) {
                    BlockPos pos = new BlockPos(i, j, k);
                    result.add(pos);
                }
            }
        }
        return result;
    }
}

