/*
 * Decompiled with CFR 0.152.
 */
package lakmoore.sel.client;

import java.util.ArrayList;
import lakmoore.sel.client.FMLEventHandler;
import lakmoore.sel.client.LightUtils;
import lakmoore.sel.client.SEL;
import lakmoore.sel.client.adaptors.BaseAdaptor;
import lakmoore.sel.world.BlockPos;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.IExtendedEntityProperties;

public class SELSourceContainer
implements IExtendedEntityProperties {
    private static Entity thePlayer = Minecraft.func_71410_x().field_71439_g;
    private static final float maxDiffNear = 0.01f;
    private static final float maxDiffFar = 1.4f;
    private static final float farDistSq = 1024.0f;
    protected World world;
    protected Entity entity;
    private ArrayList<BaseAdaptor> adaptors;
    private float maxDiff;
    private float prevX;
    private float prevY;
    private float prevZ;
    private int prevLight;
    private boolean underwater = false;

    public SELSourceContainer(Entity entity, World world) {
        this.world = world;
        this.entity = entity;
        this.adaptors = new ArrayList();
        this.prevLight = 0;
        this.prevX = (float)entity.field_70165_t;
        this.prevY = (float)entity.field_70163_u;
        this.prevZ = (float)entity.field_70161_v;
        this.checkDistanceLOD();
    }

    public void init(Entity entity, World world) {
        this.world = world;
        this.entity = entity;
    }

    public void addLightSource(BaseAdaptor adaptor) {
        this.adaptors.add(adaptor);
    }

    private int getLightLevel() {
        int light = 0;
        if (!SEL.disabled) {
            for (BaseAdaptor adaptor : this.adaptors) {
                light = LightUtils.maxLight(light, adaptor.getLightLevel());
            }
            light = Math.min(15, light);
        }
        return light;
    }

    public int getLastLightLevel() {
        return this.prevLight;
    }

    public ArrayList<BlockPos> getBlocksToUpdate() {
        ArrayList<BlockPos> result = new ArrayList<BlockPos>();
        if (this.entity == null || this.world == null) {
            return result;
        }
        float currentX = (float)this.entity.field_70165_t;
        float currentY = (float)this.entity.field_70163_u;
        float currentZ = (float)this.entity.field_70161_v;
        int lightLevel = this.getLightLevel();
        if (lightLevel == 0 && this.prevLight == 0) {
            return result;
        }
        float dX = currentX - this.prevX;
        float dY = currentY - this.prevY;
        float dZ = currentZ - this.prevZ;
        float sqDist = dX * dX + dY * dY + dZ * dZ;
        if (sqDist > this.maxDiff || lightLevel != this.prevLight) {
            this.prevLight = lightLevel;
            int radius = 8;
            int pX = (int)this.prevX;
            int pY = (int)this.prevY;
            int pZ = (int)this.prevZ;
            int cX = (int)currentX;
            int cY = (int)currentY;
            int cZ = (int)currentZ;
            result.addAll(LightUtils.getVolumeForRelight(pX, pY, pZ, radius));
            if (pX != cX || pY != cY || pZ != cZ) {
                result.addAll(LightUtils.getVolumeForRelight(cX, cY, cZ, radius));
            }
            this.prevX = currentX;
            this.prevY = currentY;
            this.prevZ = currentZ;
            this.checkDistanceLOD();
            Block block = this.world.func_147439_a(MathHelper.func_76141_d((float)currentX), MathHelper.func_76141_d((float)currentY), MathHelper.func_76141_d((float)currentZ));
            this.underwater = block == Blocks.field_150355_j;
        }
        return result;
    }

    public boolean isUnderwater() {
        return this.underwater;
    }

    public void destroy() {
        for (BaseAdaptor adaptor : this.adaptors) {
            adaptor.kill();
        }
        this.adaptors.clear();
        FMLEventHandler.blocksToUpdate.addAll(this.getBlocksToUpdate());
        this.entity = null;
        this.world = null;
    }

    public void saveNBTData(NBTTagCompound compound) {
    }

    public void loadNBTData(NBTTagCompound compound) {
    }

    private void checkDistanceLOD() {
        this.maxDiff = 0.01f;
        if (Math.pow(SELSourceContainer.thePlayer.field_70165_t - (double)this.prevX, 2.0) + Math.pow(SELSourceContainer.thePlayer.field_70163_u - (double)this.prevY, 2.0) + Math.pow(SELSourceContainer.thePlayer.field_70161_v - (double)this.prevZ, 2.0) > 1024.0) {
            this.maxDiff = 1.4f;
        }
    }
}

