/*
 * Decompiled with CFR 0.152.
 */
package lakmoore.sel.client.adaptors;

import lakmoore.sel.client.Config;
import lakmoore.sel.client.SEL;
import lakmoore.sel.client.SELSourceContainer;
import lakmoore.sel.client.adaptors.BaseAdaptor;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;

public class FloodLightAdaptor
extends BaseAdaptor {
    private EntityPlayer thePlayer;
    private final PartialLightAdaptor[] partialLights;
    private final boolean simpleMode;
    private final int freeDistance = 8;
    private final float beamStrength = 26.0f;

    public FloodLightAdaptor(Entity entity, boolean simpleMode) {
        super(entity);
        this.thePlayer = (EntityPlayer)entity;
        this.simpleMode = simpleMode;
        this.partialLights = simpleMode ? new PartialLightAdaptor[1] : new PartialLightAdaptor[5];
        for (int i = 0; i < this.partialLights.length; ++i) {
            DummyEntity dummyEntity = new DummyEntity(entity.field_70170_p);
            SELSourceContainer sources = new SELSourceContainer(dummyEntity, entity.field_70170_p);
            dummyEntity.registerExtendedProperties("sel", sources);
            this.partialLights[i] = new PartialLightAdaptor(dummyEntity);
            sources.addLightSource(this.partialLights[i]);
            this.thePlayer.field_70170_p.func_72838_d((Entity)dummyEntity);
        }
    }

    @Override
    public int getLightLevel() {
        if (this.thePlayer != null && this.thePlayer.func_70089_S() && !SEL.disabled) {
            int lightLevel = Config.floodLights.getLightFromItemStack(this.thePlayer.func_71045_bC());
            this.handleLight(this.partialLights[0], lightLevel, 0.0f, 0.0f);
            if (!this.simpleMode) {
                this.handleLight(this.partialLights[1], lightLevel, 0.0f, 8.0f);
                this.handleLight(this.partialLights[2], lightLevel, 0.0f, -8.0f);
                this.handleLight(this.partialLights[3], lightLevel, -8.0f, 0.0f);
                this.handleLight(this.partialLights[4], lightLevel, 8.0f, 0.0f);
            }
        }
        return 0;
    }

    private void handleLight(PartialLightAdaptor source, int light, float yawRot, float pitchRot) {
        if (light == 0) {
            source.lightLevel = 0;
            source.entity.func_70107_b(this.thePlayer.field_70165_t, this.thePlayer.field_70163_u, this.thePlayer.field_70161_v);
            return;
        }
        Vec3 origin = this.thePlayer.func_70666_h(1.0f);
        Vec3 look = FloodLightAdaptor.getVector(this.thePlayer.field_70177_z + yawRot, this.thePlayer.field_70125_A + pitchRot);
        look = origin.func_72441_c(look.field_72450_a * 26.0, look.field_72448_b * 26.0, look.field_72449_c * 26.0);
        MovingObjectPosition mop = this.thePlayer.field_70170_p.func_72933_a(origin, look);
        if (mop != null) {
            int dist = (int)Math.round(this.thePlayer.func_70011_f(mop.field_72307_f.field_72450_a, mop.field_72307_f.field_72448_b, mop.field_72307_f.field_72449_c));
            dist = Math.max(0, dist - 8);
            source.lightLevel = Math.max(0, light - dist);
            source.entity.func_70107_b(mop.field_72307_f.field_72450_a, mop.field_72307_f.field_72448_b, mop.field_72307_f.field_72449_c);
        } else {
            source.lightLevel = 0;
            source.entity.func_70107_b(this.thePlayer.field_70165_t, this.thePlayer.field_70163_u, this.thePlayer.field_70161_v);
        }
    }

    public static Vec3 getVector(float rotYaw, float rotPitch) {
        float f1 = MathHelper.func_76134_b((float)(-rotYaw * ((float)Math.PI / 180) - (float)Math.PI));
        float f2 = MathHelper.func_76126_a((float)(-rotYaw * ((float)Math.PI / 180) - (float)Math.PI));
        float f3 = -MathHelper.func_76134_b((float)(-rotPitch * ((float)Math.PI / 180)));
        float f4 = MathHelper.func_76126_a((float)(-rotPitch * ((float)Math.PI / 180)));
        return Vec3.func_72443_a((double)(f2 * f3), (double)f4, (double)(f1 * f3));
    }

    @Override
    public void kill() {
        super.kill();
        this.thePlayer = null;
    }

    public class DummyEntity
    extends Entity {
        public DummyEntity(World par1World) {
            super(par1World);
            this.field_70131_O = 0.0f;
            this.field_70130_N = 0.0f;
        }

        protected void func_70088_a() {
        }

        protected void func_70037_a(NBTTagCompound var1) {
        }

        protected void func_70014_b(NBTTagCompound var1) {
        }
    }

    private class PartialLightAdaptor
    extends BaseAdaptor {
        public int lightLevel;

        PartialLightAdaptor(Entity entity) {
            super(entity);
            this.lightLevel = 0;
        }

        @Override
        public int getLightLevel() {
            return this.lightLevel;
        }
    }
}

