/*
 * Decompiled with CFR 0.152.
 */
package lakmoore.sel.common;

import cpw.mods.fml.common.FMLLog;
import java.util.Iterator;
import java.util.ListIterator;
import net.minecraft.launchwrapper.IClassTransformer;
import org.apache.logging.log4j.Level;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TypeInsnNode;
import org.objectweb.asm.tree.VarInsnNode;

public class Transformer
implements IClassTransformer {
    private final String removeEntityFromWorldMethodName = "removeEntityFromWorld";
    private final String removeEntityFromWorldMethodNameObf = "func_73028_b";
    private final String classNameWorldClient = "net.minecraft.client.multiplayer.WorldClient";
    private final String removeEntityFromWorldMethodDesc = "(I)Lnet/minecraft/entity/Entity;";
    private final String entityClassName = "net/minecraft/entity/Entity";
    private final String classWorldRendererName = "net.minecraft.client.renderer.WorldRenderer";
    private final String methodUpdateRendererName = "updateRenderer";
    private final String methodUpdateRendererNameObf = "func_147892_a";
    private final String methodUpdateRendererDesc = "(Lnet/minecraft/entity/EntityLivingBase;)V";
    private final String classChunkCacheNameOLD = "net/minecraft/world/ChunkCache";
    private final String classChunkCacheNameNEW = "lakmoore/sel/world/ChunkCacheSEL";

    private static void log(String message) {
        FMLLog.log((String)"SmoothEntityLights", (Level)Level.INFO, (String)"%s", (Object[])new Object[]{message});
    }

    private static void error(String message) {
        FMLLog.log((String)"SmoothEntityLights", (Level)Level.ERROR, (String)"%s", (Object[])new Object[]{message});
    }

    public byte[] transform(String name, String newName, byte[] bytes) {
        boolean obf;
        boolean bl = obf = !name.equals(newName);
        if (newName.equals("net.minecraft.client.multiplayer.WorldClient")) {
            Transformer.log("********* INSIDE TRANSFORMER ABOUT TO PATCH: " + name + "|" + newName);
            return this.handleWorldClientTransform(bytes, obf);
        }
        if (newName.equals("net.minecraft.client.renderer.WorldRenderer")) {
            Transformer.log("********* INSIDE TRANSFORMER ABOUT TO PATCH: " + name + "|" + newName);
            return this.handleChunkCacheTransform(bytes, obf);
        }
        return bytes;
    }

    private byte[] handleChunkCacheTransform(byte[] bytes, boolean obf) {
        Transformer.log("Patching ChunkCache, obf: " + obf);
        ClassNode classNode = new ClassNode();
        ClassReader classReader = new ClassReader(bytes);
        classReader.accept((ClassVisitor)classNode, 0);
        Boolean found = false;
        String methodName = "updateRenderer";
        if (obf) {
            methodName = "func_147892_a";
        }
        Iterator methods = classNode.methods.iterator();
        while (methods.hasNext() && !found.booleanValue()) {
            MethodNode m = (MethodNode)methods.next();
            if (!m.name.equals(methodName) || !m.desc.equals("(Lnet/minecraft/entity/EntityLivingBase;)V")) continue;
            AbstractInsnNode targetNode = null;
            ListIterator iter = m.instructions.iterator();
            while (iter.hasNext() && !found.booleanValue()) {
                TypeInsnNode node;
                targetNode = (AbstractInsnNode)iter.next();
                if (targetNode instanceof TypeInsnNode && targetNode.getOpcode() == 187) {
                    node = (TypeInsnNode)targetNode;
                    if (!node.desc.equals("net/minecraft/world/ChunkCache")) continue;
                    node.desc = "lakmoore/sel/world/ChunkCacheSEL";
                    Transformer.log("Patched ChunkCache New!");
                    continue;
                }
                if (!(targetNode instanceof MethodInsnNode) || targetNode.getOpcode() != 183) continue;
                node = (MethodInsnNode)targetNode;
                if (!node.owner.equals("net/minecraft/world/ChunkCache")) continue;
                node.owner = "lakmoore/sel/world/ChunkCacheSEL";
                found = true;
                Transformer.log("Patched ChunkCache Init!");
            }
        }
        ClassWriter writer = new ClassWriter(3);
        classNode.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }

    private byte[] handleWorldClientTransform(byte[] bytes, boolean obf) {
        Transformer.log("Patching WorldClient, obf: " + obf);
        boolean found = false;
        String methodName = "removeEntityFromWorld";
        if (obf) {
            methodName = "func_73028_b";
        }
        ClassNode classNode = new ClassNode();
        ClassReader classReader = new ClassReader(bytes);
        classReader.accept((ClassVisitor)classNode, 0);
        classNode.superName = "lakmoore/sel/world/WorldSEL";
        Iterator methods = classNode.methods.iterator();
        while (methods.hasNext() && !found) {
            AbstractInsnNode targetNode2;
            MethodNode m = (MethodNode)methods.next();
            if (m.name.equals("<init>")) {
                targetNode2 = null;
                for (AbstractInsnNode targetNode2 : m.instructions) {
                    if (!(targetNode2 instanceof MethodInsnNode)) continue;
                    MethodInsnNode node = (MethodInsnNode)targetNode2;
                    if (!node.owner.equals("net/minecraft/world/World") || !node.name.equals("<init>")) continue;
                    node.owner = "lakmoore/sel/world/WorldSEL";
                }
            }
            if (!m.name.equals(methodName) || !m.desc.equals("(I)Lnet/minecraft/entity/Entity;")) continue;
            targetNode2 = null;
            for (AbstractInsnNode targetNode2 : m.instructions) {
                if (!(targetNode2 instanceof JumpInsnNode) || targetNode2.getOpcode() != 198) continue;
                InsnList toInject = new InsnList();
                toInject.add((AbstractInsnNode)new VarInsnNode(25, 2));
                MethodInsnNode node = new MethodInsnNode(184, "lakmoore/sel/client/SEL", "onEntityRemoved", "(Lnet/minecraft/entity/Entity;)V", false);
                toInject.add((AbstractInsnNode)node);
                m.instructions.insert(targetNode2, toInject);
                found = true;
                break;
            }
            Transformer.log("World Patching Complete! Found = " + found);
            break;
        }
        ClassWriter writer = new ClassWriter(3);
        classNode.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }
}

