/*
 * Decompiled with CFR 0.152.
 */
package lakmoore.sel.world;

import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;

public class DirtyRayTrace {
    private IBlockAccess world;
    private final double sample_size = 16.0;
    private double lastDistSq;

    public DirtyRayTrace(IBlockAccess world) {
        this.world = world;
        this.lastDistSq = 0.125;
        this.lastDistSq *= this.lastDistSq;
    }

    public ArrayList<Block> getBlocksAlongRay(Vec3 start, Vec3 end) {
        ArrayList<Block> result = new ArrayList<Block>();
        Vec3 direction = start.func_72444_a(end).func_72432_b();
        direction = Vec3.func_72443_a((double)(direction.field_72450_a / 16.0), (double)(direction.field_72448_b / 16.0), (double)(direction.field_72449_c / 16.0));
        int thisX = 0;
        int thisY = 0;
        int thisZ = 0;
        int lastX = 0;
        int lastY = 0;
        int lastZ = 0;
        Vec3 currentPos = Vec3.func_72443_a((double)start.field_72450_a, (double)start.field_72448_b, (double)start.field_72449_c);
        while (end.func_72436_e(currentPos) > this.lastDistSq) {
            currentPos = currentPos.func_72441_c(direction.field_72450_a, direction.field_72448_b, direction.field_72449_c);
            thisX = MathHelper.func_76128_c((double)currentPos.field_72450_a);
            thisY = MathHelper.func_76128_c((double)currentPos.field_72448_b);
            thisZ = MathHelper.func_76128_c((double)currentPos.field_72449_c);
            if (thisX == lastX && thisY == lastY && thisZ == lastZ) continue;
            Block thisBlock = this.world.func_147439_a(thisX, thisY, thisZ);
            if (thisBlock != null) {
                result.add(thisBlock);
            }
            lastX = thisX;
            lastY = thisY;
            lastZ = thisZ;
        }
        return result;
    }

    public ArrayList<Block> rayTraceAllBlocks(Vec3 start, Vec3 end) {
        ArrayList<Block> result = new ArrayList<Block>();
        if (!(Double.isNaN(start.field_72450_a) || Double.isNaN(start.field_72448_b) || Double.isNaN(start.field_72449_c) || Double.isNaN(end.field_72450_a) || Double.isNaN(end.field_72448_b) || Double.isNaN(end.field_72449_c))) {
            MovingObjectPosition mop;
            int endX = MathHelper.func_76128_c((double)end.field_72450_a);
            int endY = MathHelper.func_76128_c((double)end.field_72448_b);
            int endZ = MathHelper.func_76128_c((double)end.field_72449_c);
            Vec3 currentPos = Vec3.func_72443_a((double)start.field_72450_a, (double)start.field_72448_b, (double)start.field_72449_c);
            int thisX = MathHelper.func_76128_c((double)currentPos.field_72450_a);
            int thisY = MathHelper.func_76128_c((double)currentPos.field_72448_b);
            int thisZ = MathHelper.func_76128_c((double)currentPos.field_72449_c);
            while ((thisX != endX || thisY != endY || thisZ != endZ) && (mop = this.blockRayTrace(thisX, thisY, thisZ, currentPos, end)) != null) {
                currentPos = mop.field_72307_f;
                thisX = mop.field_72311_b;
                thisY = mop.field_72312_c;
                thisZ = mop.field_72309_d;
                Block block = this.world.func_147439_a(thisX, thisY, thisZ);
                if (block == null || block == Blocks.field_150350_a) continue;
                result.add(block);
            }
        }
        return result;
    }

    private MovingObjectPosition blockRayTrace(int x, int y, int z, Vec3 startVec, Vec3 endVec) {
        double dX = x;
        double dY = y;
        double dZ = z;
        startVec = startVec.func_72441_c(-dX, -dY, -dZ);
        endVec = endVec.func_72441_c(-dX, -dY, -dZ);
        Vec3 hitPoint = null;
        if (startVec.field_72450_a > 0.0 && (hitPoint = startVec.func_72429_b(endVec, 0.0)) != null && this.inBounds(hitPoint.field_72448_b) && this.inBounds(hitPoint.field_72449_c)) {
            hitPoint = hitPoint.func_72441_c(dX, dY, dZ);
            return new MovingObjectPosition(x - 1, y, z, 0, hitPoint, true);
        }
        if (startVec.field_72450_a < 1.0 && (hitPoint = startVec.func_72429_b(endVec, 1.0)) != null && this.inBounds(hitPoint.field_72448_b) && this.inBounds(hitPoint.field_72449_c)) {
            hitPoint = hitPoint.func_72441_c(dX, dY, dZ);
            return new MovingObjectPosition(x + 1, y, z, 0, hitPoint, true);
        }
        if (startVec.field_72448_b > 0.0 && (hitPoint = startVec.func_72435_c(endVec, 0.0)) != null && this.inBounds(hitPoint.field_72450_a) && this.inBounds(hitPoint.field_72449_c)) {
            hitPoint = hitPoint.func_72441_c(dX, dY, dZ);
            return new MovingObjectPosition(x, y - 1, z, 0, hitPoint, true);
        }
        if (startVec.field_72448_b < 1.0 && (hitPoint = startVec.func_72435_c(endVec, 1.0)) != null && this.inBounds(hitPoint.field_72450_a) && this.inBounds(hitPoint.field_72449_c)) {
            hitPoint = hitPoint.func_72441_c(dX, dY, dZ);
            return new MovingObjectPosition(x, y + 1, z, 0, hitPoint, true);
        }
        if (startVec.field_72449_c > 0.0 && (hitPoint = startVec.func_72434_d(endVec, 0.0)) != null && this.inBounds(hitPoint.field_72450_a) && this.inBounds(hitPoint.field_72448_b)) {
            hitPoint = hitPoint.func_72441_c(dX, dY, dZ);
            return new MovingObjectPosition(x, y, z - 1, 0, hitPoint, true);
        }
        if (startVec.field_72449_c < 1.0 && (hitPoint = startVec.func_72434_d(endVec, 1.0)) != null && this.inBounds(hitPoint.field_72450_a) && this.inBounds(hitPoint.field_72448_b)) {
            hitPoint = hitPoint.func_72441_c(dX, dY, dZ);
            return new MovingObjectPosition(x, y, z + 1, 0, hitPoint, true);
        }
        return null;
    }

    private boolean inBounds(double x) {
        return x >= 0.0 && x <= 1.0;
    }
}

