/*
 * Decompiled with CFR 0.152.
 */
package lakmoore.sel.capabilities;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import lakmoore.sel.capabilities.ILightSourceCapability;
import lakmoore.sel.client.LightUtils;
import lakmoore.sel.client.SEL;
import lakmoore.sel.client.adaptors.BaseAdaptor;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;

public class DefaultLightSourceCapability
implements ICapabilityProvider,
ILightSourceCapability {
    private static Entity thePlayer;
    private static final float maxDiffNear = 0.04f;
    private static final float maxDiffFar = 2.0f;
    private static final float farDistSq = 1024.0f;
    protected World world;
    protected Entity entity;
    private ArrayList<BaseAdaptor> adaptors;
    private float maxDiff;
    private Vec3d prev;
    private BlockPos prevBlock;
    private int prevLight;
    private boolean underwater = false;

    public void init(Entity entity, World world) {
        this.world = world;
        this.entity = entity;
        thePlayer = Minecraft.func_71410_x().field_71439_g;
        this.adaptors = new ArrayList();
        this.prevLight = 0;
        this.prev = new Vec3d(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v);
        this.prevBlock = new BlockPos(this.prev);
        this.checkDistanceLOD();
    }

    @Override
    public Entity getEntity() {
        return this.entity;
    }

    @Override
    public void addLightSource(BaseAdaptor adaptor) {
        this.adaptors.add(adaptor);
    }

    @Override
    public boolean hasSources() {
        return this.adaptors.size() > 0;
    }

    private int getLightLevel() {
        int light = 0;
        if (!SEL.disabled) {
            for (BaseAdaptor adaptor : this.adaptors) {
                light = LightUtils.maxLight(light, adaptor.getLightLevel());
            }
            light = Math.min(15, light);
        }
        return light;
    }

    @Override
    public int getLastLightLevel() {
        return this.prevLight;
    }

    @Override
    public Set<BlockPos> getBlocksToUpdate() {
        HashSet<BlockPos> result = new HashSet<BlockPos>();
        if (this.entity == null || this.world == null) {
            return result;
        }
        int lightLevel = this.getLightLevel();
        if (lightLevel == 0 && this.prevLight == 0) {
            return result;
        }
        Vec3d current = new Vec3d(this.entity.field_70165_t, this.entity.field_70163_u, this.entity.field_70161_v);
        if (current.func_72436_e(this.prev) > (double)this.maxDiff || lightLevel != this.prevLight) {
            BlockPos currentBlock;
            if (lightLevel > 0 || this.prevLight > 0) {
                result.addAll(LightUtils.getVolumeForRelight(this.prevBlock, 12));
            }
            if (!(currentBlock = new BlockPos(current)).equals((Object)this.prevBlock) && lightLevel > 0) {
                result.addAll(LightUtils.getVolumeForRelight(currentBlock, 12));
            }
            this.prev = current;
            this.prevBlock = currentBlock;
            this.prevLight = lightLevel;
            this.checkDistanceLOD();
            Block block = this.world.func_180495_p(currentBlock).func_177230_c();
            this.underwater = block == Blocks.field_150355_j;
        }
        return result;
    }

    @Override
    public boolean isUnderwater() {
        return this.underwater;
    }

    @Override
    public void destroy() {
        for (BaseAdaptor adaptor : this.adaptors) {
            adaptor.kill();
        }
        this.adaptors.clear();
        SEL.lightWorker.removeSourceEntity(this);
        this.entity = null;
        this.world = null;
    }

    private void checkDistanceLOD() {
        this.maxDiff = 0.04f;
        if (thePlayer != null && this.prev.func_186679_c(DefaultLightSourceCapability.thePlayer.field_70165_t, DefaultLightSourceCapability.thePlayer.field_70163_u, DefaultLightSourceCapability.thePlayer.field_70161_v) > 1024.0) {
            this.maxDiff = 2.0f;
        }
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return capability == SEL.LIGHT_SOURCE_CAPABILITY;
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == SEL.LIGHT_SOURCE_CAPABILITY) {
            return (T)SEL.LIGHT_SOURCE_CAPABILITY.cast((Object)this);
        }
        return null;
    }
}

