/*
 * Decompiled with CFR 0.152.
 */
package lakmoore.sel.capabilities;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import lakmoore.sel.capabilities.ILitChunkCache;
import lakmoore.sel.client.ClientProxy;
import lakmoore.sel.client.LightUtils;
import lakmoore.sel.client.SEL;
import net.minecraft.client.renderer.chunk.RenderChunk;
import net.minecraft.entity.Entity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;

public class LitChunkCacheCapability
implements ICapabilityProvider,
ILitChunkCache {
    private short[][][][] blockLight = new short[16][16][16][16];
    private short[][][][] selLight = new short[16][16][16][16];
    private short[][][][] mcLight = new short[16][16][16][16];
    private List<Set<BlockPos>> dirtyBlocks = new ArrayList<Set<BlockPos>>(16);
    private boolean[] dirtyChunk;
    private Chunk chunk;
    private RenderChunk[] renderChunks;

    public LitChunkCacheCapability() {
        for (int i = 0; i < 16; ++i) {
            this.dirtyBlocks.add(ConcurrentHashMap.newKeySet());
        }
        this.dirtyChunk = new boolean[16];
        this.renderChunks = new RenderChunk[16];
    }

    @Override
    public void setChunk(Chunk chunk) {
        this.chunk = chunk;
    }

    @Override
    public Chunk getChunk() {
        return this.chunk;
    }

    @Override
    public void setRenderChunk(int yChunk, RenderChunk renderChunk) {
        this.renderChunks[yChunk & 0xF] = renderChunk;
    }

    @Override
    public Set<Integer> getDirtyRenderChunkYs() {
        ConcurrentHashMap.KeySetView result = ConcurrentHashMap.newKeySet();
        for (int y = 0; y < 16; ++y) {
            if (!this.needsReLight(y)) continue;
            result.add(y);
        }
        return result;
    }

    @Override
    public RenderChunk getRenderChunk(int yChunk) {
        return this.renderChunks[yChunk & 0xF];
    }

    @Override
    public void setBlockLight(int x, int y, int z, short light) {
        if (y < 0) {
            y = 0;
        }
        this.blockLight[y >> 4 & 0xF][x & 0xF][y & 0xF][z & 0xF] = light;
    }

    @Override
    public void setVertexLight(int x, int y, int z, short light) {
        if (y < 0) {
            y = 0;
        }
        this.selLight[y >> 4 & 0xF][x & 0xF][y & 0xF][z & 0xF] = light;
    }

    @Override
    public void setMCVertexLight(double x, double y, double z, short light) {
        float err;
        int intZ;
        int intY;
        int intX = (int)Math.round(x);
        boolean isBlockVertex = (x - (double)intX) * (x - (double)intX) + (y - (double)(intY = (int)Math.round(y))) * (y - (double)intY) + (z - (double)(intZ = (int)Math.round(z))) * (z - (double)intZ) < (double)(err = 9.765625E-4f);
        short s = light;
        this.mcLight[intY >> 4 & 0xF][intX & 0xF][intY & 0xF][intZ & 0xF] = s;
        short currentLight = s;
        if (isBlockVertex || light > 1 + currentLight) {
            if (intY < 0) {
                intY = 0;
            }
            this.mcLight[intY >> 4 & 0xF][intX & 0xF][intY & 0xF][intZ & 0xF] = light;
        }
    }

    @Override
    public short getBlockLight(int x, int y, int z) {
        if (y < 0) {
            y = 0;
        }
        if (y > 255) {
            y = 255;
        }
        return this.blockLight[y >> 4 & 0xF][x & 0xF][y & 0xF][z & 0xF];
    }

    @Override
    public short getVertexLight(double x, double y, double z) {
        if (y < 0.0) {
            y = 0.0;
        }
        if (y > 255.0) {
            y = 255.0;
        }
        int intX = (int)Math.round(x);
        int intY = (int)Math.round(y);
        int intZ = (int)Math.round(z);
        short mc = this.mcLight[intY >> 4 & 0xF][intX & 0xF][intY & 0xF][intZ & 0xF];
        short sel = this.selLight[intY >> 4 & 0xF][intX & 0xF][intY & 0xF][intZ & 0xF];
        return (short)Math.min(240, Math.max(mc, sel));
    }

    @Override
    public void markBlockDirty(BlockPos pos) {
        if (pos.func_177956_o() > -1 && pos.func_177956_o() < 256) {
            int yChunk = pos.func_177956_o() >> 4 & 0xF;
            this.dirtyBlocks.get(yChunk).add(pos);
            this.dirtyChunk[yChunk] = true;
            if ((pos.func_177956_o() & 0xF) == 0 && yChunk > 0) {
                this.dirtyBlocks.get(--yChunk).add(pos.func_177982_a(0, -1, 0));
                this.dirtyChunk[yChunk] = true;
            }
            if ((pos.func_177956_o() & 0xF) == 15 && yChunk < 15) {
                this.dirtyBlocks.get(++yChunk).add(pos.func_177982_a(0, 1, 0));
                this.dirtyChunk[yChunk] = true;
            }
        }
    }

    @Override
    public Set<BlockPos> getDirtyBlocks(int yChunk) {
        return this.dirtyBlocks.get(yChunk);
    }

    @Override
    public boolean hasDirtyBlocks(int yChunk) {
        return this.dirtyBlocks.get(yChunk).size() > 0;
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return capability == SEL.LIT_CHUNK_CACHE_CAPABILITY;
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == SEL.LIT_CHUNK_CACHE_CAPABILITY) {
            return (T)SEL.LIT_CHUNK_CACHE_CAPABILITY.cast((Object)this);
        }
        return null;
    }

    @Override
    public boolean needsReLight(int yChunk) {
        return this.dirtyChunk[yChunk];
    }

    @Override
    public void reLightDone(int yChunk) {
        this.dirtyChunk[yChunk] = false;
    }

    @Override
    public void reLight(int yChunk, List<Entity> nearbyEntities, float partialTicks) {
        if (!this.hasDirtyBlocks(yChunk)) {
            return;
        }
        HashSet dirtyVerticesLocal = new HashSet();
        HashSet dirtyVertices = new HashSet();
        this.dirtyBlocks.get(yChunk).forEach(blockPos -> {
            for (int x = 0; x < 2; ++x) {
                for (int y = 0; y < 2; ++y) {
                    for (int z = 0; z < 2; ++z) {
                        BlockPos vertexPos = blockPos.func_177982_a(x, y, z);
                        if ((blockPos.func_177958_n() & 0xF) != 15 && (blockPos.func_177956_o() & 0xF) != 15 && (blockPos.func_177952_p() & 0xF) != 15) {
                            dirtyVerticesLocal.add(vertexPos);
                            continue;
                        }
                        dirtyVertices.add(vertexPos);
                    }
                }
            }
            this.setBlockLight(blockPos.func_177958_n(), blockPos.func_177956_o(), blockPos.func_177952_p(), LightUtils.getEntityLightLevel((IBlockAccess)ClientProxy.mcinstance.field_71441_e, nearbyEntities, new Vec3d((Vec3i)blockPos).func_72441_c(0.5, 0.5, 0.5), partialTicks));
        });
        dirtyVerticesLocal.forEach(vertexPos -> this.setVertexLight(vertexPos.func_177958_n(), vertexPos.func_177956_o(), vertexPos.func_177952_p(), LightUtils.getEntityLightLevel((IBlockAccess)ClientProxy.mcinstance.field_71441_e, nearbyEntities, new Vec3d((Vec3i)vertexPos), partialTicks)));
        dirtyVertices.forEach(vertexPos -> {
            ILitChunkCache lcc = LightUtils.getLitChunkCache((World)ClientProxy.mcinstance.field_71441_e, vertexPos.func_177958_n() >> 4, vertexPos.func_177952_p() >> 4);
            lcc.setVertexLight(vertexPos.func_177958_n(), vertexPos.func_177956_o(), vertexPos.func_177952_p(), LightUtils.getEntityLightLevel((IBlockAccess)ClientProxy.mcinstance.field_71441_e, nearbyEntities, new Vec3d((Vec3i)vertexPos), partialTicks));
        });
        this.getDirtyBlocks(yChunk).clear();
    }
}

