/*
 * Decompiled with CFR 0.152.
 */
package lakmoore.sel.client;

import java.nio.IntBuffer;
import javax.vecmath.Vector3f;
import lakmoore.sel.capabilities.DefaultLightSourceCapability;
import lakmoore.sel.capabilities.ILitChunkCache;
import lakmoore.sel.capabilities.LitChunkCacheCapability;
import lakmoore.sel.client.ClientProxy;
import lakmoore.sel.client.Config;
import lakmoore.sel.client.LightUtils;
import lakmoore.sel.client.SEL;
import lakmoore.sel.client.adaptors.BaseAdaptor;
import lakmoore.sel.client.adaptors.BrightAdaptor;
import lakmoore.sel.client.adaptors.CreeperAdaptor;
import lakmoore.sel.client.adaptors.EntityBurningAdaptor;
import lakmoore.sel.client.adaptors.EntityItemAdaptor;
import lakmoore.sel.client.adaptors.FloodLightAdaptor;
import lakmoore.sel.client.adaptors.MobLightAdaptor;
import lakmoore.sel.client.adaptors.PartialLightAdaptor;
import lakmoore.sel.client.adaptors.PlayerOtherAdaptor;
import lakmoore.sel.client.adaptors.PlayerSelfAdaptor;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityOtherPlayerMP;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.ViewFrustum;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.chunk.RenderChunk;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.culling.ICamera;
import net.minecraft.client.renderer.vertex.VertexBuffer;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.entity.projectile.EntityFireball;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL15;

@SideOnly(value=Side.CLIENT)
public class EventHandler {
    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END && ClientProxy.mcinstance.field_71441_e != null && SEL.enabledForDimension(ClientProxy.mcinstance.field_71439_g.field_71093_bK) && ClientProxy.mcinstance.field_71462_r == null && ClientProxy.toggleButton.func_151468_f() && System.currentTimeMillis() >= ClientProxy.nextKeyTriggerTime) {
            ClientProxy.nextKeyTriggerTime = System.currentTimeMillis() + 1000L;
            SEL.disabled = !SEL.disabled;
            ClientProxy.mcinstance.field_71456_v.func_146158_b().func_146227_a((ITextComponent)new TextComponentString("Smooth Entity Lights " + (SEL.disabled ? "off" : "on")));
            if (SEL.disabled) {
                SEL.lightWorker.shutdown();
                SEL.forceUpdate = true;
            } else {
                SEL.lightWorker.restart();
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void afterRender(RenderWorldLastEvent event) {
        if (!(ClientProxy.mcinstance.field_71441_e == null || ClientProxy.mcinstance.field_71462_r != null && ClientProxy.mcinstance.field_71462_r.func_73868_f() || !SEL.enabledForDimension(ClientProxy.mcinstance.field_71439_g.field_71093_bK) || !SEL.forceUpdate && SEL.disabled)) {
            this.updateFrustum();
            SEL.lightWorker.updateCamera((ICamera)new Frustum(), event.getPartialTicks(), ClientProxy.mcinstance.field_71474_y.field_151451_c);
            SEL.lightWorker.chunksToBeReRendered.forEach(lightCache -> {
                if (lightCache != null) {
                    SEL.lightWorker.chunksToBeReRendered.remove(lightCache);
                    lightCache.getDirtyRenderChunkYs().forEach(y -> {
                        RenderChunk renderChunk = lightCache.getRenderChunk((int)y);
                        if (renderChunk != null) {
                            lightCache.reLightDone((int)y);
                            for (BlockRenderLayer layer : BlockRenderLayer.values()) {
                                VertexBuffer vbo = renderChunk.func_178565_b(layer.ordinal());
                                vbo.func_177359_a();
                                int byteCount = GL15.glGetBufferParameteri((int)OpenGlHelper.field_176089_P, (int)34660);
                                if (byteCount > 0) {
                                    int integerCount = byteCount / 4;
                                    IntBuffer data = BufferUtils.createIntBuffer((int)integerCount);
                                    int[] rawBuffer = null;
                                    if (layer == BlockRenderLayer.TRANSLUCENT && renderChunk.func_178571_g() != null && renderChunk.func_178571_g().func_178487_c() != null && renderChunk.func_178571_g().func_178487_c().func_179013_a() != null) {
                                        rawBuffer = renderChunk.func_178571_g().func_178487_c().func_179013_a();
                                    } else {
                                        GL15.glGetBufferSubData((int)OpenGlHelper.field_176089_P, (long)0L, (IntBuffer)data);
                                        rawBuffer = new int[integerCount];
                                        data.get(rawBuffer);
                                    }
                                    boolean changed = false;
                                    int putIndex = 0;
                                    int vertCount = integerCount / 7;
                                    int quadCount = vertCount / 4;
                                    for (int q = 0; q < quadCount; ++q) {
                                        int v;
                                        int[][] thisQuad = new int[4][];
                                        float[][] position = new float[4][3];
                                        boolean quadChanged = false;
                                        for (v = 0; v < 4; ++v) {
                                            thisQuad[v] = new int[9];
                                            for (int i = 0; i < 7; ++i) {
                                                thisQuad[v][i] = rawBuffer[putIndex + v * 7 + i];
                                            }
                                            position[v][0] = Float.intBitsToFloat(thisQuad[v][0]);
                                            position[v][1] = Float.intBitsToFloat(thisQuad[v][1]);
                                            position[v][2] = Float.intBitsToFloat(thisQuad[v][2]);
                                        }
                                        for (v = 0; v < 4; ++v) {
                                            short selLight;
                                            int newLight;
                                            int mcLight;
                                            int yChunk = y;
                                            int vertX = Math.round(position[v][0]);
                                            int vertY = Math.round(position[v][1]);
                                            int vertZ = Math.round(position[v][2]);
                                            ILitChunkCache thisLitChunkCache = lightCache;
                                            if (vertX > 15) {
                                                vertX -= 16;
                                                thisLitChunkCache = LightUtils.getLitChunkCache((World)ClientProxy.mcinstance.field_71441_e, lightCache.getChunk().field_76635_g + 1, lightCache.getChunk().field_76647_h);
                                            }
                                            if (vertY > 15) {
                                                if (yChunk == 15) {
                                                    vertY = 15;
                                                } else {
                                                    vertY -= 16;
                                                    ++yChunk;
                                                }
                                            }
                                            if (vertZ > 15) {
                                                vertZ -= 16;
                                                thisLitChunkCache = LightUtils.getLitChunkCache((World)ClientProxy.mcinstance.field_71441_e, thisLitChunkCache.getChunk().field_76635_g, thisLitChunkCache.getChunk().field_76647_h + 1);
                                            }
                                            if ((mcLight = thisQuad[v][6]) != (newLight = mcLight & 0xFFFF0000 | (selLight = thisLitChunkCache.getVertexLight(vertX, 16 * yChunk + vertY, vertZ)))) {
                                                thisQuad[v][6] = newLight;
                                                quadChanged = true;
                                            }
                                            thisQuad[v][7] = selLight + ((mcLight & 0xFFFF0000) >> 16);
                                        }
                                        if (quadChanged) {
                                            int[] order = new int[]{0, 1, 2, 3};
                                            int[] flipped = new int[]{1, 2, 3, 0};
                                            if (thisQuad[3][7] - thisQuad[0][7] < thisQuad[2][7] - thisQuad[1][7]) {
                                                order = flipped;
                                            }
                                            data.position(putIndex);
                                            for (int v2 = 0; v2 < 4; ++v2) {
                                                for (int w = 0; w < 7; ++w) {
                                                    rawBuffer[putIndex + v2 * 7 + w] = thisQuad[order[v2]][w];
                                                }
                                            }
                                            changed = true;
                                        }
                                        putIndex += 28;
                                    }
                                    if (changed) {
                                        data.rewind();
                                        data.put(rawBuffer);
                                        data.rewind();
                                        GL15.glBufferSubData((int)OpenGlHelper.field_176089_P, (long)0L, (IntBuffer)data);
                                    }
                                }
                                vbo.func_177361_b();
                            }
                        }
                    });
                }
            });
            if (SEL.lightWorker.isShutdown() && SEL.lightWorker.chunksToBeReRendered.size() == 0) {
                SEL.forceUpdate = false;
            }
        }
    }

    @SubscribeEvent
    public void onDebugOverlay(RenderGameOverlayEvent.Text event) {
        if (Minecraft.func_71410_x().field_71474_y.field_74330_P) {
            event.getLeft().add("DL " + (SEL.disabled ? "OFF" : "ON"));
            EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
            WorldClient world = Minecraft.func_71410_x().field_71441_e;
            BlockPos pos = player.func_180425_c();
            IBlockState state = world.func_180495_p(pos);
            ILitChunkCache litChunkCache = LightUtils.getLitChunkCache((World)world, pos.func_177958_n() >> 4, pos.func_177952_p() >> 4);
            event.getLeft().add("Vanilla BL: " + state.getLightValue((IBlockAccess)world, pos) + " SEL: " + (litChunkCache != null && SEL.enabledForDimension(ClientProxy.mcinstance.field_71439_g.field_71093_bK) ? (float)Math.round(160.0f * (float)LightUtils.getEntityLightLevel((IBlockAccess)world, pos, event.getPartialTicks())) / 10.0f + " B-Cache: " + (float)Math.round(10.0f * (float)litChunkCache.getBlockLight(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p())) / 10.0f + " V-Cache: " + (float)Math.round(10.0f * (float)litChunkCache.getVertexLight(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p())) / 10.0f : "Disabled for this dimension"));
            event.getLeft().add("SEL avg blocks re-lit: " + (float)Math.round(10.0f * (float)SEL.lightWorker.averageBlockCount()) / 10.0f + " skipped ticks: " + SEL.lightWorker.ticksSkippedCount + " E: " + SEL.lightWorker.entityCount.get());
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onAttachChunkCapabilities(AttachCapabilitiesEvent<Chunk> event) {
        Chunk chunk = (Chunk)event.getObject();
        if (chunk == null) {
            return;
        }
        LitChunkCacheCapability cap = new LitChunkCacheCapability();
        cap.setChunk(chunk);
        event.addCapability(SEL.LIT_CHUNK_CACHE_CAPABILITY_NAME, (ICapabilityProvider)cap);
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onAttachEntityCapabilities(AttachCapabilitiesEvent<Entity> event) {
        Entity entity = (Entity)event.getObject();
        if (entity == null || entity.field_70128_L) {
            return;
        }
        World world = entity.func_130014_f_();
        if (world == null || !world.field_72995_K) {
            return;
        }
        if (!SEL.enabledForDimension(entity.field_71093_bK)) {
            return;
        }
        DefaultLightSourceCapability sources = new DefaultLightSourceCapability();
        sources.init(entity, world);
        if (entity instanceof EntityItem) {
            if (!Config.lightDroppedItems) {
                return;
            }
            EntityItemAdaptor adaptor = new EntityItemAdaptor((EntityItem)entity);
            sources.addLightSource(adaptor);
        } else if (entity instanceof EntityLivingBase && !(entity instanceof EntityPlayer)) {
            int value;
            int minLight = 0;
            int catchesFire = 0;
            if (Config.lightBurningEntities) {
                if (!SEL.lightValueMap.containsKey(entity.getClass())) {
                    value = Config.getMobFire(entity.getClass().getSimpleName());
                    SEL.lightValueMap.put(entity.getClass(), value != 0);
                    catchesFire = value;
                } else {
                    catchesFire = SEL.lightValueMap.get(entity.getClass()).booleanValue();
                }
            }
            if (Config.lightGlowingEntities) {
                if (!SEL.glowValueMap.containsKey(entity.getClass())) {
                    value = Config.getMobGlow(entity);
                    SEL.glowValueMap.put(entity.getClass(), value);
                    minLight = value;
                } else {
                    minLight = SEL.glowValueMap.get(entity.getClass());
                }
            }
            if (catchesFire != 0) {
                EntityBurningAdaptor adaptor = new EntityBurningAdaptor(entity);
                adaptor.minLight = minLight;
                sources.addLightSource(adaptor);
            } else if (minLight > 0) {
                BrightAdaptor adaptor = new BrightAdaptor(entity, minLight);
                sources.addLightSource(adaptor);
            }
            if (Config.lightMobEquipment) {
                MobLightAdaptor adaptor = new MobLightAdaptor((Entity)((EntityLivingBase)entity));
                sources.addLightSource(adaptor);
            }
            if (Config.lightChargingCreepers && entity instanceof EntityCreeper) {
                CreeperAdaptor adaptor = new CreeperAdaptor((EntityCreeper)entity);
                sources.addLightSource(adaptor);
            }
        } else if (entity instanceof EntityArrow || entity instanceof EntityFireball) {
            if (!Config.lightFlamingArrows) {
                return;
            }
            EntityBurningAdaptor adaptor = new EntityBurningAdaptor(entity);
            sources.addLightSource(adaptor);
        } else if (entity instanceof EntityXPOrb) {
            if (!Config.lightXP) {
                return;
            }
            BrightAdaptor adaptor = new BrightAdaptor(entity, 10);
            sources.addLightSource(adaptor);
        } else if (entity instanceof EntityOtherPlayerMP) {
            if (!Config.lightOtherPlayers) {
                return;
            }
            PlayerOtherAdaptor adaptor = new PlayerOtherAdaptor((EntityPlayer)((EntityOtherPlayerMP)entity));
            sources.addLightSource(adaptor);
        } else if (entity instanceof EntityPlayerSP) {
            BaseAdaptor adaptor;
            if (Config.lightFloodLight) {
                adaptor = new FloodLightAdaptor(entity, Config.simpleMode);
                sources.addLightSource(adaptor);
            }
            if (!Config.lightThisPlayer) {
                return;
            }
            adaptor = new PlayerSelfAdaptor((EntityPlayer)entity);
            sources.addLightSource(adaptor);
            this.checkForOptifine();
        } else if (entity instanceof FloodLightAdaptor.DummyEntity && Config.lightFloodLight) {
            PartialLightAdaptor adaptor = new PartialLightAdaptor(entity);
            sources.addLightSource(adaptor);
        }
        if (sources.hasSources()) {
            event.addCapability(SEL.LIGHT_SOURCE_CAPABILITY_NAME, (ICapabilityProvider)sources);
            SEL.lightWorker.addSourceEntity(sources);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onEntityJoinWorld(EntityJoinWorldEvent event) {
        if (event.getEntity().equals((Object)ClientProxy.mcinstance.field_71439_g) && SEL.lightWorker != null) {
            SEL.lightWorker.setPlayer((Entity)ClientProxy.mcinstance.field_71439_g);
            this.updateFrustum();
        }
    }

    private void updateFrustum() {
        ViewFrustum viewFrustum = null;
        try {
            viewFrustum = (ViewFrustum)ClientProxy.viewFrustumField.get(ClientProxy.mcinstance.field_71438_f);
            SEL.lightWorker.updateFrustum(viewFrustum);
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
    }

    private void checkForOptifine() {
        if (FMLClientHandler.instance().hasOptifine() && !Config.optifineOverride) {
            ClientProxy.mcinstance.field_71456_v.func_146158_b().func_146227_a((ITextComponent)new TextComponentString("Optifine is loaded.  Disabling Smooth Entity Light.  Check the config file to override."));
            SEL.disabled = true;
        }
    }

    private void readState(BufferBuilder.State state, BlockPos pos) {
        VertexFormat format = state.func_179016_d();
        int intSize = format.func_181719_f();
        int[] rawInts = state.func_179013_a();
        int vertexCount = state.func_179014_c();
        for (int vertexNum = 0; vertexNum < vertexCount; ++vertexNum) {
            int iStart = vertexNum * intSize;
            Vector3f vPos = EventHandler.getVertexPos(rawInts, vertexNum);
            int iX = iStart;
            int iY = iX + 1;
            int iZ = iY + 1;
            int iC = iStart + 3;
            int colourR = rawInts[iC];
            int colourG = rawInts[iC + 1];
            int colourB = rawInts[iC + 2];
            String colourRs = String.format("0x%08x", colourR);
            String colourGs = String.format("0x%08x", colourG);
            String colourBs = String.format("0x%08x", colourB);
            float x = Float.intBitsToFloat(rawInts[iX]);
            float y = Float.intBitsToFloat(rawInts[iY]);
            float z = Float.intBitsToFloat(rawInts[iZ]);
        }
    }

    private static Vector3f getVertexPos(int[] data, int vertex) {
        int idx = vertex * 7;
        float x = Float.intBitsToFloat(data[idx]);
        float y = Float.intBitsToFloat(data[idx + 1]);
        float z = Float.intBitsToFloat(data[idx + 2]);
        return new Vector3f(x, y, z);
    }

    public static void putQuadColor(BufferBuilder renderer, BakedQuad quad, int color) {
        float cb = color & 0xFF;
        float cg = color >>> 8 & 0xFF;
        float cr = color >>> 16 & 0xFF;
        float ca = color >>> 24 & 0xFF;
        VertexFormat format = quad.getFormat();
        int size = format.func_181719_f();
        int offset = format.func_177340_e() / 4;
        for (int i = 0; i < 4; ++i) {
            int vc = quad.func_178209_a()[offset + size * i];
            float vcr = vc & 0xFF;
            float vcg = vc >>> 8 & 0xFF;
            float vcb = vc >>> 16 & 0xFF;
            float vca = vc >>> 24 & 0xFF;
            int ncr = Math.min(255, (int)(cr * vcr / 255.0f));
            int ncg = Math.min(255, (int)(cg * vcg / 255.0f));
            int ncb = Math.min(255, (int)(cb * vcb / 255.0f));
            int nca = Math.min(255, (int)(ca * vca / 255.0f));
            renderer.putColorRGBA(renderer.func_78909_a(4 - i), ncr, ncg, ncb, nca);
        }
    }
}

