/*
 * Decompiled with CFR 0.152.
 */
package lakmoore.sel.client;

import coloredlightscore.src.api.CLBlock;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.GameRegistry;

public class ItemConfigHelper {
    private final String SWILDCARD = "*";
    private final int WILDCARD = -1;
    private Map<ItemData, Integer> dataMap = new HashMap<ItemData, Integer>();

    public ItemConfigHelper(String configLine, int defaultValue) {
        for (String s : configLine.split(",")) {
            try {
                String[] duo = s.split("=");
                this.dataMap.put(this.fromString(duo[0]), duo.length > 1 ? Integer.parseInt(duo[1]) : defaultValue);
            }
            catch (Exception e) {
                System.err.println("Error, String [" + s + "] is not a valid Entry, skipping.");
                e.printStackTrace();
            }
        }
    }

    public String toString() {
        String result = "";
        for (Map.Entry<ItemData, Integer> entry : this.dataMap.entrySet()) {
            if (entry.getValue() <= 0) continue;
            if (result.length() > 0) {
                result = result + ",";
            }
            result = result + entry.getKey().toString() + "=" + entry.getValue();
        }
        return result;
    }

    public void addItem(ItemStack stack, int lightLevel) {
        ResourceLocation name;
        if (stack != null && (name = stack.func_77973_b().getRegistryName()) != null) {
            Iterator<ItemData> items = this.dataMap.keySet().iterator();
            while (items.hasNext()) {
                ItemData item = items.next();
                if (!item.matches(name, stack.func_77960_j())) continue;
                items.remove();
            }
            this.dataMap.put(new ItemData(name, stack.func_77960_j(), -1), lightLevel);
        }
    }

    public int getLightFromItemStack(ItemStack stack) {
        if (stack != null) {
            int r = this.retrieveValue(stack.func_77973_b().getRegistryName(), stack.func_77960_j());
            return r < 0 ? 0 : r;
        }
        return 0;
    }

    public int retrieveValue(ResourceLocation name, int meta) {
        if (name != null) {
            for (ItemData item : this.dataMap.keySet()) {
                if (!item.matches(name, meta)) continue;
                int val = this.dataMap.get(item);
                if (val == -1) {
                    Block b = (Block)GameRegistry.findRegistry(Block.class).getValue(name);
                    if (b instanceof CLBlock) {
                        return ((CLBlock)b).getColorLightValue(meta);
                    }
                    return b != null ? b.func_176223_P().func_185906_d() : 0;
                }
                return val;
            }
        }
        return -1;
    }

    private ItemData fromString(String s) {
        int sm;
        String[] strings = s.split("-");
        int len = strings.length;
        int n = len > 1 ? this.catchWildcard(strings[len > 3 ? 2 : 1]) : (sm = -1);
        int em = len > 2 ? this.catchWildcard(strings[len > 3 ? 3 : 2]) : sm;
        ResourceLocation name = new ResourceLocation(strings[0]);
        return new ItemData(name, sm, em);
    }

    private int catchWildcard(String s) {
        if (s.equals("*")) {
            return -1;
        }
        return Integer.parseInt(s);
    }

    private class ItemData {
        private ResourceLocation nameOf;
        final int startMeta;
        final int endMeta;

        public ItemData(ResourceLocation name, int startmetarange, int endmetarange) {
            this.nameOf = name;
            this.startMeta = startmetarange;
            this.endMeta = endmetarange;
        }

        public String toString() {
            return this.nameOf + (this.startMeta < 1 ? "" : "-" + this.startMeta) + (this.endMeta < 1 ? "" : "-" + this.endMeta);
        }

        public boolean matches(ResourceLocation name, int meta) {
            return name.equals((Object)this.nameOf) && this.isContained(this.startMeta, this.endMeta, meta);
        }

        private boolean isContained(int s, int e, int i) {
            return !(s != -1 && i < s || e != -1 && i > e);
        }

        public boolean equals(Object o) {
            if (o instanceof ItemData) {
                ItemData i = (ItemData)o;
                return i.nameOf.equals((Object)this.nameOf) && i.startMeta == this.startMeta && i.endMeta == this.endMeta;
            }
            return false;
        }

        public int hashCode() {
            return this.nameOf.hashCode() + this.startMeta + this.endMeta;
        }
    }
}

