/*
 * Decompiled with CFR 0.152.
 */
package lakmoore.sel.client;

import com.google.common.base.Predicate;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import lakmoore.sel.capabilities.DummyChunkCache;
import lakmoore.sel.capabilities.ILightSourceCapability;
import lakmoore.sel.capabilities.ILitChunkCache;
import lakmoore.sel.client.ClientProxy;
import lakmoore.sel.client.SEL;
import lakmoore.sel.world.DirtyRayTrace;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.Chunk;

public class LightUtils {
    public static final Predicate<Entity> HAS_ENTITY_LIGHT = new Predicate<Entity>(){

        public boolean apply(@Nullable Entity entity) {
            return entity != null && entity.hasCapability(SEL.LIGHT_SOURCE_CAPABILITY, null);
        }
    };

    public static int getCombinedLight(short smoothBlockLight0to240, int combinedLight) {
        int blockLight;
        if (smoothBlockLight0to240 > 0 && smoothBlockLight0to240 > (blockLight = combinedLight & 0xFF)) {
            combinedLight &= 0xFFFF0000;
            combinedLight |= smoothBlockLight0to240 & 0xFF;
        }
        return combinedLight;
    }

    public static int maxLight(int a, int b) {
        if (SEL.coloredLights) {
            if (((0x100000 | b) - a & 0x84210) > 0) {
                return a;
            }
            return b;
        }
        return Math.max(a, b);
    }

    public static short getEntityLightLevel(IBlockAccess world, BlockPos pos, float partialTicks) {
        float maxLight = 0.0f;
        if (SEL.disabled || world == null || world instanceof WorldServer) {
            return 0;
        }
        if (world instanceof World) {
            int opacity = ((World)world).getBlockLightOpacity(pos);
            if (opacity > 14) {
                return 0;
            }
            DirtyRayTrace rayTrace = new DirtyRayTrace(world);
            Vec3d target = new Vec3d((Vec3i)pos);
            target = target.func_72441_c(0.5, 0.5, 0.5);
            AxisAlignedBB aabb = new AxisAlignedBB(pos).func_186662_g(12.0);
            List entities = ((World)world).func_175647_a(Entity.class, aabb, HAS_ENTITY_LIGHT);
            for (Entity entity : entities) {
                float lightValue;
                ILightSourceCapability sources = (ILightSourceCapability)entity.getCapability(SEL.LIGHT_SOURCE_CAPABILITY, null);
                if (sources == null || (lightValue = (float)sources.getLastLightLevel()) <= 0.0f || (lightValue = Math.max(Math.min(lightValue - (float)opacity, 15.0f), 0.0f)) <= 0.0f) continue;
                double distSq = target.func_72436_e(entity.func_174824_e(partialTicks));
                if (sources.isUnderwater()) {
                    distSq *= 2.0;
                }
                if (distSq > 144.0 || (lightValue = (1.0f - (float)Math.sqrt(distSq) / 12.0f) * lightValue) <= maxLight) continue;
                lightValue -= (float)rayTrace.rayTraceForOpacity(entity.func_174824_e(partialTicks), target);
                if ((lightValue = Math.max(0.0f, Math.min(15.0f, lightValue))) <= maxLight || (maxLight = lightValue) != 15.0f) continue;
                break;
            }
        }
        return (short)Math.round(maxLight);
    }

    public static short getEntityLightLevel(IBlockAccess world, List<Entity> interestingEntities, Vec3d vertexPos, float partialTicks) {
        float maxLight = 0.0f;
        if (SEL.disabled || world == null || world instanceof WorldServer) {
            return 0;
        }
        if (world instanceof World) {
            DirtyRayTrace rayTrace = new DirtyRayTrace(world);
            Vec3d target = vertexPos;
            for (Entity entity : interestingEntities) {
                float lightValue;
                ILightSourceCapability sources = (ILightSourceCapability)entity.getCapability(SEL.LIGHT_SOURCE_CAPABILITY, null);
                if (sources == null || (lightValue = (float)sources.getLastLightLevel()) <= 0.0f) continue;
                double distSq = target.func_72436_e(entity.func_174824_e(partialTicks));
                if (sources.isUnderwater()) {
                    distSq *= 2.0;
                }
                if (distSq > 144.0 || (lightValue = (1.0f - (float)Math.sqrt(distSq) / 12.0f) * lightValue) <= maxLight || (lightValue -= (float)rayTrace.rayTraceForOpacity(entity.func_174824_e(partialTicks), target)) <= maxLight || !((maxLight = lightValue) >= 15.0f)) continue;
                break;
            }
        }
        return (short)Math.min(240, Math.round(16.0f * maxLight));
    }

    public static ArrayList<BlockPos> getVolumeForRelight(BlockPos pos, int radius) {
        ArrayList<BlockPos> result = new ArrayList<BlockPos>();
        int minX = pos.func_177958_n() - ++radius;
        int minY = pos.func_177956_o() - radius;
        int minZ = pos.func_177952_p() - radius;
        int maxX = pos.func_177958_n() + radius;
        int maxY = pos.func_177956_o() + radius;
        int maxZ = pos.func_177952_p() + radius;
        for (int i = minX; i <= maxX; ++i) {
            for (int j = minY; j <= maxY; ++j) {
                for (int k = minZ; k <= maxZ; ++k) {
                    BlockPos pos1 = new BlockPos(i, j, k);
                    if (!(pos.func_177951_i((Vec3i)pos1) < 144.0)) continue;
                    result.add(pos1);
                }
            }
        }
        return result;
    }

    public static boolean hasLineOfSight(BlockPos blockPos, Vec3d camPos) {
        RayTraceResult rtr = ClientProxy.mcinstance.field_71441_e.func_72933_a(new Vec3d((Vec3i)blockPos).func_72441_c(0.5, 0.5, 0.5), camPos);
        return rtr == null || rtr.field_72313_a != RayTraceResult.Type.BLOCK;
    }

    public static <T extends Entity> List<T> getEntitiesWithinAABB(Class<? extends T> clazz, AxisAlignedBB aabb, @Nullable Predicate<? super T> filter) {
        int j2 = MathHelper.func_76128_c((double)((aabb.field_72340_a - World.MAX_ENTITY_RADIUS) / 16.0));
        int k2 = MathHelper.func_76143_f((double)((aabb.field_72336_d + World.MAX_ENTITY_RADIUS) / 16.0));
        int l2 = MathHelper.func_76128_c((double)((aabb.field_72339_c - World.MAX_ENTITY_RADIUS) / 16.0));
        int i3 = MathHelper.func_76143_f((double)((aabb.field_72334_f + World.MAX_ENTITY_RADIUS) / 16.0));
        ArrayList list = Lists.newArrayList();
        for (int j3 = j2; j3 < k2; ++j3) {
            for (int k3 = l2; k3 < i3; ++k3) {
                LightUtils.getEntitiesOfTypeWithinAABB(ClientProxy.mcinstance.field_71441_e.func_72964_e(j3, k3), clazz, aabb, list, filter);
            }
        }
        return list;
    }

    public static <T extends Entity> void getEntitiesOfTypeWithinAABB(Chunk chunk, Class<? extends T> entityClass, AxisAlignedBB aabb, List<T> listToFill, Predicate<? super T> filter) {
        int i = MathHelper.func_76128_c((double)((aabb.field_72338_b - World.MAX_ENTITY_RADIUS) / 16.0));
        int j = MathHelper.func_76128_c((double)((aabb.field_72337_e + World.MAX_ENTITY_RADIUS) / 16.0));
        i = MathHelper.func_76125_a((int)i, (int)0, (int)(chunk.func_177429_s().length - 1));
        j = MathHelper.func_76125_a((int)j, (int)0, (int)(chunk.func_177429_s().length - 1));
        for (int k = i; k <= j; ++k) {
            for (Entity entity : chunk.func_177429_s()[k]) {
                if (!entity.func_174813_aQ().func_72326_a(aabb) || filter != null && !filter.apply((Object)entity)) continue;
                listToFill.add(entity);
            }
        }
    }

    public static ILitChunkCache getLitChunkCache(World world, int chunkX, int chunkZ) {
        if (world != null) {
            Chunk chunk = world.func_72964_e(chunkX, chunkZ);
            ILitChunkCache litChunkCache = (ILitChunkCache)chunk.getCapability(SEL.LIT_CHUNK_CACHE_CAPABILITY, null);
            return litChunkCache;
        }
        return new DummyChunkCache();
    }
}

