/*
 * Decompiled with CFR 0.152.
 */
package lakmoore.sel.client;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import lakmoore.sel.capabilities.ILightSourceCapability;
import lakmoore.sel.capabilities.ILitChunkCache;
import lakmoore.sel.client.ClientProxy;
import lakmoore.sel.client.LightUtils;
import lakmoore.sel.client.SEL;
import net.minecraft.client.renderer.ViewFrustum;
import net.minecraft.client.renderer.chunk.RenderChunk;
import net.minecraft.client.renderer.culling.ICamera;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;

public class LightWorker
extends Thread {
    private final Set<ILightSourceCapability> allSources = ConcurrentHashMap.newKeySet();
    private final Set<BlockPos> blocksToUpdate = ConcurrentHashMap.newKeySet();
    private int updateInterval = 20;
    private long lastLightUpdateTime;
    private volatile Entity player;
    private volatile ICamera iCamera;
    private volatile ViewFrustum frustum;
    private volatile Vec3d cameraPos;
    private volatile float maxDistSq;
    private volatile float partialTicks;
    private volatile short state = 0;
    public AtomicInteger entityCount = new AtomicInteger();
    public ConcurrentLinkedQueue<Integer> counts = new ConcurrentLinkedQueue();
    public int ticksSkippedCount = 0;
    public Set<ILitChunkCache> chunksToBeReRendered = ConcurrentHashMap.newKeySet();

    LightWorker() {
        this.setName("SEL Light Worker");
        this.lastLightUpdateTime = System.currentTimeMillis();
    }

    public int totalBlockCount() {
        int count = 0;
        for (Object i : this.counts.toArray()) {
            count += ((Integer)i).intValue();
        }
        return count;
    }

    public int averageBlockCount() {
        int size = 0;
        int count = 0;
        for (Object i : this.counts.toArray()) {
            count += ((Integer)i).intValue();
            ++size;
        }
        if (size > 0) {
            return count / size;
        }
        return 0;
    }

    public void setPlayer(Entity player) {
        this.player = player;
    }

    public void addSourceEntity(ILightSourceCapability source) {
        this.allSources.add(source);
    }

    public void removeSourceEntity(ILightSourceCapability source) {
        this.allSources.remove(source);
        this.blocksToUpdate.addAll(source.getBlocksToUpdate());
    }

    public void updateCamera(ICamera camera, float partialTicks, int renderDistanceChunks) {
        this.iCamera = camera;
        this.partialTicks = partialTicks;
        this.cameraPos = this.player.func_174824_e(partialTicks);
        this.iCamera.func_78547_a(this.cameraPos.field_72450_a, this.cameraPos.field_72448_b, this.cameraPos.field_72449_c);
        this.maxDistSq = (float)renderDistanceChunks * 0.75f * (float)renderDistanceChunks * 0.75f * 256.0f;
    }

    public void updateFrustum(ViewFrustum frustum) {
        if (this.frustum != frustum) {
            this.frustum = frustum;
        }
    }

    public void shutdown() {
        this.state = 1;
    }

    public void restart() {
        this.state = 0;
    }

    public boolean isShutdown() {
        return this.state == 3;
    }

    public void reLightAVolume(BlockPos center, int radius) {
        this.blocksToUpdate.addAll(LightUtils.getVolumeForRelight(center, radius));
    }

    @Override
    public void run() {
        while (this.state > -1) {
            if (this.state < 3 && this.player != null && this.player.field_70170_p != null && (ClientProxy.mcinstance.field_71462_r == null || !ClientProxy.mcinstance.field_71462_r.func_73868_f()) && SEL.enabledForDimension(this.player.field_71093_bK)) {
                this.entityCount.set(0);
                if (this.player != null && this.cameraPos != null) {
                    Set interestingSources = this.allSources.stream().filter(source -> {
                        if (source.getEntity().equals((Object)ClientProxy.mcinstance.field_71439_g) || source.getEntity().func_184215_y((Entity)ClientProxy.mcinstance.field_71439_g)) {
                            return true;
                        }
                        BlockPos blockPos = new BlockPos(this.cameraPos);
                        if (source.getEntity().func_180425_c().func_177951_i((Vec3i)blockPos) > (double)this.maxDistSq) {
                            return false;
                        }
                        AxisAlignedBB axisalignedbb = source.getEntity().func_184177_bl().func_186662_g(12.0);
                        return this.iCamera.func_78546_a(axisalignedbb);
                    }).collect(Collectors.toSet());
                    this.blocksToUpdate.addAll(interestingSources.stream().flatMap(source -> {
                        this.entityCount.addAndGet(1);
                        return source.getBlocksToUpdate().stream();
                    }).collect(Collectors.toSet()));
                    AtomicInteger count = new AtomicInteger(0);
                    this.blocksToUpdate.forEach(blockPos -> {
                        if (blockPos != null) {
                            ILitChunkCache litChunk;
                            this.blocksToUpdate.remove(blockPos);
                            if (!this.player.field_70170_p.func_180495_p(blockPos).func_185914_p() && (litChunk = LightUtils.getLitChunkCache(this.player.field_70170_p, blockPos.func_177958_n() >> 4, blockPos.func_177952_p() >> 4)) != null) {
                                litChunk.markBlockDirty((BlockPos)blockPos);
                                count.incrementAndGet();
                            }
                        }
                    });
                    this.counts.add(count.intValue());
                    while (this.counts.size() > 60) {
                        this.counts.remove();
                    }
                    if (this.frustum != null) {
                        HashSet result = new HashSet();
                        Set<RenderChunk> renderChunks = Arrays.asList(this.frustum.field_178164_f).stream().filter(renderChunk -> renderChunk != null).collect(Collectors.toSet());
                        renderChunks.forEach(renderChunk -> {
                            ILitChunkCache lc = LightUtils.getLitChunkCache(this.player.field_70170_p, renderChunk.func_178568_j().func_177958_n() >> 4, renderChunk.func_178568_j().func_177952_p() >> 4);
                            int yChunk = renderChunk.func_178568_j().func_177956_o() >> 4;
                            if (lc != null && lc.hasDirtyBlocks(yChunk)) {
                                List nearEntities = this.player.field_70170_p.func_175647_a(Entity.class, renderChunk.field_178591_c.func_186662_g(12.0), LightUtils.HAS_ENTITY_LIGHT);
                                lc.reLight(yChunk, nearEntities, this.partialTicks);
                                lc.setRenderChunk(yChunk, (RenderChunk)renderChunk);
                                result.add(lc);
                            }
                        });
                        this.chunksToBeReRendered.addAll(result);
                    }
                }
            } else {
                try {
                    Thread.sleep(700L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            try {
                long sleepTime = Math.max(0L, (long)this.updateInterval - (System.currentTimeMillis() - this.lastLightUpdateTime));
                Thread.sleep(sleepTime);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            this.lastLightUpdateTime = System.currentTimeMillis();
            if (this.state <= 0 || this.state >= 3) continue;
            this.state = (short)(this.state + 1);
        }
    }
}

