/*
 * Decompiled with CFR 0.152.
 */
package lakmoore.sel.client;

import java.util.HashMap;
import java.util.concurrent.ForkJoinPool;
import lakmoore.sel.capabilities.ILightSourceCapability;
import lakmoore.sel.capabilities.ILitChunkCache;
import lakmoore.sel.client.Command;
import lakmoore.sel.client.CommonProxy;
import lakmoore.sel.client.Config;
import lakmoore.sel.client.LightWorker;
import net.minecraft.command.ICommand;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import org.apache.logging.log4j.Logger;

@Mod(modid="sel", name="Smooth Entity Light", version="4.0.1", acceptedMinecraftVersions="1.12.2", dependencies="required-after:forge@[14.23.5.2768,)")
public class SEL {
    public static final String modId = "sel";
    public static LightWorker lightWorker;
    public static boolean disabled;
    public static boolean forceUpdate;
    public static final int maxLightDist = 12;
    public static final int maxLightDistSq = 144;
    static boolean coloredLights;
    public static boolean fmlOverrideEnable;
    public static HashMap<Class<? extends Entity>, Boolean> lightValueMap;
    public static HashMap<Class<? extends Entity>, Integer> glowValueMap;
    @SidedProxy(clientSide="lakmoore.sel.client.ClientProxy", serverSide="lakmoore.sel.client.CommonProxy")
    public static CommonProxy proxy;
    public static Logger log;
    @CapabilityInject(value=ILightSourceCapability.class)
    public static Capability<ILightSourceCapability> LIGHT_SOURCE_CAPABILITY;
    public static ResourceLocation LIGHT_SOURCE_CAPABILITY_NAME;
    @CapabilityInject(value=ILitChunkCache.class)
    public static Capability<ILitChunkCache> LIT_CHUNK_CACHE_CAPABILITY;
    public static ResourceLocation LIT_CHUNK_CACHE_CAPABILITY_NAME;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent evt) {
        log = evt.getModLog();
        proxy.preInit(evt);
        log.info("No. of cores available to JVM (should be one less than CPU count): " + ForkJoinPool.getCommonPoolParallelism());
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent evt) {
        proxy.init();
    }

    @Mod.EventHandler
    public void serverLoad(FMLServerStartingEvent event) {
        event.registerServerCommand((ICommand)new Command());
    }

    public static boolean enabledForDimension(int dimensionID) {
        if (Config.dimensionBlacklist == null || Config.dimensionBlacklist.length == 0) {
            return true;
        }
        for (int dim : Config.dimensionBlacklist) {
            if (dim != dimensionID) continue;
            return false;
        }
        return true;
    }

    static {
        forceUpdate = false;
        LIGHT_SOURCE_CAPABILITY = null;
        LIGHT_SOURCE_CAPABILITY_NAME = new ResourceLocation(modId, "SELSourceCap");
        LIT_CHUNK_CACHE_CAPABILITY = null;
        LIT_CHUNK_CACHE_CAPABILITY_NAME = new ResourceLocation(modId, "SELLitChunkCacheCap");
    }
}

