/*
 * Decompiled with CFR 0.152.
 */
package lakmoore.sel.client.adaptors;

import java.util.ArrayList;
import lakmoore.sel.client.Config;
import lakmoore.sel.client.LightUtils;
import lakmoore.sel.client.SEL;
import lakmoore.sel.client.adaptors.BaseAdaptor;
import lakmoore.sel.client.adaptors.PartialLightAdaptor;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class FloodLightAdaptor
extends BaseAdaptor {
    public EntityPlayer thePlayer;
    public final int freeDistance = 8;
    public final float beamStrength = 26.0f;
    public static ArrayList<PartialLightAdaptor> lights;
    public static int ID;
    public static float[] pitch;
    public static float[] yaw;
    public static int lightLevel;

    public FloodLightAdaptor(Entity entity, boolean simpleMode) {
        super(entity);
        this.thePlayer = (EntityPlayer)entity;
        if (lights != null) {
            for (PartialLightAdaptor light : lights) {
                light.kill();
            }
        }
        lights = new ArrayList();
        ID = 0;
        int count = 5;
        if (simpleMode) {
            count = 1;
        }
        for (int i = 0; i < count; ++i) {
            DummyEntity dummyEntity = new DummyEntity(entity.field_70170_p);
            entity.func_70107_b(this.thePlayer.field_70165_t, this.thePlayer.field_70163_u, this.thePlayer.field_70161_v);
            this.thePlayer.field_70170_p.func_72838_d((Entity)dummyEntity);
        }
    }

    @Override
    public int getLightLevel() {
        if (this.thePlayer != null && this.thePlayer.func_70089_S() && !SEL.disabled) {
            lightLevel = 0;
            for (ItemStack item : this.thePlayer.func_184214_aD()) {
                lightLevel = LightUtils.maxLight(lightLevel, Config.floodLights.getLightFromItemStack(item));
            }
            Vec3d origin = this.thePlayer.func_174824_e(1.0f);
            for (PartialLightAdaptor light : lights) {
                if (lightLevel == 0) {
                    light.entity.func_70107_b(this.thePlayer.field_70165_t, this.thePlayer.field_70163_u, this.thePlayer.field_70161_v);
                    light.lightLevel = 0;
                    continue;
                }
                Vec3d look = FloodLightAdaptor.getVector(this.thePlayer.field_70177_z + yaw[light.Id], this.thePlayer.field_70125_A + pitch[light.Id]);
                look = origin.func_72441_c(look.field_72450_a * 26.0, look.field_72448_b * 26.0, look.field_72449_c * 26.0);
                RayTraceResult rtr = this.thePlayer.field_70170_p.func_72933_a(origin, look);
                if (rtr != null) {
                    int dist = (int)Math.round(this.thePlayer.func_70011_f(rtr.field_72307_f.field_72450_a, rtr.field_72307_f.field_72448_b, rtr.field_72307_f.field_72449_c));
                    dist = Math.max(0, dist - 8);
                    light.lightLevel = Math.max(0, lightLevel - dist);
                    light.entity.func_70107_b(rtr.field_72307_f.field_72450_a, rtr.field_72307_f.field_72448_b, rtr.field_72307_f.field_72449_c);
                    continue;
                }
                light.lightLevel = 0;
                light.entity.func_70107_b(this.thePlayer.field_70165_t, this.thePlayer.field_70163_u, this.thePlayer.field_70161_v);
            }
        }
        return 0;
    }

    public static Vec3d getVector(float rotYaw, float rotPitch) {
        float f1 = MathHelper.func_76134_b((float)(-rotYaw * ((float)Math.PI / 180) - (float)Math.PI));
        float f2 = MathHelper.func_76126_a((float)(-rotYaw * ((float)Math.PI / 180) - (float)Math.PI));
        float f3 = -MathHelper.func_76134_b((float)(-rotPitch * ((float)Math.PI / 180)));
        float f4 = MathHelper.func_76126_a((float)(-rotPitch * ((float)Math.PI / 180)));
        return new Vec3d((double)(f2 * f3), (double)f4, (double)(f1 * f3));
    }

    @Override
    public void kill() {
        for (PartialLightAdaptor light : lights) {
            light.kill();
        }
        super.kill();
        this.thePlayer = null;
    }

    static {
        ID = 0;
        pitch = new float[]{0.0f, 0.0f, 0.0f, -8.0f, 8.0f};
        yaw = new float[]{0.0f, 8.0f, -8.0f, 0.0f, 0.0f};
        lightLevel = 0;
    }

    public class DummyEntity
    extends Entity {
        public DummyEntity(World par1World) {
            super(par1World);
            this.field_70131_O = 0.0f;
            this.field_70130_N = 0.0f;
        }

        protected void func_70088_a() {
        }

        protected void func_70037_a(NBTTagCompound var1) {
        }

        protected void func_70014_b(NBTTagCompound var1) {
        }
    }
}

