/*
 * Decompiled with CFR 0.152.
 */
package lakmoore.sel.client.adaptors;

import lakmoore.sel.client.Config;
import lakmoore.sel.client.LightUtils;
import lakmoore.sel.client.adaptors.BaseAdaptor;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.passive.EntityHorse;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;

public class MobLightAdaptor
extends BaseAdaptor {
    public MobLightAdaptor(Entity entity) {
        super(entity);
    }

    private int getEquipmentLightLevel(EntityLivingBase ent) {
        String horseArmorTexture;
        if (ent instanceof EntityHorse && (horseArmorTexture = ((EntityHorse)ent).func_110212_cp()[2]) != null) {
            if (horseArmorTexture.equals("textures/entity/horse/armor/horse_armor_gold.png")) {
                return Config.itemsMap.getLightFromItemStack(new ItemStack(Items.field_151136_bY));
            }
            if (horseArmorTexture.equals("textures/entity/horse/armor/horse_armor_iron.png")) {
                return Config.itemsMap.getLightFromItemStack(new ItemStack(Items.field_151138_bX));
            }
            if (horseArmorTexture.equals("textures/entity/horse/armor/horse_armor_diamond.png")) {
                return Config.itemsMap.getLightFromItemStack(new ItemStack(Items.field_151125_bZ));
            }
        }
        return this.getMobEquipMaxLight(ent);
    }

    private int getMobEquipMaxLight(EntityLivingBase ent) {
        int light = 0;
        for (ItemStack item : ent.func_184209_aF()) {
            light = LightUtils.maxLight(light, Config.itemsMap.getLightFromItemStack(item));
        }
        return light;
    }

    @Override
    public int getLightLevel() {
        if (this.entity.getEntityData().func_74779_i("InfernalMobsMod").length() > 0) {
            return 10;
        }
        return this.getEquipmentLightLevel((EntityLivingBase)this.entity);
    }
}

