/*
 * Decompiled with CFR 0.152.
 */
package lakmoore.sel.client.adaptors;

import com.google.common.collect.ImmutableList;
import lakmoore.sel.client.Config;
import lakmoore.sel.client.LightUtils;
import lakmoore.sel.client.SEL;
import lakmoore.sel.client.adaptors.BaseAdaptor;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.event.FMLInterModComms;

public class PlayerSelfAdaptor
extends BaseAdaptor {
    EntityPlayer thePlayer;

    public PlayerSelfAdaptor(EntityPlayer entity) {
        super((Entity)entity);
        this.thePlayer = entity;
    }

    @Override
    public int getLightLevel() {
        if (this.thePlayer != null && this.thePlayer.func_70089_S() && !SEL.disabled && this.thePlayer.field_70175_ag) {
            ImmutableList messages = FMLInterModComms.fetchRuntimeMessages((Object)this);
            if (messages.size() > 0) {
                FMLInterModComms.IMCMessage imcMessage = (FMLInterModComms.IMCMessage)messages.get(messages.size() - 1);
                if (imcMessage.key.equalsIgnoreCase("forceplayerlighton")) {
                    if (!SEL.fmlOverrideEnable) {
                        SEL.fmlOverrideEnable = true;
                        return 15;
                    }
                } else if (imcMessage.key.equalsIgnoreCase("forceplayerlightoff") && SEL.fmlOverrideEnable) {
                    SEL.fmlOverrideEnable = false;
                    return 0;
                }
            }
            if (!SEL.fmlOverrideEnable) {
                if (this.thePlayer.func_70027_ad()) {
                    return 15;
                }
                boolean inWater = this.checkPlayerWater(this.thePlayer);
                int lightLevel = 0;
                for (ItemStack stack : this.thePlayer.func_184209_aF()) {
                    if (stack == null || inWater && Config.notWaterProofItems.retrieveValue(stack.func_77973_b().getRegistryName(), stack.func_77960_j()) != 0) continue;
                    lightLevel = LightUtils.maxLight(lightLevel, Config.itemsMap.getLightFromItemStack(stack));
                }
                return lightLevel;
            }
        }
        return 0;
    }

    private boolean checkPlayerWater(EntityPlayer thePlayer) {
        if (thePlayer.func_70090_H()) {
            return thePlayer.field_70170_p.func_180495_p(new BlockPos(thePlayer.func_174824_e(1.0f))).func_185904_a() == Material.field_151586_h;
        }
        return false;
    }

    @Override
    public void kill() {
        super.kill();
        this.thePlayer = null;
    }
}

