/*
 * Decompiled with CFR 0.152.
 */
package lakmoore.sel.client.model.pipeline;

import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;
import lakmoore.sel.capabilities.ILitChunkCache;
import lakmoore.sel.client.ClientProxy;
import lakmoore.sel.client.LightUtils;
import net.minecraft.client.renderer.EntityRenderer;
import net.minecraft.client.renderer.color.BlockColors;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.client.renderer.vertex.VertexFormatElement;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.client.model.pipeline.LightUtil;
import net.minecraftforge.client.model.pipeline.VertexLighterFlat;

public class VertexLighterSEL
extends VertexLighterFlat {
    protected int tint = -1;
    protected boolean diffuse = true;

    public VertexLighterSEL(BlockColors blockColorsIn) {
        super(blockColorsIn);
    }

    protected void processQuad() {
        int v;
        float[][] position = this.quadData[this.posIndex];
        float[][] normal = null;
        float[][] lightmap = this.quadData[this.lightmapIndex];
        float[][] color = this.quadData[this.colorIndex];
        if (this.dataLength[this.normalIndex] >= 3 && (this.quadData[this.normalIndex][0][0] != -1.0f || this.quadData[this.normalIndex][0][1] != -1.0f || this.quadData[this.normalIndex][0][2] != -1.0f)) {
            normal = this.quadData[this.normalIndex];
        } else {
            normal = new float[4][4];
            Vector3f v1 = new Vector3f(position[3]);
            Vector3f t = new Vector3f(position[1]);
            Vector3f v2 = new Vector3f(position[2]);
            v1.sub((Tuple3f)t);
            t.set(position[0]);
            v2.sub((Tuple3f)t);
            v1.cross(v2, v1);
            v1.normalize();
            for (v = 0; v < 4; ++v) {
                normal[v][0] = v1.x;
                normal[v][1] = v1.y;
                normal[v][2] = v1.z;
                normal[v][3] = 0.0f;
            }
        }
        int multiplier = -1;
        if (this.tint != -1) {
            multiplier = this.blockInfo.getColorMultiplier(this.tint);
        }
        VertexFormat format = this.parent.getVertexFormat();
        int count = format.func_177345_h();
        for (v = 0; v < 4; ++v) {
            float[] fArray = position[v];
            fArray[0] = fArray[0] + this.blockInfo.getShx();
            float[] fArray2 = position[v];
            fArray2[1] = fArray2[1] + this.blockInfo.getShy();
            float[] fArray3 = position[v];
            fArray3[2] = fArray3[2] + this.blockInfo.getShz();
            float x = position[v][0] - 0.5f;
            float y = position[v][1] - 0.5f;
            float z = position[v][2] - 0.5f;
            float blockLight = lightmap[v][0];
            float skyLight = lightmap[v][1];
            this.updateLightmap(normal[v], lightmap[v], x += normal[v][0] * 0.5f, y += normal[v][1] * 0.5f, z += normal[v][2] * 0.5f);
            if (this.dataLength[this.lightmapIndex] > 1) {
                if (blockLight > lightmap[v][0]) {
                    lightmap[v][0] = blockLight;
                }
                if (skyLight > lightmap[v][1]) {
                    lightmap[v][1] = skyLight;
                }
            }
            this.updateColor(normal[v], color[v], x, y, z, this.tint, multiplier);
            if (this.diffuse) {
                float d = LightUtil.diffuseLight((float)normal[v][0], (float)normal[v][1], (float)normal[v][2]);
                int i = 0;
                while (i < 3) {
                    float[] fArray4 = color[v];
                    int n = i++;
                    fArray4[n] = fArray4[n] * d;
                }
            }
            if (EntityRenderer.field_78517_a) {
                this.applyAnaglyph(color[v]);
            }
            Vec3d vertPos = new Vec3d((Vec3i)this.blockInfo.getBlockPos()).func_72441_c((double)position[v][0], (double)position[v][1], (double)position[v][2]);
            ILitChunkCache lcc = LightUtils.getLitChunkCache((World)ClientProxy.mcinstance.field_71441_e, (int)Math.round(vertPos.field_72450_a) >> 4, (int)Math.round(vertPos.field_72449_c) >> 4);
            lcc.setMCVertexLight(vertPos.field_72450_a, vertPos.field_72448_b, vertPos.field_72449_c, (short)Math.round(lightmap[v][0] * 32767.0f));
            lightmap[v][0] = (float)lcc.getVertexLight(vertPos.field_72450_a, vertPos.field_72448_b, vertPos.field_72449_c) / 32767.0f;
        }
        int[] order = new int[]{0, 1, 2, 3};
        int[] flipped = new int[]{1, 2, 3, 0};
        if (lightmap[3][0] + lightmap[3][1] - (lightmap[0][0] + lightmap[0][1]) < lightmap[2][0] + lightmap[2][1] - (lightmap[1][0] + lightmap[1][1])) {
            order = flipped;
        }
        for (int v2 = 0; v2 < 4; ++v2) {
            block16: for (int e = 0; e < count; ++e) {
                VertexFormatElement element = format.func_177348_c(e);
                switch (element.func_177375_c()) {
                    case POSITION: {
                        this.parent.put(e, position[order[v2]]);
                        continue block16;
                    }
                    case NORMAL: {
                        if (this.normalIndex != -1) {
                            this.parent.put(e, normal[order[v2]]);
                            continue block16;
                        }
                    }
                    case COLOR: {
                        boolean debug = false;
                        if (debug) {
                            switch (order[v2]) {
                                case 0: {
                                    this.parent.put(e, new float[]{0.9019608f, 0.09803922f, 0.29411766f, 1.0f});
                                    break;
                                }
                                case 1: {
                                    this.parent.put(e, new float[]{1.0f, 1.0f, 0.09803922f, 1.0f});
                                    break;
                                }
                                case 2: {
                                    this.parent.put(e, new float[]{0.23529412f, 0.7058824f, 0.29411766f, 1.0f});
                                    break;
                                }
                                case 3: {
                                    this.parent.put(e, new float[]{0.0f, 0.50980395f, 0.78431374f, 1.0f});
                                }
                            }
                            continue block16;
                        }
                        this.parent.put(e, color[order[v2]]);
                        continue block16;
                    }
                    case UV: {
                        if (element.func_177369_e() == 1) {
                            this.parent.put(e, lightmap[order[v2]]);
                            continue block16;
                        }
                    }
                    default: {
                        this.parent.put(e, this.quadData[e][order[v2]]);
                    }
                }
            }
        }
        this.tint = -1;
    }

    public void setQuadTint(int tint) {
        super.setQuadTint(tint);
        this.tint = tint;
        if (tint > 0) {
            System.out.println("Tint set to " + tint);
        }
    }

    public void setApplyDiffuseLighting(boolean diffuse) {
        super.setApplyDiffuseLighting(diffuse);
        this.diffuse = diffuse;
    }
}

