/*
 * Decompiled with CFR 0.152.
 */
package lakmoore.sel.common;

import com.google.common.collect.Iterators;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.collect.UnmodifiableIterator;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.util.ClassInheritanceMultiMap;

public class SELClassInheritanceMultiMap<T>
extends ClassInheritanceMultiMap<T> {
    private static final Set<Class<?>> ALL_KNOWN = Collections.newSetFromMap(new ConcurrentHashMap());
    private final Map<Class<?>, Set<T>> map = Maps.newHashMap();
    private final Set<Class<?>> knownKeys = Sets.newIdentityHashSet();
    private final Class<T> baseClass;
    private final Set<T> values = ConcurrentHashMap.newKeySet();

    public SELClassInheritanceMultiMap(Class<T> baseClassIn) {
        super(baseClassIn);
        this.baseClass = baseClassIn;
        this.knownKeys.add(baseClassIn);
        this.map.put(baseClassIn, this.values);
        for (Class<?> oclass : ALL_KNOWN) {
            this.func_180213_a(oclass);
        }
    }

    protected void func_180213_a(Class<?> clazz) {
        ALL_KNOWN.add(clazz);
        for (T t : this.values) {
            if (!clazz.isAssignableFrom(t.getClass())) continue;
            this.addForClass(t, clazz);
        }
        this.knownKeys.add(clazz);
    }

    protected Class<?> func_181157_b(Class<?> clazz) {
        if (this.baseClass.equals(clazz)) {
            return clazz;
        }
        if (this.baseClass.isAssignableFrom(clazz)) {
            if (!this.knownKeys.contains(clazz)) {
                this.func_180213_a(clazz);
            }
            return clazz;
        }
        throw new IllegalArgumentException("Don't know how to search for " + clazz);
    }

    public boolean add(T p_add_1_) {
        for (Class<?> oclass : this.knownKeys) {
            if (!oclass.isAssignableFrom(p_add_1_.getClass())) continue;
            this.addForClass(p_add_1_, oclass);
        }
        return true;
    }

    private void addForClass(T value, Class<?> parentClass) {
        Set<T> set = this.map.get(parentClass);
        if (set == null) {
            set = ConcurrentHashMap.newKeySet();
            this.map.put(parentClass, set);
        }
        set.add(value);
    }

    public boolean remove(Object p_remove_1_) {
        Object t = p_remove_1_;
        boolean flag = false;
        for (Class<?> oclass : this.knownKeys) {
            Set<T> list;
            if (!oclass.isAssignableFrom(t.getClass()) || (list = this.map.get(oclass)) == null || !list.remove(t)) continue;
            flag = true;
        }
        return flag;
    }

    public boolean contains(Object p_contains_1_) {
        return Iterators.contains(this.func_180215_b(p_contains_1_.getClass()).iterator(), (Object)p_contains_1_);
    }

    public <S> Iterable<S> func_180215_b(final Class<S> clazz) {
        return new Iterable<S>(){

            @Override
            public Iterator<S> iterator() {
                Class<?> c = SELClassInheritanceMultiMap.this.func_181157_b(clazz);
                Set set = (Set)SELClassInheritanceMultiMap.this.map.get(c);
                if (set == null) {
                    return Collections.emptyIterator();
                }
                UnmodifiableIterator iterator = set.iterator();
                return clazz == c ? iterator : Iterators.filter(iterator, (Class)clazz);
            }
        };
    }

    public Iterator<T> iterator() {
        return this.values.isEmpty() ? Collections.emptyIterator() : Iterators.unmodifiableIterator(this.values.iterator());
    }

    public int size() {
        return this.values.size();
    }
}

