/*
 * Decompiled with CFR 0.152.
 */
package lakmoore.sel.common;

import java.util.Iterator;
import java.util.ListIterator;
import lakmoore.sel.common.SELClassWriter;
import net.minecraft.launchwrapper.IClassTransformer;
import net.minecraft.launchwrapper.Launch;
import net.minecraftforge.fml.common.FMLLog;
import org.apache.logging.log4j.Level;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TypeInsnNode;

public class Transformer
implements IClassTransformer {
    private final String constructorName = "<init>";
    private final String classWorldClientName = "net.minecraft.client.multiplayer.WorldClient";
    private final String classWorldNameOLD = "net/minecraft/world/World";
    private final String classWorldNameNEW = "lakmoore/sel/world/WorldSEL";
    private final String classRenderChunkName = "net.minecraft.client.renderer.chunk.RenderChunk";
    private final String methodCreateRegionRenderCacheName = "createRegionRenderCache";
    private final String classChunkCacheNameOLD = "net/minecraft/world/ChunkCache";
    private final String classChunkCacheNameNEW = "lakmoore/sel/world/ChunkCacheSEL";
    private final String classChunkName = "net.minecraft.world.chunk.Chunk";
    private final String classMultiMapNameOLD = "net/minecraft/util/ClassInheritanceMultiMap";
    private final String classMultiMapNameNEW = "lakmoore/sel/common/SELClassInheritanceMultiMap";
    private final String classForgeBlockModelRendererName = "net.minecraftforge.client.model.pipeline.ForgeBlockModelRenderer";
    private final String methodNewVertexLighterName = "lambda$new$0";
    private final String classVertexLighterOLD = "net/minecraftforge/client/model/pipeline/VertexLighterFlat";
    private final String classVertexLighterNEW = "lakmoore/sel/client/model/pipeline/VertexLighterSEL";
    private final String classVertexLighterSmoothAoName = "net.minecraftforge.client.model.pipeline.VertexLighterSmoothAo";

    private static void log(String message) {
        FMLLog.info((String)"%s", (Object[])new Object[]{message});
    }

    private static void error(String message) {
        FMLLog.log((String)"SmoothEntityLights", (Level)Level.ERROR, (String)"%s", (Object[])new Object[]{message});
    }

    public byte[] transform(String name, String newName, byte[] bytes) {
        boolean obf;
        boolean bl = obf = !name.equals(newName);
        if (newName.equals("net.minecraft.client.multiplayer.WorldClient")) {
            Transformer.log("********* INSIDE TRANSFORMER ABOUT TO PATCH: " + name + "|" + newName);
            return this.handleWorldClientTransform(bytes, obf);
        }
        if (newName.equals("net.minecraft.client.renderer.chunk.RenderChunk")) {
            Transformer.log("********* INSIDE TRANSFORMER ABOUT TO PATCH: " + name + "|" + newName);
            return this.handleChunkCacheTransform(bytes, obf);
        }
        if (newName.equals("net.minecraft.world.chunk.Chunk")) {
            Transformer.log("********* INSIDE TRANSFORMER ABOUT TO PATCH: " + name + "|" + newName);
            return this.handleChunkTransform(bytes, obf);
        }
        if (newName.equals("net.minecraftforge.client.model.pipeline.ForgeBlockModelRenderer")) {
            Transformer.log("********* INSIDE TRANSFORMER ABOUT TO PATCH: " + name + "|" + newName);
            return this.handleVertexLighterTransform(bytes, obf);
        }
        if (newName.equals("net.minecraftforge.client.model.pipeline.VertexLighterSmoothAo")) {
            Transformer.log("********* INSIDE TRANSFORMER ABOUT TO PATCH: " + name + "|" + newName);
            return this.handleVertexLighterSmoothAoTransform(bytes, obf);
        }
        return bytes;
    }

    private byte[] handleChunkTransform(byte[] bytes, boolean obf) {
        Transformer.log("Patching Chunk, obf: " + obf);
        ClassNode classNode = new ClassNode();
        ClassReader classReader = new ClassReader(bytes);
        classReader.accept((ClassVisitor)classNode, 0);
        Boolean found = false;
        Iterator methods = classNode.methods.iterator();
        while (methods.hasNext() && !found.booleanValue()) {
            MethodNode m = (MethodNode)methods.next();
            if (!m.name.equals("<init>")) continue;
            AbstractInsnNode targetNode = null;
            ListIterator iter = m.instructions.iterator();
            while (iter.hasNext() && !found.booleanValue()) {
                TypeInsnNode node;
                targetNode = (AbstractInsnNode)iter.next();
                if (targetNode instanceof TypeInsnNode && targetNode.getOpcode() == 187) {
                    node = (TypeInsnNode)targetNode;
                    if (!node.desc.equals("net/minecraft/util/ClassInheritanceMultiMap")) continue;
                    node.desc = "lakmoore/sel/common/SELClassInheritanceMultiMap";
                    Transformer.log("Patched MultiMap New!");
                    continue;
                }
                if (!(targetNode instanceof MethodInsnNode) || targetNode.getOpcode() != 183) continue;
                node = (MethodInsnNode)targetNode;
                if (!node.owner.equals("net/minecraft/util/ClassInheritanceMultiMap")) continue;
                node.owner = "lakmoore/sel/common/SELClassInheritanceMultiMap";
                found = true;
                Transformer.log("Patched MultiMap Init!");
            }
        }
        ClassWriter writer = new ClassWriter(2);
        classNode.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }

    private byte[] handleChunkCacheTransform(byte[] bytes, boolean obf) {
        Transformer.log("Patching ChunkCache, obf: " + obf);
        ClassNode classNode = new ClassNode();
        ClassReader classReader = new ClassReader(bytes);
        classReader.accept((ClassVisitor)classNode, 0);
        Boolean found = false;
        Iterator methods = classNode.methods.iterator();
        while (methods.hasNext() && !found.booleanValue()) {
            MethodNode m = (MethodNode)methods.next();
            if (!"createRegionRenderCache".equals(m.name)) continue;
            AbstractInsnNode targetNode = null;
            ListIterator iter = m.instructions.iterator();
            while (iter.hasNext() && !found.booleanValue()) {
                TypeInsnNode node;
                targetNode = (AbstractInsnNode)iter.next();
                if (targetNode instanceof TypeInsnNode && targetNode.getOpcode() == 187) {
                    node = (TypeInsnNode)targetNode;
                    if (!node.desc.equals("net/minecraft/world/ChunkCache")) continue;
                    node.desc = "lakmoore/sel/world/ChunkCacheSEL";
                    Transformer.log("Patched ChunkCache New!");
                    continue;
                }
                if (!(targetNode instanceof MethodInsnNode) || targetNode.getOpcode() != 183) continue;
                node = (MethodInsnNode)targetNode;
                if (!node.owner.equals("net/minecraft/world/ChunkCache")) continue;
                node.owner = "lakmoore/sel/world/ChunkCacheSEL";
                found = true;
                Transformer.log("Patched ChunkCache Init!");
            }
        }
        ClassWriter writer = new ClassWriter(2);
        classNode.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }

    private byte[] handleWorldClientTransform(byte[] bytes, boolean obf) {
        Transformer.log("Patching WorldClient, obf: " + obf);
        boolean found = false;
        ClassNode classNode = new ClassNode();
        ClassReader classReader = new ClassReader(bytes);
        classReader.accept((ClassVisitor)classNode, 0);
        classNode.superName = "lakmoore/sel/world/WorldSEL";
        Iterator methods = classNode.methods.iterator();
        while (methods.hasNext() && !found) {
            MethodNode m = (MethodNode)methods.next();
            if (!m.name.equals("<init>")) continue;
            AbstractInsnNode targetNode = null;
            ListIterator iter = m.instructions.iterator();
            while (iter.hasNext() && !found) {
                targetNode = (AbstractInsnNode)iter.next();
                if (!(targetNode instanceof MethodInsnNode)) continue;
                MethodInsnNode node = (MethodInsnNode)targetNode;
                if (!node.owner.equals("net/minecraft/world/World") || !node.name.equals("<init>")) continue;
                node.owner = "lakmoore/sel/world/WorldSEL";
                Transformer.log("Patched World Init!");
                found = true;
            }
        }
        SELClassWriter writer = new SELClassWriter(2);
        writer.setClassLoader((ClassLoader)Launch.classLoader);
        classNode.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }

    private byte[] handleVertexLighterTransform(byte[] bytes, boolean obf) {
        Transformer.log("Patching ForgeBlockModelRenderer, obf: " + obf);
        ClassNode classNode = new ClassNode();
        ClassReader classReader = new ClassReader(bytes);
        classReader.accept((ClassVisitor)classNode, 0);
        Boolean found = false;
        Iterator fields = classNode.fields.iterator();
        while (fields.hasNext() && !found.booleanValue()) {
            FieldNode field = (FieldNode)fields.next();
            if (!field.signature.equals("Ljava/lang/ThreadLocal<L" + this.classVertexLighterOLD + ";>;")) continue;
            field.signature = "Ljava/lang/ThreadLocal<L" + this.classVertexLighterNEW + ";>;";
            System.out.println("Descriptor: " + field.desc.toString());
            found = true;
        }
        found = false;
        Iterator methods = classNode.methods.iterator();
        while (methods.hasNext() && !found.booleanValue()) {
            MethodNode m = (MethodNode)methods.next();
            if (!"lambda$new$0".equals(m.name)) continue;
            AbstractInsnNode targetNode = null;
            ListIterator iter = m.instructions.iterator();
            while (iter.hasNext() && !found.booleanValue()) {
                TypeInsnNode node;
                targetNode = (AbstractInsnNode)iter.next();
                if (targetNode instanceof TypeInsnNode && targetNode.getOpcode() == 187) {
                    node = (TypeInsnNode)targetNode;
                    if (!node.desc.equals("net/minecraftforge/client/model/pipeline/VertexLighterFlat")) continue;
                    node.desc = "lakmoore/sel/client/model/pipeline/VertexLighterSEL";
                    Transformer.log("Patched VertexLighter::new()");
                    continue;
                }
                if (!(targetNode instanceof MethodInsnNode) || targetNode.getOpcode() != 183) continue;
                node = (MethodInsnNode)targetNode;
                if (!node.owner.equals("net/minecraftforge/client/model/pipeline/VertexLighterFlat")) continue;
                node.owner = "lakmoore/sel/client/model/pipeline/VertexLighterSEL";
                found = true;
                Transformer.log("Patched VertexLighter::<init>()");
            }
        }
        ClassWriter writer = new ClassWriter(2);
        classNode.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }

    private byte[] handleVertexLighterSmoothAoTransform(byte[] bytes, boolean obf) {
        Transformer.log("Patching VertexLighterSmoothAo, obf: " + obf);
        ClassNode classNode = new ClassNode();
        ClassReader classReader = new ClassReader(bytes);
        classReader.accept((ClassVisitor)classNode, 0);
        boolean found = false;
        classNode.superName = "lakmoore/sel/client/model/pipeline/VertexLighterSEL";
        Iterator methods = classNode.methods.iterator();
        while (methods.hasNext() && !found) {
            MethodNode m = (MethodNode)methods.next();
            if (!m.name.equals("<init>")) continue;
            AbstractInsnNode targetNode = null;
            ListIterator iter = m.instructions.iterator();
            while (iter.hasNext() && !found) {
                targetNode = (AbstractInsnNode)iter.next();
                if (!(targetNode instanceof MethodInsnNode)) continue;
                MethodInsnNode node = (MethodInsnNode)targetNode;
                if (!node.owner.equals("net/minecraftforge/client/model/pipeline/VertexLighterFlat") || !node.name.equals("<init>")) continue;
                node.owner = "lakmoore/sel/client/model/pipeline/VertexLighterSEL";
                Transformer.log("Patched VertexLighterSmoothAo Init!");
                found = true;
            }
        }
        ClassWriter writer = new ClassWriter(2);
        classNode.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }
}

