/*
 * Decompiled with CFR 0.152.
 */
package lakmoore.sel.world;

import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;

public class DirtyRayTrace {
    private IBlockAccess world;

    public DirtyRayTrace(IBlockAccess world) {
        this.world = world;
    }

    public int rayTraceForOpacity(Vec3d startPos, Vec3d endPos) {
        int result = 0;
        if (!(Double.isNaN(startPos.field_72450_a) || Double.isNaN(startPos.field_72448_b) || Double.isNaN(startPos.field_72449_c) || Double.isNaN(endPos.field_72450_a) || Double.isNaN(endPos.field_72448_b) || Double.isNaN(endPos.field_72449_c))) {
            RayTraceResult rtr;
            Vec3d currentPos = new Vec3d(startPos.field_72450_a, startPos.field_72448_b, startPos.field_72449_c);
            boolean sameBlock = false;
            do {
                Block block;
                if ((rtr = this.blockRayTrace(currentPos, endPos)) == null) continue;
                currentPos = rtr.field_72307_f;
                BlockPos thisBlock = rtr.func_178782_a();
                IBlockState state = this.world.func_180495_p(thisBlock);
                if (state != null && (block = state.func_177230_c()) != null && block != Blocks.field_150350_a) {
                    result += state.getLightOpacity(this.world, thisBlock);
                }
                sameBlock = new BlockPos(currentPos).equals((Object)new BlockPos(endPos));
            } while (result < 15 && rtr != null && !sameBlock);
        }
        return Math.max(0, Math.min(15, result));
    }

    private RayTraceResult blockRayTrace(Vec3d startVec, Vec3d endVec) {
        BlockPos startBlockPos = new BlockPos(startVec);
        BlockPos endBlockPos = new BlockPos(endVec);
        if (startBlockPos.equals((Object)endBlockPos)) {
            return null;
        }
        Vec3d fromVec = startVec.func_178786_a((double)startBlockPos.func_177958_n(), (double)startBlockPos.func_177956_o(), (double)startBlockPos.func_177952_p());
        Vec3d toVec = endVec.func_178786_a((double)startBlockPos.func_177958_n(), (double)startBlockPos.func_177956_o(), (double)startBlockPos.func_177952_p());
        Vec3d hitPoint = null;
        if (toVec.field_72450_a < 0.0 && fromVec.field_72450_a == 0.0) {
            fromVec = fromVec.func_72441_c(1.0, 0.0, 0.0);
            toVec = toVec.func_72441_c(1.0, 0.0, 0.0);
            startBlockPos = startBlockPos.func_177982_a(-1, 0, 0);
        }
        if (toVec.field_72448_b < 0.0 && fromVec.field_72448_b == 0.0) {
            fromVec = fromVec.func_72441_c(0.0, 1.0, 0.0);
            toVec = toVec.func_72441_c(0.0, 1.0, 0.0);
            startBlockPos = startBlockPos.func_177982_a(0, -1, 0);
        }
        if (toVec.field_72449_c < 0.0 && fromVec.field_72449_c == 0.0) {
            fromVec = fromVec.func_72441_c(0.0, 0.0, 1.0);
            toVec = toVec.func_72441_c(0.0, 0.0, 1.0);
            startBlockPos = startBlockPos.func_177982_a(0, 0, -1);
        }
        if (toVec.field_72450_a < 0.0 && (hitPoint = fromVec.func_72429_b(toVec, 0.0)) != null && this.inBounds(hitPoint.field_72448_b) && this.inBounds(hitPoint.field_72449_c)) {
            hitPoint = hitPoint.func_178787_e(new Vec3d((Vec3i)startBlockPos));
            return new RayTraceResult(RayTraceResult.Type.BLOCK, hitPoint, EnumFacing.DOWN, startBlockPos.func_177982_a(-1, 0, 0));
        }
        if (toVec.field_72450_a > 1.0 && (hitPoint = fromVec.func_72429_b(toVec, 1.0)) != null && this.inBounds(hitPoint.field_72448_b) && this.inBounds(hitPoint.field_72449_c)) {
            hitPoint = hitPoint.func_178787_e(new Vec3d((Vec3i)startBlockPos));
            return new RayTraceResult(RayTraceResult.Type.BLOCK, hitPoint, EnumFacing.DOWN, startBlockPos.func_177982_a(1, 0, 0));
        }
        if (toVec.field_72448_b < 0.0 && (hitPoint = fromVec.func_72435_c(toVec, 0.0)) != null && this.inBounds(hitPoint.field_72450_a) && this.inBounds(hitPoint.field_72449_c)) {
            hitPoint = hitPoint.func_178787_e(new Vec3d((Vec3i)startBlockPos));
            return new RayTraceResult(RayTraceResult.Type.BLOCK, hitPoint, EnumFacing.DOWN, startBlockPos.func_177982_a(0, -1, 0));
        }
        if (toVec.field_72448_b > 1.0 && (hitPoint = fromVec.func_72435_c(toVec, 1.0)) != null && this.inBounds(hitPoint.field_72450_a) && this.inBounds(hitPoint.field_72449_c)) {
            hitPoint = hitPoint.func_178787_e(new Vec3d((Vec3i)startBlockPos));
            return new RayTraceResult(RayTraceResult.Type.BLOCK, hitPoint, EnumFacing.UP, startBlockPos.func_177982_a(0, 1, 0));
        }
        if (toVec.field_72449_c < 0.0 && (hitPoint = fromVec.func_72434_d(toVec, 0.0)) != null && this.inBounds(hitPoint.field_72450_a) && this.inBounds(hitPoint.field_72448_b)) {
            hitPoint = hitPoint.func_178787_e(new Vec3d((Vec3i)startBlockPos));
            return new RayTraceResult(RayTraceResult.Type.BLOCK, hitPoint, EnumFacing.DOWN, startBlockPos.func_177982_a(0, 0, -1));
        }
        if (toVec.field_72449_c > 1.0 && (hitPoint = fromVec.func_72434_d(toVec, 1.0)) != null && this.inBounds(hitPoint.field_72450_a) && this.inBounds(hitPoint.field_72448_b)) {
            hitPoint = hitPoint.func_178787_e(new Vec3d((Vec3i)startBlockPos));
            return new RayTraceResult(RayTraceResult.Type.BLOCK, hitPoint, EnumFacing.DOWN, startBlockPos.func_177982_a(0, 0, 1));
        }
        return null;
    }

    private boolean inBounds(double coord) {
        return coord >= 0.0 && coord <= 1.0;
    }
}

