/*
 * Decompiled with CFR 0.152.
 */
package com.shynieke.statues.items;

import com.shynieke.statues.blocks.statues.PlayerStatueBlock;
import com.shynieke.statues.init.StatueTabs;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemFrameEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class PlayerCompassItem
extends Item {
    public PlayerCompassItem(Item.Properties builder) {
        super(builder.func_200916_a(StatueTabs.STATUES_ITEMS));
        this.func_185043_a(new ResourceLocation("angle"), new IItemPropertyGetter(){
            @OnlyIn(value=Dist.CLIENT)
            double rotation;
            @OnlyIn(value=Dist.CLIENT)
            double rota;
            @OnlyIn(value=Dist.CLIENT)
            long lastUpdateTick;

            @OnlyIn(value=Dist.CLIENT)
            public float call(ItemStack stack, @Nullable World worldIn, @Nullable LivingEntity entityIn) {
                LivingEntity entity;
                if (entityIn == null && !stack.func_82839_y()) {
                    return 0.0f;
                }
                boolean flag = entityIn != null;
                Object object = entity = flag ? entityIn : stack.func_82836_z();
                if (worldIn == null) {
                    worldIn = entity.field_70170_p;
                }
                double d1 = flag ? (double)entity.field_70177_z : this.getFrameRotation((ItemFrameEntity)entity);
                d1 = MathHelper.func_191273_b((double)(d1 / 360.0), (double)1.0);
                double d2 = this.getLastLocationToAngle(worldIn, (Entity)entity, stack) / (Math.PI * 2);
                double d0 = 0.5 - (d1 - 0.25 - d2);
                if (flag) {
                    d0 = this.wobble(worldIn, d0);
                }
                return MathHelper.func_188207_b((float)((float)d0), (float)1.0f);
            }

            @OnlyIn(value=Dist.CLIENT)
            private double wobble(World worldIn, double p_185093_2_) {
                if (worldIn.func_82737_E() != this.lastUpdateTick) {
                    this.lastUpdateTick = worldIn.func_82737_E();
                    double d0 = p_185093_2_ - this.rotation;
                    d0 = MathHelper.func_191273_b((double)(d0 + 0.5), (double)1.0) - 0.5;
                    this.rota += d0 * 0.1;
                    this.rota *= 0.8;
                    this.rotation = MathHelper.func_191273_b((double)(this.rotation + this.rota), (double)1.0);
                }
                return this.rotation;
            }

            @OnlyIn(value=Dist.CLIENT)
            private double getFrameRotation(ItemFrameEntity itemFrameIn) {
                return MathHelper.func_188209_b((int)(180 + itemFrameIn.func_174811_aO().func_176736_b() * 90));
            }

            @OnlyIn(value=Dist.CLIENT)
            private double getLastLocationToAngle(World worldIn, Entity entityIn, ItemStack stack) {
                if (stack.func_77942_o()) {
                    long location;
                    BlockPos lastLocation = worldIn.func_175694_M();
                    CompoundNBT tag = stack.func_77978_p();
                    if (tag.func_74764_b("lastPlayerLocation") && (location = tag.func_74763_f("lastPlayerLocation")) != 0L) {
                        lastLocation = BlockPos.func_218283_e((long)location);
                    }
                    return Math.atan2((double)lastLocation.func_177952_p() - entityIn.func_226281_cx_(), (double)lastLocation.func_177958_n() - entityIn.func_226281_cx_());
                }
                return this.getSpawnToAngle((IWorld)worldIn, entityIn);
            }

            @OnlyIn(value=Dist.CLIENT)
            private double getSpawnToAngle(IWorld worldIn, Entity entityIn) {
                BlockPos spawnPos = worldIn.func_175694_M();
                return Math.atan2((double)spawnPos.func_177952_p() - entityIn.func_226281_cx_(), (double)spawnPos.func_177958_n() - entityIn.func_226277_ct_());
            }
        });
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        World worldIn = context.func_195991_k();
        BlockPos pos = context.func_195995_a();
        PlayerEntity playerIn = context.func_195999_j();
        if (!worldIn.field_72995_K && playerIn != null && playerIn.func_225608_bj_() && worldIn.func_180495_p(pos).func_177230_c() instanceof PlayerStatueBlock) {
            playerIn.func_184611_a(context.func_221531_n(), new ItemStack((IItemProvider)Items.field_151111_aL));
        }
        return super.func_195939_a(context);
    }

    public void func_77624_a(ItemStack stack, @Nullable World reader, List<ITextComponent> tooltip, ITooltipFlag flag) {
        CompoundNBT tag;
        if (stack.func_77942_o() && !(tag = stack.func_77978_p()).func_74779_i("playerTracking").isEmpty()) {
            tooltip.add(new TranslationTextComponent("statues.last.known.location", new Object[]{tag.func_74779_i("playerTracking")}).func_211708_a(TextFormatting.GOLD));
        }
    }
}

