/*
 * Decompiled with CFR 0.152.
 */
package com.shynieke.statues.blocks;

import com.shynieke.statues.blocks.AbstractBaseBlock;
import com.shynieke.statues.tiles.StatueTile;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.NoteBlock;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public abstract class AbstractStatueBase
extends AbstractBaseBlock {
    private static final VoxelShape SHAPE = Block.func_208617_a((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)16.0, (double)11.0);
    public static final BooleanProperty INTERACTIVE = BooleanProperty.func_177716_a((String)"interactive");

    public AbstractStatueBase(AbstractBlock.Properties builder) {
        super(builder.func_200943_b(0.6f));
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)field_185512_D, (Comparable)Direction.NORTH)).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)INTERACTIVE, (Comparable)Boolean.valueOf(false)));
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity playerIn, Hand handIn, BlockRayTraceResult result) {
        if (!worldIn.field_72995_K && handIn == Hand.MAIN_HAND && this.canPlaySound(worldIn, pos, state)) {
            worldIn.func_184133_a(null, pos, this.getSound(state), SoundCategory.NEUTRAL, 1.0f, this.getPitch());
        }
        if (((Boolean)state.func_177229_b((Property)INTERACTIVE)).booleanValue() && handIn == Hand.MAIN_HAND && !worldIn.field_72995_K && this.getTE(worldIn, pos) != null) {
            this.executeStatueBehavior(this.getTE(worldIn, pos), state, worldIn, pos, playerIn, handIn, result);
        }
        return ActionResultType.SUCCESS;
    }

    public StatueTile getTE(World world, BlockPos pos) {
        return world.func_175625_s(pos) instanceof StatueTile ? (StatueTile)world.func_175625_s(pos) : null;
    }

    public void executeStatueBehavior(StatueTile tile, BlockState state, World worldIn, BlockPos pos, PlayerEntity playerIn, Hand handIn, BlockRayTraceResult result) {
    }

    public boolean hasTileEntity(BlockState state) {
        return (Boolean)state.func_177229_b((Property)INTERACTIVE) != false;
    }

    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        if (((Boolean)state.func_177229_b((Property)INTERACTIVE)).booleanValue()) {
            return new StatueTile();
        }
        return null;
    }

    public ItemStack func_185473_a(IBlockReader worldIn, BlockPos pos, BlockState state) {
        StatueTile statueTile;
        CompoundNBT compoundnbt;
        ItemStack itemstack = super.func_185473_a(worldIn, pos, state);
        if (((Boolean)state.func_177229_b((Property)INTERACTIVE)).booleanValue() && !(compoundnbt = (statueTile = (StatueTile)worldIn.func_175625_s(pos)).saveToNbt(new CompoundNBT())).isEmpty()) {
            itemstack.func_77983_a("BlockEntityTag", (INBT)compoundnbt);
        }
        return itemstack;
    }

    @Override
    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{field_185512_D, WATERLOGGED, INTERACTIVE});
    }

    public boolean func_200123_i(BlockState state, IBlockReader reader, BlockPos pos) {
        return true;
    }

    public void func_196243_a(BlockState state, World worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.func_177230_c() != newState.func_177230_c()) {
            super.func_196243_a(state, worldIn, pos, newState, isMoving);
            worldIn.func_175713_t(pos);
        }
    }

    public boolean canBeUpgraded() {
        return true;
    }

    public boolean isHiddenStatue() {
        return false;
    }

    public boolean isBaby() {
        return false;
    }

    public EntityType<?> getEntity() {
        return EntityType.field_200791_e;
    }

    public String getLootName() {
        return "baby_zombie";
    }

    public SoundEvent getSound(BlockState state) {
        return SoundEvents.field_187689_f;
    }

    public float getPitch() {
        return this.isBaby() ? (this.RANDOM.nextFloat() - this.RANDOM.nextFloat()) * 0.2f + 1.5f : (this.RANDOM.nextFloat() - this.RANDOM.nextFloat()) * 0.2f + 1.0f;
    }

    public boolean canPlaySound(World worldIn, BlockPos pos, BlockState state) {
        boolean flag = (Boolean)state.func_177229_b((Property)INTERACTIVE) != false && ((StatueTile)worldIn.func_175625_s(pos)).makesSounds();
        boolean flag2 = worldIn.func_180495_p(pos.func_177977_b()).func_177230_c() instanceof NoteBlock;
        return flag || flag2;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return SHAPE;
    }

    public void func_220069_a(BlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        if (!worldIn.field_72995_K && this.canPlaySound(worldIn, pos, state) && worldIn.func_175640_z(pos)) {
            worldIn.func_184133_a(null, pos, this.getSound(state), SoundCategory.NEUTRAL, 1.0f, (worldIn.field_73012_v.nextFloat() - worldIn.field_73012_v.nextFloat()) * 0.2f + 1.5f);
        }
        super.func_220069_a(state, worldIn, pos, blockIn, fromPos, isMoving);
    }
}

