/*
 * Decompiled with CFR 0.152.
 */
package com.shynieke.statues.recipes;

import com.shynieke.statues.init.StatueRegistry;
import com.shynieke.statues.recipes.LootInfo;
import com.shynieke.statues.recipes.StatueLootInfo;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.RegistryObject;

public class StatueLootList {
    public static ArrayList<StatueLootInfo> lootList = new ArrayList();
    public static StatueLootInfo loot_info;

    public static void initializeStatueLoot() {
        StatueLootList.addLoot("baby_zombie", new ItemStack((IItemProvider)Items.field_151078_bh), new ItemStack((IItemProvider)Items.field_191525_da), ItemStack.field_190927_a);
        StatueLootList.addLoot("bee", ItemStack.field_190927_a, new ItemStack((IItemProvider)Items.field_226635_pU_), ItemStack.field_190927_a);
        StatueLootList.addLoot("blaze", new ItemStack((IItemProvider)Items.field_151065_br), new ItemStack((IItemProvider)Items.field_151072_bj), ItemStack.field_190927_a);
        StatueLootList.addLoot("chicken", new ItemStack((IItemProvider)Items.field_151008_G), new ItemStack((IItemProvider)Items.field_151076_bf), ItemStack.field_190927_a);
        StatueLootList.addLoot("chicken_jockey", new ItemStack((IItemProvider)Items.field_151078_bh), new ItemStack((IItemProvider)Items.field_151008_G), ItemStack.field_190927_a);
        StatueLootList.addLoot("king_cluck", new ItemStack((IItemProvider)StatueRegistry.NUGGET.get()), ItemStack.field_190927_a, new ItemStack((IItemProvider)Items.field_151074_bl));
        StatueLootList.addLoot("cow", new ItemStack((IItemProvider)Items.field_151082_bd), ItemStack.field_190927_a, new ItemStack((IItemProvider)Items.field_151116_aA));
        StatueLootList.addLoot("creeper", new ItemStack((IItemProvider)Items.field_151016_H), ItemStack.field_190927_a, ItemStack.field_190927_a);
        StatueLootList.addLoot("enderman", new ItemStack((IItemProvider)StatueRegistry.PEBBLE.get(), 16), new ItemStack((IItemProvider)Items.field_151079_bi), ItemStack.field_190927_a);
        StatueLootList.addLoot("flood", ItemStack.field_190927_a, ItemStack.field_190927_a, ItemStack.field_190927_a);
        StatueLootList.addLoot("ghast", new ItemStack((IItemProvider)Items.field_151016_H), ItemStack.field_190927_a, new ItemStack((IItemProvider)Items.field_151073_bk));
        StatueLootList.addLoot("guardian", new ItemStack((IItemProvider)Items.field_196086_aW), new ItemStack((IItemProvider)Items.field_179562_cC), new ItemStack((IItemProvider)Items.field_179563_cD));
        StatueLootList.addLoot("husk", new ItemStack((IItemProvider)Items.field_151078_bh), ItemStack.field_190927_a, new ItemStack((IItemProvider)Items.field_151042_j));
        StatueLootList.addLoot("drowned", new ItemStack((IItemProvider)Items.field_151078_bh), ItemStack.field_190927_a, new ItemStack((IItemProvider)Items.field_151043_k));
        StatueLootList.addLoot("magma_slime", new ItemStack((IItemProvider)Items.field_151064_bs), ItemStack.field_190927_a, ItemStack.field_190927_a);
        StatueLootList.addLoot("mooshroom", ItemStack.field_190927_a, ItemStack.field_190927_a, ItemStack.field_190927_a);
        StatueLootList.addLoot("pig", ItemStack.field_190927_a, ItemStack.field_190927_a, new ItemStack((IItemProvider)Items.field_151147_al));
        StatueLootList.addLoot("rabbit", new ItemStack((IItemProvider)Items.field_179555_bs), new ItemStack((IItemProvider)Items.field_179558_bo), new ItemStack((IItemProvider)Items.field_179556_br));
        StatueLootList.addLoot("sheep_white", new ItemStack((IItemProvider)Blocks.field_196556_aL), new ItemStack((IItemProvider)Items.field_179561_bm), ItemStack.field_190927_a);
        StatueLootList.addLoot("sheep_orange", new ItemStack((IItemProvider)Blocks.field_196557_aM), new ItemStack((IItemProvider)Items.field_179561_bm), ItemStack.field_190927_a);
        StatueLootList.addLoot("sheep_magenta", new ItemStack((IItemProvider)Blocks.field_196558_aN), new ItemStack((IItemProvider)Items.field_179561_bm), ItemStack.field_190927_a);
        StatueLootList.addLoot("sheep_light_blue", new ItemStack((IItemProvider)Blocks.field_196559_aO), new ItemStack((IItemProvider)Items.field_179561_bm), ItemStack.field_190927_a);
        StatueLootList.addLoot("sheep_yellow", new ItemStack((IItemProvider)Blocks.field_196560_aP), new ItemStack((IItemProvider)Items.field_179561_bm), ItemStack.field_190927_a);
        StatueLootList.addLoot("sheep_lime", new ItemStack((IItemProvider)Blocks.field_196561_aQ), new ItemStack((IItemProvider)Items.field_179561_bm), ItemStack.field_190927_a);
        StatueLootList.addLoot("sheep_pink", new ItemStack((IItemProvider)Blocks.field_196562_aR), new ItemStack((IItemProvider)Items.field_179561_bm), ItemStack.field_190927_a);
        StatueLootList.addLoot("sheep_gray", new ItemStack((IItemProvider)Blocks.field_196563_aS), new ItemStack((IItemProvider)Items.field_179561_bm), ItemStack.field_190927_a);
        StatueLootList.addLoot("sheep_light_gray", new ItemStack((IItemProvider)Blocks.field_196564_aT), new ItemStack((IItemProvider)Items.field_179561_bm), ItemStack.field_190927_a);
        StatueLootList.addLoot("sheep_cyan", new ItemStack((IItemProvider)Blocks.field_196565_aU), new ItemStack((IItemProvider)Items.field_179561_bm), ItemStack.field_190927_a);
        StatueLootList.addLoot("sheep_purple", new ItemStack((IItemProvider)Blocks.field_196566_aV), new ItemStack((IItemProvider)Items.field_179561_bm), ItemStack.field_190927_a);
        StatueLootList.addLoot("sheep_blue", new ItemStack((IItemProvider)Blocks.field_196567_aW), new ItemStack((IItemProvider)Items.field_179561_bm), ItemStack.field_190927_a);
        StatueLootList.addLoot("sheep_brown", new ItemStack((IItemProvider)Blocks.field_196568_aX), new ItemStack((IItemProvider)Items.field_179561_bm), ItemStack.field_190927_a);
        StatueLootList.addLoot("sheep_green", new ItemStack((IItemProvider)Blocks.field_196569_aY), new ItemStack((IItemProvider)Items.field_179561_bm), ItemStack.field_190927_a);
        StatueLootList.addLoot("sheep_red", new ItemStack((IItemProvider)Blocks.field_196570_aZ), new ItemStack((IItemProvider)Items.field_179561_bm), ItemStack.field_190927_a);
        StatueLootList.addLoot("sheep_black", new ItemStack((IItemProvider)Blocks.field_196602_ba), new ItemStack((IItemProvider)Items.field_179561_bm), ItemStack.field_190927_a);
        StatueLootList.addLoot("sheep_shaven", ItemStack.field_190927_a, ItemStack.field_190927_a, new ItemStack((IItemProvider)Items.field_179561_bm));
        StatueLootList.addLoot("slime", ItemStack.field_190927_a, new ItemStack((IItemProvider)Items.field_151123_aH), ItemStack.field_190927_a);
        StatueLootList.addLoot("snow_golem", new ItemStack((IItemProvider)Items.field_151126_ay), ItemStack.field_190927_a, new ItemStack((IItemProvider)Blocks.field_150423_aK));
        StatueLootList.addLoot("squid", ItemStack.field_190927_a, new ItemStack((IItemProvider)Items.field_196136_br), ItemStack.field_190927_a);
        StatueLootList.addLoot("villager", ItemStack.field_190927_a, ItemStack.field_190927_a, new ItemStack((IItemProvider)Items.field_151166_bC));
        StatueLootList.addLoot("witch", new ItemStack((IItemProvider)Items.field_151114_aO), new ItemStack((IItemProvider)Items.field_151137_ax), new ItemStack((IItemProvider)Items.field_151069_bo));
        StatueLootList.addLoot("wasteland_pig", new ItemStack((IItemProvider)StatueRegistry.TEA.get()), StatueLootList.getWastelandBlock(), ItemStack.field_190927_a);
        StatueLootList.addLoot("zombie", new ItemStack((IItemProvider)Items.field_151078_bh), ItemStack.field_190927_a, new ItemStack((IItemProvider)Items.field_151042_j));
        StatueLootList.addLoot("pufferfish", ItemStack.field_190927_a, new ItemStack((IItemProvider)Items.field_196089_aZ), ItemStack.field_190927_a);
        StatueLootList.addLoot("spider", new ItemStack((IItemProvider)Items.field_151007_F), new ItemStack((IItemProvider)Items.field_151070_bp), ItemStack.field_190927_a);
        StatueLootList.addLoot("evoker", ItemStack.field_190927_a, ItemStack.field_190927_a, new ItemStack((IItemProvider)Items.field_190929_cY));
        StatueLootList.addLoot("etho", new ItemStack((IItemProvider)StatueRegistry.MARSHMALLOW.get()), ItemStack.field_190927_a, ItemStack.field_190927_a);
        StatueLootList.addLoot("turtle", new ItemStack((IItemProvider)Items.field_221600_aB), ItemStack.field_190927_a, new ItemStack((IItemProvider)Items.field_151054_z));
    }

    public static ItemStack getWastelandBlock() {
        ItemStack wasteland = new ItemStack((IItemProvider)Blocks.field_150354_m).func_200302_a((ITextComponent)new StringTextComponent("Wasteland Block").func_240699_a_(TextFormatting.LIGHT_PURPLE));
        wasteland.func_77966_a(Enchantments.field_190940_C, 1);
        CompoundNBT nbt = wasteland.func_77942_o() ? wasteland.func_77978_p() : new CompoundNBT();
        nbt.func_74768_a("HideFlags", 1);
        wasteland.func_77982_d(nbt);
        return wasteland;
    }

    public static ItemStack getFloodBucket() {
        ItemStack floodBucket = new ItemStack((IItemProvider)Items.field_151131_as);
        floodBucket.func_200302_a((ITextComponent)new StringTextComponent("The Flood").func_240699_a_(TextFormatting.BLUE));
        return floodBucket;
    }

    public static void addLoot(String statue, LootInfo loot) {
        loot_info = new StatueLootInfo(statue, loot);
        if (!lootList.contains(loot_info)) {
            lootList.add(loot_info);
        }
    }

    public static void addLoot(String statue, ItemStack stack1, ItemStack stack2, ItemStack stack3) {
        LootInfo info = new LootInfo(stack1, stack2, stack3);
        StatueLootList.addLoot(statue, info);
    }

    public static void changeLoot(String statue, LootInfo loot) {
        if (!statue.isEmpty()) {
            for (int i = 0; i < lootList.size(); ++i) {
                StatueLootInfo oldLoot = lootList.get(i);
                if (!oldLoot.getStatue().equalsIgnoreCase(statue)) continue;
                lootList.set(i, new StatueLootInfo(oldLoot.getStatue(), loot));
            }
        }
    }

    public static StatueLootInfo getLootInfo(String statueName) {
        StatueLootInfo loot = new StatueLootInfo(statueName, LootInfo.EMPTY);
        for (StatueLootInfo info : lootList) {
            if (!info.getStatue().equalsIgnoreCase(statueName)) continue;
            loot = info;
        }
        return loot;
    }

    public static ArrayList<ItemStack> getStacksForStatue(String statue) {
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        for (StatueLootInfo info : lootList) {
            if (!info.getStatue().equals(statue)) continue;
            stacks.add(0, info.getStack1());
            stacks.add(1, info.getStack2());
            stacks.add(2, info.getStack2());
            if (stacks.get(0) != info.getStack1()) {
                stacks.set(0, info.getStack1());
            }
            if (stacks.get(1) != info.getStack2()) {
                stacks.set(1, info.getStack2());
            }
            if (stacks.get(2) == info.getStack3()) continue;
            stacks.set(2, info.getStack3());
        }
        return stacks;
    }

    public static ArrayList<Block> getBlockForStatue(String statue) {
        ArrayList<Block> blockList = new ArrayList<Block>();
        for (RegistryObject block : StatueRegistry.BLOCKS.getEntries()) {
            String blockName = block.get() != null ? ((Block)block.get()).func_149739_a() : "";
            if (blockName.isEmpty() || !blockName.contains(statue.replace("_", "")) || !blockName.contains("t3") && !blockName.contains("t4") || blockList.contains(block.get())) continue;
            blockList.add((Block)block.get());
        }
        return blockList;
    }
}

