/*
 * Decompiled with CFR 0.152.
 */
package com.shynieke.statues.blocks.statues;

import com.shynieke.statues.blocks.AbstractStatueBase;
import com.shynieke.statues.init.StatueRegistry;
import com.shynieke.statues.recipes.StatueLootList;
import com.shynieke.statues.tiles.StatueTile;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.SoundType;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.passive.ChickenEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.state.Property;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class ChickenStatueBlock
extends AbstractStatueBase {
    private static final VoxelShape SHAPE = Block.func_208617_a((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)4.0, (double)10.0);

    public ChickenStatueBlock(AbstractBlock.Properties builder) {
        super(builder.func_200947_a(SoundType.field_185851_d));
    }

    public void func_180633_a(World worldIn, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        Block block;
        if (this.isDecorative(state) && placer != null && (block = worldIn.func_180495_p(pos.func_177977_b()).func_177230_c()) == Blocks.field_150340_R) {
            BlockPos downPos = pos.func_177977_b();
            worldIn.func_195594_a((IParticleData)ParticleTypes.field_197627_t, (double)downPos.func_177958_n(), (double)downPos.func_177956_o(), (double)downPos.func_177952_p(), 1.0, 0.0, 0.0);
            worldIn.func_175656_a(pos.func_177977_b(), (BlockState)((Block)StatueRegistry.KING_CLUCK_STATUE.get()).func_176223_P().func_206870_a((Property)field_185512_D, (Comparable)placer.func_174811_aO().func_176734_d()));
            worldIn.func_175656_a(pos, Blocks.field_150350_a.func_176223_P());
        }
        super.func_180633_a(worldIn, pos, state, placer, stack);
    }

    public boolean isDecorative(BlockState state) {
        return (Boolean)state.func_177229_b((Property)INTERACTIVE) == false;
    }

    @Override
    public void executeStatueBehavior(StatueTile tile, BlockState state, World worldIn, BlockPos pos, PlayerEntity playerIn, Hand handIn, BlockRayTraceResult result) {
        tile.giveItem(StatueLootList.getLootInfo(this.getLootName()).getLoot(), playerIn);
        tile.summonMob((LivingEntity)new ChickenEntity(EntityType.field_200795_i, worldIn));
    }

    @Override
    public String getLootName() {
        return "chicken";
    }

    @Override
    public EntityType<?> getEntity() {
        return EntityType.field_200795_i;
    }

    @Override
    public SoundEvent getSound(BlockState state) {
        return SoundEvents.field_187660_W;
    }

    @Override
    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return SHAPE;
    }
}

