/*
 * Decompiled with CFR 0.152.
 */
package com.shynieke.statues.tiles;

import com.google.common.collect.Iterables;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.minecraft.MinecraftSessionService;
import com.mojang.authlib.properties.Property;
import com.shynieke.statues.blocks.statues.PlayerStatueBlock;
import com.shynieke.statues.init.StatueRegistry;
import com.shynieke.statues.init.StatueTiles;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.server.management.PlayerProfileCache;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.INameable;
import net.minecraft.util.StringUtils;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class PlayerTile
extends TileEntity
implements INameable,
ITickableTileEntity {
    private static PlayerProfileCache profileCache;
    private static MinecraftSessionService sessionService;
    private GameProfile playerProfile;
    private boolean comparatorApplied = false;
    private boolean OnlineChecking = false;
    private int checkerCooldown = 0;

    public PlayerTile() {
        super(StatueTiles.PLAYER);
    }

    public static void setProfileCache(PlayerProfileCache profileCacheIn) {
        profileCache = profileCacheIn;
    }

    public static void setSessionService(MinecraftSessionService sessionServiceIn) {
        sessionService = sessionServiceIn;
    }

    public void func_230337_a_(BlockState state, CompoundNBT compound) {
        super.func_230337_a_(state, compound);
        if (compound.func_150297_b("PlayerProfile", 10)) {
            this.setPlayerProfile(NBTUtil.func_152459_a((CompoundNBT)compound.func_74775_l("PlayerProfile")));
        }
        this.comparatorApplied = compound.func_74767_n("comparatorApplied");
        this.OnlineChecking = compound.func_74767_n("OnlineChecking");
        this.checkerCooldown = compound.func_74762_e("checkerCooldown");
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        super.func_189515_b(compound);
        if (this.playerProfile != null) {
            CompoundNBT compoundnbt = new CompoundNBT();
            NBTUtil.func_180708_a((CompoundNBT)compoundnbt, (GameProfile)this.playerProfile);
            compound.func_218657_a("PlayerProfile", (INBT)compoundnbt);
        }
        compound.func_74757_a("comparatorApplied", this.comparatorApplied);
        compound.func_74757_a("OnlineChecking", this.OnlineChecking);
        compound.func_74768_a("checkerCooldown", this.checkerCooldown);
        return compound;
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        CompoundNBT compoundNBT = pkt.func_148857_g();
        this.handleUpdateTag(this.func_195044_w(), compoundNBT);
    }

    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.field_174879_c, 4, this.func_189517_E_());
    }

    public CompoundNBT func_189517_E_() {
        return this.func_189515_b(new CompoundNBT());
    }

    public boolean func_145818_k_() {
        return this.playerProfile != null && !this.playerProfile.getName().isEmpty();
    }

    @Nullable
    public GameProfile getPlayerProfile() {
        return this.playerProfile;
    }

    public void setPlayerProfile(@Nullable GameProfile profile) {
        this.playerProfile = profile;
        this.updatePlayerProfile();
    }

    private void updatePlayerProfile() {
        this.playerProfile = PlayerTile.updateGameProfile(this.playerProfile);
        this.func_70296_d();
    }

    @Nullable
    public static GameProfile updateGameProfile(@Nullable GameProfile input) {
        if (input != null && !StringUtils.func_151246_b((String)input.getName())) {
            if (input.isComplete() && input.getProperties().containsKey((Object)"textures")) {
                return input;
            }
            if (profileCache != null && sessionService != null) {
                GameProfile gameprofile = profileCache.func_152655_a(input.getName());
                if (gameprofile == null) {
                    return input;
                }
                Property property = (Property)Iterables.getFirst((Iterable)gameprofile.getProperties().get((Object)"textures"), (Object)null);
                if (property == null) {
                    gameprofile = sessionService.fillProfileProperties(gameprofile, true);
                }
                return gameprofile;
            }
            return input;
        }
        return input;
    }

    public void func_73660_a() {
        BlockState state;
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K && (state = this.func_195044_w()).func_177230_c() == StatueRegistry.PLAYER_STATUE.get() && this.comparatorApplied) {
            if (!this.OnlineChecking) {
                ++this.checkerCooldown;
                this.func_70296_d();
                if (this.checkerCooldown == 0) {
                    this.checkerCooldown = 200;
                }
                if (this.checkerCooldown >= 200) {
                    this.checkerCooldown = 0;
                    this.setOnlineChecking(true);
                }
            } else {
                this.updateOnline();
                this.setOnlineChecking(false);
            }
        }
    }

    public void updateOnline() {
        boolean checkAnswer;
        BlockState state = this.func_195044_w();
        boolean isStateOnline = (Boolean)state.func_177229_b((net.minecraft.state.Property)PlayerStatueBlock.ONLINE);
        boolean bl = checkAnswer = this.field_145850_b.func_217371_b(this.playerProfile.getId()) != null;
        if (isStateOnline != checkAnswer) {
            BlockState newState = (BlockState)state.func_206870_a((net.minecraft.state.Property)PlayerStatueBlock.ONLINE, (Comparable)Boolean.valueOf(checkAnswer));
            this.field_145850_b.func_175656_a(this.func_174877_v(), newState);
            this.field_145850_b.func_184138_a(this.func_174877_v(), state, newState, 3);
        }
    }

    public void setComparatorApplied(boolean comparatorApplied) {
        this.comparatorApplied = comparatorApplied;
        if (!comparatorApplied) {
            BlockState state = this.func_195044_w();
            BlockState newState = (BlockState)state.func_206870_a((net.minecraft.state.Property)PlayerStatueBlock.ONLINE, (Comparable)Boolean.valueOf(false));
            this.field_145850_b.func_175656_a(this.func_174877_v(), newState);
            this.field_145850_b.func_184138_a(this.func_174877_v(), state, newState, 3);
        }
        this.func_70296_d();
    }

    public boolean getComparatorApplied() {
        return this.comparatorApplied;
    }

    public int getCooldown() {
        return this.checkerCooldown;
    }

    public void setOnlineChecking(boolean onlineChecking) {
        this.OnlineChecking = onlineChecking;
        this.func_70296_d();
    }

    public ITextComponent func_200200_C_() {
        return this.func_145818_k_() ? new StringTextComponent(this.playerProfile != null ? this.playerProfile.getName() : "") : new TranslationTextComponent("statue.player");
    }

    public ITextComponent func_200201_e() {
        return null;
    }
}

