/*
 * Decompiled with CFR 0.152.
 */
package aardvark.survivalutils.blocks;

import aardvark.survivalutils.Main;
import aardvark.survivalutils.blocks.tileentities.TileEntityBrickLayingTable;
import aardvark.survivalutils.init.ModBlocks;
import aardvark.survivalutils.init.ModItems;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BrickLayingTable
extends Block {
    public static final PropertyBool BAKED = PropertyBool.func_177716_a((String)"baked");
    public static final PropertyInteger QUANTITY = PropertyInteger.func_177719_a((String)"quantity", (int)0, (int)6);
    public static final AxisAlignedBB BRICK_LAYING_TABLE_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.0625, 1.0);

    public BrickLayingTable(String name, Material material) {
        super(material);
        this.func_149711_c(1.0f);
        this.setHarvestLevel("axe", 0);
        this.func_149752_b(0.8f);
        this.func_149713_g(0);
        this.func_149672_a(SoundType.field_185848_a);
        this.func_149663_c(name);
        this.func_149647_a(Main.svutilstab);
        this.setRegistryName(name);
        ModBlocks.BLOCKS.add(this);
        ModItems.ITEMS.add((Item)new ItemBlock((Block)this).setRegistryName(this.getRegistryName()));
    }

    public int func_180651_a(IBlockState state) {
        return 0;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_190948_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        tooltip.add("Use (RMB) clay on the table to bake it in the sun (but not under direct rain).");
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return BRICK_LAYING_TABLE_AABB;
    }

    public void getDrops(NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        super.getDrops(drops, world, pos, state, fortune);
        int quant = (Integer)state.func_177229_b((IProperty)QUANTITY);
        if (quant > 0) {
            if (((Boolean)state.func_177229_b((IProperty)BAKED)).booleanValue()) {
                drops.add((Object)new ItemStack(Items.field_151118_aC, quant));
            } else {
                drops.add((Object)new ItemStack(Items.field_151119_aD, quant));
            }
        }
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        int quant = (Integer)state.func_177229_b((IProperty)QUANTITY);
        if (((Boolean)state.func_177229_b((IProperty)BAKED)).booleanValue()) {
            if (!worldIn.field_72995_K) {
                EntityItem brick_drop = new EntityItem(worldIn, (double)pos.func_177958_n(), (double)pos.func_177984_a().func_177956_o(), (double)pos.func_177952_p(), new ItemStack(Items.field_151118_aC, quant));
                worldIn.func_72838_d((Entity)brick_drop);
                worldIn.func_175656_a(pos, this.func_176223_P().func_177226_a((IProperty)QUANTITY, (Comparable)Integer.valueOf(0)).func_177226_a((IProperty)BAKED, (Comparable)Boolean.valueOf(false)));
            }
            return true;
        }
        if (playerIn.func_184586_b(hand).func_77973_b() == Items.field_151119_aD && quant < 6) {
            if (!playerIn.func_184812_l_()) {
                playerIn.func_184586_b(hand).func_190918_g(1);
            }
            worldIn.func_175656_a(pos, this.func_176223_P().func_177226_a((IProperty)QUANTITY, (Comparable)Integer.valueOf(quant + 1)).func_177226_a((IProperty)BAKED, (Comparable)Boolean.valueOf(false)));
        }
        return false;
    }

    public IBlockState func_176203_a(int meta) {
        int quant;
        int n = quant = meta < 7 ? meta : meta - 6;
        if (quant == 0) {
            return this.func_176223_P().func_177226_a((IProperty)BAKED, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)QUANTITY, (Comparable)Integer.valueOf(0));
        }
        return this.func_176223_P().func_177226_a((IProperty)BAKED, (Comparable)Boolean.valueOf(meta >= 7)).func_177226_a((IProperty)QUANTITY, (Comparable)Integer.valueOf(quant));
    }

    public int func_176201_c(IBlockState state) {
        int baked_multiplier = (Boolean)state.func_177229_b((IProperty)BAKED) != false ? 1 : 0;
        int quant = (Integer)state.func_177229_b((IProperty)QUANTITY);
        if (quant == 0) {
            return 0;
        }
        return quant + baked_multiplier * 6;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{BAKED, QUANTITY});
    }

    public boolean func_149716_u() {
        return true;
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TileEntityBrickLayingTable();
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }
}

