/*
 * Decompiled with CFR 0.152.
 */
package aardvark.survivalutils.blocks;

import aardvark.survivalutils.Main;
import aardvark.survivalutils.blocks.BlockBase;
import aardvark.survivalutils.init.ModBlocks;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class LavaSpongeWet
extends BlockBase {
    public static final Boolean WET = true;

    public LavaSpongeWet(String name, Material material) {
        super(name, material);
        this.func_149672_a(SoundType.field_185850_c);
        this.func_149711_c(0.6f);
        this.setHarvestLevel("pickaxe", 0);
        this.func_149752_b(2.0f);
        this.func_149713_g(0);
        this.func_149647_a(Main.svutilstab);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_190948_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        tooltip.add("Cool by placing in water");
    }

    public void func_176213_c(World worldIn, BlockPos pos, IBlockState state) {
        this.tryAbsorb(worldIn, pos, state);
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        this.tryAbsorb(worldIn, pos, state);
        super.func_189540_a(state, worldIn, pos, blockIn, fromPos);
    }

    protected void tryAbsorb(World worldIn, BlockPos pos, IBlockState state) {
        if (WET.booleanValue() && this.absorbWater(worldIn, pos)) {
            worldIn.func_180501_a(pos, ModBlocks.LAVA_SPONGE.func_176223_P(), 2);
            worldIn.func_175718_b(2001, pos, Block.func_149682_b((Block)Blocks.field_150355_j));
        }
    }

    private boolean absorbWater(World worldIn, BlockPos pos) {
        LinkedList queue = Lists.newLinkedList();
        ArrayList list = Lists.newArrayList();
        queue.add(new Tuple((Object)pos, (Object)0));
        int i = 0;
        while (!queue.isEmpty()) {
            Tuple tuple = (Tuple)queue.poll();
            BlockPos blockpos = (BlockPos)tuple.func_76341_a();
            int j = (Integer)tuple.func_76340_b();
            for (EnumFacing enumfacing : EnumFacing.values()) {
                BlockPos blockpos1 = blockpos.func_177972_a(enumfacing);
                if (worldIn.func_180495_p(blockpos1).func_185904_a() != Material.field_151586_h) continue;
                worldIn.func_180501_a(blockpos1, Blocks.field_150350_a.func_176223_P(), 2);
                list.add(blockpos1);
                ++i;
                if (j >= 6) continue;
                queue.add(new Tuple((Object)blockpos1, (Object)(j + 1)));
            }
            if (i <= 64) continue;
            break;
        }
        for (BlockPos blockpos2 : list) {
            worldIn.func_175685_c(blockpos2, Blocks.field_150350_a, false);
        }
        return i > 0;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        EnumFacing enumfacing;
        if (WET.booleanValue() && (enumfacing = EnumFacing.func_176741_a((Random)rand)) != EnumFacing.UP && !worldIn.func_180495_p(pos.func_177972_a(enumfacing)).func_185896_q()) {
            double d0 = pos.func_177958_n();
            double d1 = pos.func_177956_o();
            double d2 = pos.func_177952_p();
            if (enumfacing == EnumFacing.DOWN) {
                d1 -= 0.05;
                d0 += rand.nextDouble();
                d2 += rand.nextDouble();
            } else {
                d1 += rand.nextDouble() * 0.8;
                if (enumfacing.func_176740_k() == EnumFacing.Axis.X) {
                    d2 += rand.nextDouble();
                    d0 = enumfacing == EnumFacing.EAST ? (d0 += 1.0) : (d0 += 0.05);
                } else {
                    d0 += rand.nextDouble();
                    d2 = enumfacing == EnumFacing.SOUTH ? (d2 += 1.0) : (d2 += 0.05);
                }
            }
            worldIn.func_175688_a(EnumParticleTypes.DRIP_LAVA, d0, d1, d2, 0.0, 0.0, 0.0, new int[0]);
        }
    }
}

