/*
 * Decompiled with CFR 0.152.
 */
package aardvark.survivalutils.items.tools;

import aardvark.survivalutils.Main;
import aardvark.survivalutils.init.ModItems;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLog;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemAxe;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@Mod.EventBusSubscriber(modid="svutils")
public class ToolAxe
extends ItemAxe {
    static List<BlockPos> streamLogQueue = new ArrayList<BlockPos>();
    static World wd;
    static Set<Block> applicable_logs;

    public ToolAxe(String name, Item.ToolMaterial material) {
        super(material, 8.0f, -3.0f);
        this.func_77655_b(name);
        this.setRegistryName(name);
        if (Main.isStreamAxeEnabled) {
            this.func_77637_a(Main.svutilstab);
        }
        ModItems.ITEMS.add((Item)this);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        tooltip.add("Cut all logs with a single chop (dependent on config!)");
    }

    @SubscribeEvent
    public static void onHarvest(BlockEvent.HarvestDropsEvent event) {
        if (Main.isStreamAxeEnabled && event.getHarvester() != null && event.getHarvester() instanceof EntityPlayer) {
            ItemStack gear;
            BlockPos pos = event.getPos();
            World world = event.getWorld();
            IBlockState state = event.getState();
            ToolAxe.testNonVanillaLog(state);
            if (applicable_logs.contains(state.func_177230_c()) && (gear = event.getHarvester().func_184614_ca()).func_77973_b() == ModItems.STREAM_AXE) {
                ToolAxe.streamLogNextTick(pos, world);
            }
        }
    }

    private static void addNewLog(Block block) {
        applicable_logs.add(block);
    }

    private static void testNonVanillaLog(IBlockState state) {
        Block block = state.func_177230_c();
        if (!applicable_logs.contains(block) && state.func_185904_a() == Material.field_151575_d) {
            String name = block.getRegistryName().toString();
            String item_name = name.substring(name.lastIndexOf(":") + 1);
            if (block instanceof BlockLog || item_name.contains("log") || item_name.contains("bark")) {
                ToolAxe.addNewLog(block);
            }
        }
    }

    private static void streamLogNextTick(BlockPos pos, World world) {
        if (Main.isStreamAxeEnabled) {
            wd = world;
            world.func_175655_b(pos, true);
            for (int x = pos.func_177958_n() - 1; x < pos.func_177958_n() + 2; ++x) {
                for (int y = pos.func_177956_o() - 1; y < pos.func_177956_o() + 2; ++y) {
                    for (int z = pos.func_177952_p() - 1; z < pos.func_177952_p() + 2; ++z) {
                        if (x == 0 || y == 0 || z == 0) continue;
                        BlockPos loop_pos = new BlockPos(x, y, z);
                        IBlockState state = world.func_180495_p(loop_pos);
                        ToolAxe.testNonVanillaLog(state);
                        if (!applicable_logs.contains(state.func_177230_c()) || streamLogQueue.contains(loop_pos)) continue;
                        streamLogQueue.add(loop_pos);
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public static void updateStreamQueue(TickEvent.ServerTickEvent event) {
        if (Main.isStreamAxeEnabled) {
            for (int i = 0; i < 4; ++i) {
                if (streamLogQueue.isEmpty()) {
                    return;
                }
                ToolAxe.streamLogNextTick(streamLogQueue.get(0), wd);
                streamLogQueue.remove(0);
            }
        }
    }

    static {
        applicable_logs = Sets.newHashSet((Object[])new Block[]{Blocks.field_150364_r, Blocks.field_150363_s});
    }
}

