/*
 * Decompiled with CFR 0.152.
 */
package aardvark.survivalutils.items.tools;

import aardvark.survivalutils.Main;
import aardvark.survivalutils.init.ModItems;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockCrops;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemTool;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@Mod.EventBusSubscriber(modid="svutils")
public class ToolSickle
extends ItemTool {
    public static Set<Block> CROPS = Sets.newHashSet((Object[])new Block[]{Blocks.field_150459_bM, Blocks.field_185773_cZ, Blocks.field_150469_bN, Blocks.field_150464_aj});
    public static Set<Block> EFFECTIVE_ON = Sets.newHashSet((Object[])new Block[]{Blocks.field_150350_a});

    public ToolSickle(String name, Item.ToolMaterial material) {
        super(2.5f, -1.0f, material, EFFECTIVE_ON);
        this.func_77655_b(name);
        this.setRegistryName(name);
        if (Main.isSickleEnabled) {
            this.func_77637_a(Main.svutilstab);
        }
        ModItems.ITEMS.add((Item)this);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        tooltip.add("Cut plants, leaves and (fully grown) crops in a large area. Gather bonus seeds from grass.");
    }

    public static double getRandomInteger(double min, double max) {
        double x = (double)((int)(Math.random() * (max - min + 1.0))) + min;
        return (int)x;
    }

    public static void destroyBlockWithDrops(World world, BlockPos pos, List<Block> legal_blocks) {
        BlockCrops crop;
        IBlockState state = world.func_180495_p(pos);
        Block block = state.func_177230_c();
        if (legal_blocks.contains(block)) {
            world.func_175655_b(pos, false);
        } else if (CROPS.contains(block) && (crop = (BlockCrops)block).func_185525_y(state)) {
            List drops = block.getDrops((IBlockAccess)world, pos, state, 0);
            for (ItemStack drop : drops) {
                Block.func_180635_a((World)world, (BlockPos)pos, (ItemStack)drop);
            }
            world.func_175698_g(pos);
        }
    }

    @SubscribeEvent
    public static void onLeafBreak(BlockEvent.BreakEvent event) {
        if (event.getPlayer() != null) {
            EntityPlayer player = event.getPlayer();
            BlockPos pos = event.getPos();
            World world = event.getWorld();
            if (player.func_184614_ca().func_77973_b() == ModItems.SICKLE && world.func_180495_p(pos).func_185904_a() == Material.field_151584_j) {
                BlockPos newpos = pos;
                for (int x = pos.func_177958_n() - 1; x < pos.func_177958_n() + 2; ++x) {
                    for (int y = pos.func_177956_o() - 1; y < pos.func_177956_o() + 2; ++y) {
                        for (int z = pos.func_177952_p() - 1; z < pos.func_177952_p() + 2; ++z) {
                            newpos = new BlockPos(x, y, z);
                            if (world.func_180495_p(newpos).func_185904_a() != Material.field_151584_j) continue;
                            world.func_175655_b(newpos, true);
                            player.func_184614_ca().func_77972_a(1, (EntityLivingBase)player);
                        }
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public static void onHarvest(BlockEvent.HarvestDropsEvent event) {
        if (event.getHarvester() != null) {
            EntityPlayer plyr = event.getHarvester();
            List normalDrops = event.getDrops();
            plyr.func_184614_ca().func_77972_a(1, (EntityLivingBase)plyr);
            if (normalDrops != null && Blocks.field_150329_H == event.getState().func_177230_c()) {
                ItemStack newDrop;
                ItemStack gear = event.getHarvester().func_184614_ca();
                Item tool = gear.func_77973_b();
                if (tool == ModItems.SICKLE && ToolSickle.getRandomInteger(1.0, 3.0) == 2.0) {
                    newDrop = new ItemStack(Items.field_151014_N);
                    newDrop.func_190920_e(1);
                    event.getDrops().add(newDrop);
                }
                if (tool == ModItems.SICKLE && ToolSickle.getRandomInteger(1.0, 2.0) == 2.0) {
                    newDrop = new ItemStack(Items.field_151014_N);
                    newDrop.func_190920_e(1);
                    event.getDrops().add(newDrop);
                }
            }
            BlockPos posBase = event.getPos();
            World world = event.getWorld();
            List<Block> legal_blocks = Arrays.asList(Blocks.field_150329_H, Blocks.field_150330_I, Blocks.field_150395_bd);
            if (plyr.func_184614_ca().func_77973_b() == ModItems.SICKLE && !world.field_72995_K) {
                ToolSickle.destroyBlockWithDrops(world, posBase.func_177976_e(), legal_blocks);
                ToolSickle.destroyBlockWithDrops(world, posBase.func_177974_f(), legal_blocks);
                ToolSickle.destroyBlockWithDrops(world, posBase.func_177978_c(), legal_blocks);
                ToolSickle.destroyBlockWithDrops(world, posBase.func_177968_d(), legal_blocks);
                ToolSickle.destroyBlockWithDrops(world, posBase.func_177974_f().func_177978_c(), legal_blocks);
                ToolSickle.destroyBlockWithDrops(world, posBase.func_177974_f().func_177968_d(), legal_blocks);
                ToolSickle.destroyBlockWithDrops(world, posBase.func_177976_e().func_177978_c(), legal_blocks);
                ToolSickle.destroyBlockWithDrops(world, posBase.func_177976_e().func_177968_d(), legal_blocks);
                plyr.func_184614_ca().func_77972_a(1, (EntityLivingBase)plyr);
            }
        }
    }
}

