/*
 * Decompiled with CFR 0.152.
 */
package aardvark.survivalutils.util.handlers;

import aardvark.survivalutils.Main;
import aardvark.survivalutils.blocks.tileentities.TileEntityBrickLayingTable;
import aardvark.survivalutils.init.EnchantmentInit;
import aardvark.survivalutils.init.EntityInit;
import aardvark.survivalutils.init.ModBlocks;
import aardvark.survivalutils.init.ModItems;
import aardvark.survivalutils.init.recipes.ModRecipes;
import net.minecraft.block.Block;
import net.minecraft.block.BlockSlab;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemSlab;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber
public class RegistryHandler {
    @SubscribeEvent
    public static void onItemRegister(RegistryEvent.Register<Item> event) {
        event.getRegistry().registerAll((IForgeRegistryEntry[])ModItems.ITEMS.toArray(new Item[0]));
    }

    @SubscribeEvent
    public static void onBlockRegister(RegistryEvent.Register<Block> event) {
        event.getRegistry().registerAll((IForgeRegistryEntry[])ModBlocks.BLOCKS.toArray(new Block[0]));
    }

    @SubscribeEvent
    public static void onItemBlockRegister(RegistryEvent.Register<Item> event) {
        event.getRegistry().register(new ItemSlab((Block)ModBlocks.RED_BRICK_SLABHALF, (BlockSlab)ModBlocks.RED_BRICK_SLABHALF, (BlockSlab)ModBlocks.RED_BRICK_SLABDOUBLE).setRegistryName(ModBlocks.RED_BRICK_SLABHALF.getRegistryName()));
        event.getRegistry().register(new ItemSlab((Block)ModBlocks.DULL_BRICK_SLABHALF, (BlockSlab)ModBlocks.DULL_BRICK_SLABHALF, (BlockSlab)ModBlocks.DULL_BRICK_SLABDOUBLE).setRegistryName(ModBlocks.DULL_BRICK_SLABHALF.getRegistryName()));
        event.getRegistry().register(new ItemBlock((Block)ModBlocks.RED_BRICK_STAIRS).setRegistryName(ModBlocks.RED_BRICK_STAIRS.getRegistryName()));
        event.getRegistry().register(new ItemBlock((Block)ModBlocks.DULL_BRICK_STAIRS).setRegistryName(ModBlocks.DULL_BRICK_STAIRS.getRegistryName()));
    }

    @SubscribeEvent
    public static void onEnchantRegister(RegistryEvent.Register<Enchantment> event) {
        event.getRegistry().registerAll((IForgeRegistryEntry[])EnchantmentInit.ENCHANTMENTS.toArray(new Enchantment[0]));
    }

    public static void preInitRegistries() {
        EntityInit.registerEntities();
        Main.proxy.init();
    }

    public static void initRegistries() {
        ModRecipes.init();
    }

    public static void postInitRegistries() {
        RegistryHandler.registerTEs();
    }

    private static void registerTEs() {
        GameRegistry.registerTileEntity(TileEntityBrickLayingTable.class, (ResourceLocation)new ResourceLocation("svutils:brick_laying_table"));
    }

    @SubscribeEvent
    public static void onModelRegister(ModelRegistryEvent event) {
        for (Item item : ModItems.ITEMS) {
            Main.proxy.registerItemRenderer(item, 0, "inventory");
        }
        ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)ModBlocks.RED_BRICK_SLABHALF), (int)0, (ModelResourceLocation)new ModelResourceLocation(Item.func_150898_a((Block)ModBlocks.RED_BRICK_SLABHALF).getRegistryName(), "inventory"));
        ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)ModBlocks.DULL_BRICK_SLABHALF), (int)0, (ModelResourceLocation)new ModelResourceLocation(Item.func_150898_a((Block)ModBlocks.DULL_BRICK_SLABHALF).getRegistryName(), "inventory"));
        ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)ModBlocks.RED_BRICK_STAIRS), (int)0, (ModelResourceLocation)new ModelResourceLocation(Item.func_150898_a((Block)ModBlocks.RED_BRICK_STAIRS).getRegistryName(), "inventory"));
        ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)ModBlocks.DULL_BRICK_STAIRS), (int)0, (ModelResourceLocation)new ModelResourceLocation(Item.func_150898_a((Block)ModBlocks.DULL_BRICK_STAIRS).getRegistryName(), "inventory"));
    }
}

