/*
 * Decompiled with CFR 0.152.
 */
package techreborn.compat.jei;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import javax.annotation.Nonnull;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.BlankRecipeWrapper;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;
import techreborn.api.recipe.BaseRecipe;

public abstract class BaseRecipeWrapper<T extends BaseRecipe>
extends BlankRecipeWrapper {
    protected final T baseRecipe;
    @Nonnull
    private final List<List<ItemStack>> inputs;

    public BaseRecipeWrapper(T baseRecipe) {
        this.baseRecipe = baseRecipe;
        this.inputs = new ArrayList<List<ItemStack>>();
        for (ItemStack input : ((BaseRecipe)baseRecipe).getInputs()) {
            if (((BaseRecipe)baseRecipe).useOreDic()) {
                List<ItemStack> oreDictInputs = BaseRecipeWrapper.expandOreDict(input);
                this.inputs.add(oreDictInputs);
                continue;
            }
            this.inputs.add(Collections.singletonList(input));
        }
    }

    private static List<ItemStack> expandOreDict(ItemStack itemStack) {
        int[] oreIds = OreDictionary.getOreIDs((ItemStack)itemStack);
        if (oreIds.length == 0) {
            return Collections.singletonList(itemStack);
        }
        HashSet<ItemStack> itemStackSet = new HashSet<ItemStack>();
        for (int oreId : oreIds) {
            String oreName = OreDictionary.getOreName((int)oreId);
            List ores = OreDictionary.getOres((String)oreName);
            for (ItemStack ore : ores) {
                if (ore.field_77994_a != itemStack.field_77994_a) {
                    ItemStack oreCopy = ore.func_77946_l();
                    oreCopy.field_77994_a = itemStack.field_77994_a;
                    itemStackSet.add(oreCopy);
                    continue;
                }
                itemStackSet.add(ore);
            }
        }
        return new ArrayList<ItemStack>(itemStackSet);
    }

    public void getIngredients(@Nonnull IIngredients ingredients) {
        ingredients.setInputLists(ItemStack.class, this.inputs);
        ingredients.setOutputs(ItemStack.class, ((BaseRecipe)this.baseRecipe).getOutputs());
    }

    @Nonnull
    public List<List<ItemStack>> getInputs() {
        return this.inputs;
    }

    @Nonnull
    public List<ItemStack> getOutputs() {
        return ((BaseRecipe)this.baseRecipe).getOutputs();
    }
}

