/*
 * Decompiled with CFR 0.152.
 */
package techreborn.compat.jei.assemblingMachine;

import javax.annotation.Nonnull;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IDrawableAnimated;
import mezz.jei.api.gui.IDrawableStatic;
import mezz.jei.api.gui.IGuiItemStackGroup;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.BlankRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.util.text.translation.I18n;
import techreborn.client.gui.GuiAssemblingMachine;
import techreborn.compat.jei.RecipeUtil;
import techreborn.compat.jei.assemblingMachine.AssemblingMachineRecipeWrapper;

public class AssemblingMachineRecipeCategory
extends BlankRecipeCategory<AssemblingMachineRecipeWrapper> {
    private static final int[] INPUT_SLOTS = new int[]{0, 1};
    private static final int[] OUTPUT_SLOTS = new int[]{2};
    private final IDrawable background;
    private final IDrawableAnimated electricity;
    private final String title;

    public AssemblingMachineRecipeCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.createDrawable(GuiAssemblingMachine.texture, 46, 16, 91, 54);
        IDrawableStatic electricityDrawable = guiHelper.createDrawable(GuiAssemblingMachine.texture, 176, 0, 14, 14);
        this.electricity = guiHelper.createAnimatedDrawable(electricityDrawable, 300, IDrawableAnimated.StartDirection.TOP, true);
        this.title = I18n.func_74838_a((String)"tile.techreborn.assemblingmachine.name");
    }

    @Nonnull
    public String getUid() {
        return "TechReborn.AssemblingMachine";
    }

    @Nonnull
    public String getTitle() {
        return this.title;
    }

    @Nonnull
    public IDrawable getBackground() {
        return this.background;
    }

    public void drawAnimations(@Nonnull Minecraft minecraft) {
        this.electricity.draw(minecraft, 10, 20);
    }

    public void setRecipe(@Nonnull IRecipeLayout recipeLayout, @Nonnull AssemblingMachineRecipeWrapper recipeWrapper) {
        IGuiItemStackGroup guiItemStacks = recipeLayout.getItemStacks();
        guiItemStacks.init(INPUT_SLOTS[0], true, 0, 0);
        guiItemStacks.init(INPUT_SLOTS[1], true, 18, 0);
        guiItemStacks.init(OUTPUT_SLOTS[0], false, 69, 18);
        RecipeUtil.setRecipeItems(recipeLayout, recipeWrapper, INPUT_SLOTS, OUTPUT_SLOTS, null, null);
    }

    public void setRecipe(@Nonnull IRecipeLayout recipeLayout, @Nonnull AssemblingMachineRecipeWrapper recipeWrapper, @Nonnull IIngredients ingredients) {
        IGuiItemStackGroup guiItemStacks = recipeLayout.getItemStacks();
        guiItemStacks.init(INPUT_SLOTS[0], true, 0, 0);
        guiItemStacks.init(INPUT_SLOTS[1], true, 18, 0);
        guiItemStacks.init(OUTPUT_SLOTS[0], false, 69, 18);
        RecipeUtil.setRecipeItems(recipeLayout, ingredients, INPUT_SLOTS, OUTPUT_SLOTS, null, null);
    }
}

