/*
 * Decompiled with CFR 0.152.
 */
package techreborn.parts.fluidPipes;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ITickable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.property.ExtendedBlockState;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.common.property.Properties;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;
import reborncore.common.misc.Functions;
import reborncore.common.misc.vecmath.Vecs3dCube;
import reborncore.common.util.ChatUtils;
import reborncore.common.util.StringUtils;
import reborncore.common.util.Tank;
import reborncore.common.util.WorldUtils;
import reborncore.mcmultipart.MCMultiPartMod;
import reborncore.mcmultipart.microblock.IMicroblock;
import reborncore.mcmultipart.multipart.IMultipart;
import reborncore.mcmultipart.multipart.IMultipartContainer;
import reborncore.mcmultipart.multipart.INormallyOccludingPart;
import reborncore.mcmultipart.multipart.ISlottedPart;
import reborncore.mcmultipart.multipart.Multipart;
import reborncore.mcmultipart.multipart.MultipartHelper;
import reborncore.mcmultipart.multipart.OcclusionHelper;
import reborncore.mcmultipart.multipart.PartSlot;
import reborncore.mcmultipart.raytrace.PartMOP;
import techreborn.lib.MessageIDs;
import techreborn.parts.TechRebornParts;
import techreborn.parts.fluidPipes.EmptyFluidPipe;
import techreborn.parts.fluidPipes.EnumFluidPipeTypes;
import techreborn.parts.fluidPipes.ExtractingFluidPipe;
import techreborn.parts.fluidPipes.IPartType;
import techreborn.parts.fluidPipes.InsertingFluidPipe;

public abstract class MultipartFluidPipe
extends Multipart
implements INormallyOccludingPart,
ISlottedPart,
ITickable,
IPartType {
    public static final IUnlistedProperty<Boolean> UP = Properties.toUnlisted((IProperty)PropertyBool.func_177716_a((String)"up"));
    public static final IUnlistedProperty<Boolean> DOWN = Properties.toUnlisted((IProperty)PropertyBool.func_177716_a((String)"down"));
    public static final IUnlistedProperty<Boolean> NORTH = Properties.toUnlisted((IProperty)PropertyBool.func_177716_a((String)"north"));
    public static final IUnlistedProperty<Boolean> EAST = Properties.toUnlisted((IProperty)PropertyBool.func_177716_a((String)"east"));
    public static final IUnlistedProperty<Boolean> SOUTH = Properties.toUnlisted((IProperty)PropertyBool.func_177716_a((String)"south"));
    public static final IUnlistedProperty<Boolean> WEST = Properties.toUnlisted((IProperty)PropertyBool.func_177716_a((String)"west"));
    public static final IProperty<EnumFluidPipeTypes> TYPE = PropertyEnum.func_177709_a((String)"type", EnumFluidPipeTypes.class);
    public static final double thickness = 11.0;
    public static int mbt = 20;
    public Vecs3dCube[] boundingBoxes = new Vecs3dCube[14];
    public float center = 0.6f;
    public float offset = 0.1f;
    public Map<EnumFacing, BlockPos> connectedSides;
    Tank tank = new Tank("MultipartFluidPipe", 1000, null);

    public MultipartFluidPipe() {
        this.connectedSides = new HashMap<EnumFacing, BlockPos>();
        this.refreshBounding();
    }

    public static MultipartFluidPipe getPartFromWorld(World world, BlockPos pos, EnumFacing side) {
        ISlottedPart slottedPart;
        if (world == null || pos == null) {
            return null;
        }
        IMultipartContainer container = MultipartHelper.getPartContainer((IBlockAccess)world, (BlockPos)pos);
        if (side != null && container != null && (slottedPart = container.getPartInSlot(PartSlot.getFaceSlot((EnumFacing)side))) instanceof IMicroblock.IFaceMicroblock && !((IMicroblock.IFaceMicroblock)slottedPart).isFaceHollow()) {
            return null;
        }
        if (container == null) {
            return null;
        }
        ISlottedPart part = container.getPartInSlot(PartSlot.CENTER);
        if (part instanceof MultipartFluidPipe) {
            return (MultipartFluidPipe)part;
        }
        return null;
    }

    public void refreshBounding() {
        float centerFirst = this.center - this.offset;
        double w = 0.1875;
        this.boundingBoxes[6] = new Vecs3dCube((double)centerFirst - w, (double)centerFirst - w, (double)centerFirst - w, (double)centerFirst + w, (double)centerFirst + w, (double)centerFirst + w);
        int i = 0;
        for (EnumFacing dir : EnumFacing.field_82609_l) {
            double zMin1;
            double yMax1;
            double yMin1;
            double xMax1;
            double xMin1;
            double d = dir.func_82601_c() < 0 ? 0.0 : (xMin1 = dir.func_82601_c() == 0 ? (double)centerFirst - w : (double)centerFirst + w);
            double d2 = dir.func_82601_c() > 0 ? 1.0 : (xMax1 = dir.func_82601_c() == 0 ? (double)centerFirst + w : (double)centerFirst - w);
            double d3 = dir.func_96559_d() < 0 ? 0.0 : (yMin1 = dir.func_96559_d() == 0 ? (double)centerFirst - w : (double)centerFirst + w);
            double d4 = dir.func_96559_d() > 0 ? 1.0 : (yMax1 = dir.func_96559_d() == 0 ? (double)centerFirst + w : (double)centerFirst - w);
            double d5 = dir.func_82599_e() < 0 ? 0.0 : (zMin1 = dir.func_82599_e() == 0 ? (double)centerFirst - w : (double)centerFirst + w);
            double zMax1 = dir.func_82599_e() > 0 ? 1.0 : (dir.func_82599_e() == 0 ? (double)centerFirst + w : (double)centerFirst - w);
            this.boundingBoxes[i] = new Vecs3dCube(xMin1, yMin1, zMin1, xMax1, yMax1, zMax1);
            ++i;
        }
    }

    public void addCollisionBoxes(AxisAlignedBB mask, List<AxisAlignedBB> list, Entity collidingEntity) {
        for (EnumFacing dir : EnumFacing.field_82609_l) {
            if (!this.connectedSides.containsKey(dir) || !mask.func_72326_a(this.boundingBoxes[Functions.getIntDirFromDirection((EnumFacing)dir)].toAABB())) continue;
            list.add(this.boundingBoxes[Functions.getIntDirFromDirection((EnumFacing)dir)].toAABB());
        }
        if (mask.func_72326_a(this.boundingBoxes[6].toAABB())) {
            list.add(this.boundingBoxes[6].toAABB());
        }
        super.addCollisionBoxes(mask, list, collidingEntity);
    }

    public void addSelectionBoxes(List<AxisAlignedBB> list) {
        for (EnumFacing dir : EnumFacing.field_82609_l) {
            if (!this.connectedSides.containsKey(dir)) continue;
            list.add(this.boundingBoxes[Functions.getIntDirFromDirection((EnumFacing)dir)].toAABB());
        }
        list.add(this.boundingBoxes[6].toAABB());
        super.addSelectionBoxes(list);
    }

    public void onRemoved() {
        super.onRemoved();
        for (EnumFacing dir : EnumFacing.field_82609_l) {
            MultipartFluidPipe multipart = MultipartFluidPipe.getPartFromWorld(this.getWorld(), this.getPos().func_177972_a(dir), dir);
            if (multipart == null) continue;
            multipart.nearByChange();
        }
    }

    public void addOcclusionBoxes(List<AxisAlignedBB> list) {
        for (EnumFacing dir : EnumFacing.field_82609_l) {
            if (!this.connectedSides.containsKey(dir)) continue;
            list.add(this.boundingBoxes[Functions.getIntDirFromDirection((EnumFacing)dir)].toAABB());
        }
        list.add(this.boundingBoxes[6].toAABB());
    }

    public void onNeighborBlockChange(Block block) {
        super.onNeighborBlockChange(block);
        this.nearByChange();
    }

    public void nearByChange() {
        this.checkConnectedSides();
        for (EnumFacing direction : EnumFacing.field_82609_l) {
            BlockPos blockPos = this.getPos().func_177972_a(direction);
            WorldUtils.updateBlock((World)this.getWorld(), (BlockPos)blockPos);
            MultipartFluidPipe part = MultipartFluidPipe.getPartFromWorld(this.getWorld(), blockPos, direction);
            if (part == null) continue;
            part.checkConnectedSides();
        }
    }

    public void onAdded() {
        this.nearByChange();
    }

    public boolean shouldConnectTo(EnumFacing dir) {
        TileEntity tile;
        MultipartFluidPipe multipartFluidPipe;
        return dir != null && (this.internalShouldConnectTo(dir) ? (multipartFluidPipe = MultipartFluidPipe.getPartFromWorld(this.getWorld(), this.getPos().func_177972_a(dir), dir)) != null && multipartFluidPipe.internalShouldConnectTo(dir.func_176734_d()) : (tile = this.getNeighbourTile(dir)) instanceof IFluidHandler && (this.getPipeType() == EnumFluidPipeTypes.EXTRACT || this.getPipeType() == EnumFluidPipeTypes.INSERT));
    }

    public boolean internalShouldConnectTo(EnumFacing dir) {
        ISlottedPart part = this.getContainer().getPartInSlot(PartSlot.getFaceSlot((EnumFacing)dir));
        if (part instanceof IMicroblock.IFaceMicroblock && !((IMicroblock.IFaceMicroblock)part).isFaceHollow()) {
            return false;
        }
        if (!OcclusionHelper.occlusionTest((Iterable)this.getContainer().getParts(), p -> p == this, (AxisAlignedBB[])new AxisAlignedBB[]{this.boundingBoxes[Functions.getIntDirFromDirection((EnumFacing)dir)].toAABB()})) {
            return false;
        }
        MultipartFluidPipe multipartFluidPipe = MultipartFluidPipe.getPartFromWorld(this.getWorld(), this.getPos().func_177972_a(dir), dir.func_176734_d());
        return multipartFluidPipe != null;
    }

    public TileEntity getNeighbourTile(EnumFacing side) {
        return side != null ? this.getWorld().func_175625_s(this.getPos().func_177972_a(side)) : null;
    }

    public void checkConnectedSides() {
        this.refreshBounding();
        this.connectedSides = new HashMap<EnumFacing, BlockPos>();
        for (EnumFacing dir : EnumFacing.values()) {
            int d = Functions.getIntDirFromDirection((EnumFacing)dir);
            if (this.getWorld() == null) {
                return;
            }
            TileEntity te = this.getNeighbourTile(dir);
            if (!this.shouldConnectTo(dir)) continue;
            this.connectedSides.put(dir, te.func_174877_v());
        }
    }

    public EnumSet<PartSlot> getSlotMask() {
        return EnumSet.of(PartSlot.CENTER);
    }

    public IBlockState getExtendedState(IBlockState state) {
        IExtendedBlockState extendedBlockState = (IExtendedBlockState)state;
        return extendedBlockState.withProperty(DOWN, (Object)this.shouldConnectTo(EnumFacing.DOWN)).withProperty(UP, (Object)this.shouldConnectTo(EnumFacing.UP)).withProperty(NORTH, (Object)this.shouldConnectTo(EnumFacing.NORTH)).withProperty(SOUTH, (Object)this.shouldConnectTo(EnumFacing.SOUTH)).withProperty(WEST, (Object)this.shouldConnectTo(EnumFacing.WEST)).withProperty(EAST, (Object)this.shouldConnectTo(EnumFacing.EAST)).func_177226_a(TYPE, (Comparable)((Object)this.getPipeType()));
    }

    public BlockStateContainer createBlockState() {
        return new ExtendedBlockState((Block)MCMultiPartMod.multipart, new IProperty[]{TYPE}, new IUnlistedProperty[]{DOWN, UP, NORTH, SOUTH, WEST, EAST});
    }

    public float getHardness(PartMOP hit) {
        return 0.5f;
    }

    public Material getMaterial() {
        return Material.field_151580_n;
    }

    public List<ItemStack> getDrops() {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        list.add(new ItemStack(TechRebornParts.fluidPipe, 1, 0));
        return list;
    }

    public ResourceLocation getModelPath() {
        return new ResourceLocation("techreborn:fluidpipe");
    }

    public boolean canRenderInLayer(BlockRenderLayer layer) {
        return layer == BlockRenderLayer.CUTOUT;
    }

    public void func_73660_a() {
        if (!this.getWorld().field_72995_K) {
            for (EnumFacing dir : EnumFacing.field_82609_l) {
                FluidTankInfo[] fluidTankInfos;
                FluidStack fluidStack;
                FluidTankInfo info;
                TileEntity tileEntity;
                MultipartFluidPipe fluidPipe = MultipartFluidPipe.getPartFromWorld(this.getWorld(), this.getPos().func_177972_a(dir), dir);
                if (fluidPipe != null && !this.tank.isEmpty() && (fluidPipe.tank.isEmpty() || fluidPipe.tank.getFluid().getFluid() == this.tank.getFluid().getFluid()) && fluidPipe.tank.getFluidAmount() < this.tank.getFluidAmount()) {
                    int freeSpace = fluidPipe.tank.getCapacity();
                    if (!fluidPipe.tank.isEmpty()) {
                        freeSpace = fluidPipe.tank.getCapacity() - fluidPipe.tank.getFluidAmount();
                    }
                    int difference = this.tank.getFluidAmount() - freeSpace;
                    int amountToChange = difference / 2;
                    fluidPipe.tank.setFluid(this.tank.getFluid());
                    fluidPipe.tank.setFluidAmount(fluidPipe.tank.getFluidAmount() + amountToChange);
                    this.tank.setFluidAmount(this.tank.getFluidAmount() - amountToChange);
                }
                if ((tileEntity = this.getNeighbourTile(dir)) == null || !(tileEntity instanceof IFluidHandler)) continue;
                IFluidHandler handler = (IFluidHandler)tileEntity;
                if (this.getPipeType() == EnumFluidPipeTypes.EXTRACT) {
                    FluidTankInfo[] fluidTankInfos2;
                    if (this.tank.isFull() || (fluidTankInfos2 = handler.getTankInfo(dir.func_176734_d())).length == 0 || !((info = fluidTankInfos2[0]) != null & info.fluid != null) || !this.tank.isEmpty() && info.fluid.getFluid() != this.tank.getFluid().getFluid() || !handler.canDrain(dir.func_176734_d(), info.fluid.getFluid())) continue;
                    int amountToMove = Math.min(mbt, this.tank.getCapacity() - this.tank.getFluidAmount());
                    int fluidAmount = this.tank.getFluidAmount();
                    fluidStack = handler.drain(dir.func_176734_d(), amountToMove, true);
                    this.tank.fill(fluidStack, true);
                    this.tank.setFluid(fluidStack);
                    this.tank.setFluidAmount(fluidAmount + amountToMove);
                    continue;
                }
                if (this.getPipeType() != EnumFluidPipeTypes.INSERT || this.tank.isEmpty() || (fluidTankInfos = handler.getTankInfo(dir.func_176734_d())).length == 0) continue;
                info = fluidTankInfos[0];
                if (info.fluid != null && info.fluid.getFluid() != null && (info.fluid.getFluid() != this.tank.getFluid().getFluid() || !handler.canFill(dir.func_176734_d(), this.tank.getFluid().getFluid()))) continue;
                int infoSpace = info.capacity;
                if (info.fluid != null) {
                    infoSpace = info.capacity - info.fluid.amount;
                }
                int amountToMove = Math.min(mbt, infoSpace);
                fluidStack = this.tank.drain(amountToMove, true);
                handler.fill(dir.func_176734_d(), fluidStack, true);
            }
        }
    }

    public boolean onActivated(EntityPlayer player, EnumHand hand, ItemStack heldItem, PartMOP hit) {
        System.out.println(this.getWorld().field_72995_K);
        if (!this.getWorld().field_72995_K) {
            if (this.getPipeType() == EnumFluidPipeTypes.EMPTY) {
                this.setPartType(EnumFluidPipeTypes.EXTRACT, this);
            } else if (this.getPipeType() == EnumFluidPipeTypes.EXTRACT) {
                this.setPartType(EnumFluidPipeTypes.INSERT, this);
            } else if (this.getPipeType() == EnumFluidPipeTypes.INSERT) {
                this.setPartType(EnumFluidPipeTypes.EMPTY, this);
            }
        }
        return true;
    }

    public void setPartType(EnumFluidPipeTypes type, MultipartFluidPipe pipe) {
        World world = pipe.getWorld();
        BlockPos pos = pipe.getPos();
        Tank tank = pipe.tank;
        pipe.getContainer().removePart((IMultipart)pipe);
        MultipartFluidPipe newPipe = null;
        switch (type) {
            case EMPTY: {
                newPipe = new EmptyFluidPipe();
                break;
            }
            case INSERT: {
                newPipe = new InsertingFluidPipe();
                break;
            }
            case EXTRACT: {
                newPipe = new ExtractingFluidPipe();
            }
        }
        newPipe.tank = tank;
        MultipartHelper.addPart((World)world, (BlockPos)pos, (IMultipart)newPipe);
        ChatUtils.sendNoSpamMessages((int)MessageIDs.fluidPipeID, (ITextComponent)new TextComponentString(TextFormatting.GRAY + I18n.func_74838_a((String)"techreborn.message.setTo") + " " + type.colour + StringUtils.toFirstCapital((String)type.func_176610_l())));
    }

    public NBTTagCompound writeToNBT(NBTTagCompound tag) {
        super.writeToNBT(tag);
        this.tank.writeToNBT(tag);
        return tag;
    }

    public void readFromNBT(NBTTagCompound tag) {
        super.readFromNBT(tag);
        this.tank.readFromNBT(tag);
    }
}

