/*
 * Decompiled with CFR 0.152.
 */
package techreborn.tiles;

import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.item.ItemTool;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fml.common.registry.GameRegistry;
import reborncore.api.recipe.IBaseRecipeType;
import reborncore.api.recipe.RecipeHandler;
import reborncore.api.tile.IInventoryProvider;
import reborncore.common.IWrenchable;
import reborncore.common.tile.TileLegacyMachineBase;
import reborncore.common.util.Inventory;
import reborncore.common.util.ItemUtils;
import techreborn.api.Reference;
import techreborn.init.ModBlocks;

public class TileAlloyFurnace
extends TileLegacyMachineBase
implements IWrenchable,
IInventoryProvider {
    public int tickTime;
    public Inventory inventory = new Inventory(4, "TileAlloyFurnace", 64, (TileEntity)this);
    public int burnTime;
    public int currentItemBurnTime;
    public int cookTime;
    int input1 = 0;
    int input2 = 1;
    int output = 2;
    int fuel = 3;

    public static int getItemBurnTime(ItemStack stack) {
        if (stack == null) {
            return 0;
        }
        Item item = stack.func_77973_b();
        if (item instanceof ItemBlock && Block.func_149634_a((Item)item) != Blocks.field_150350_a) {
            Block block = Block.func_149634_a((Item)item);
            if (block == Blocks.field_150376_bx) {
                return 150;
            }
            if (block.func_149688_o(block.func_176223_P()) == Material.field_151575_d) {
                return 300;
            }
            if (block == Blocks.field_150402_ci) {
                return 16000;
            }
        }
        if (item instanceof ItemTool && ((ItemTool)item).func_77861_e().equals("WOOD")) {
            return 200;
        }
        if (item instanceof ItemSword && ((ItemSword)item).func_150932_j().equals("WOOD")) {
            return 200;
        }
        if (item == Items.field_151055_y) {
            return 100;
        }
        if (item == Items.field_151044_h) {
            return 1600;
        }
        if (item == Items.field_151129_at) {
            return 20000;
        }
        if (item == Item.func_150898_a((Block)Blocks.field_150345_g)) {
            return 100;
        }
        if (item == Items.field_151072_bj) {
            return 2400;
        }
        return GameRegistry.getFuelValue((ItemStack)stack);
    }

    public void updateEntity() {
        super.updateEntity();
        boolean flag = this.burnTime > 0;
        boolean flag1 = false;
        if (this.burnTime > 0) {
            --this.burnTime;
        }
        if (!this.field_145850_b.field_72995_K) {
            if (this.burnTime != 0 || this.func_70301_a(this.input1) != null && this.func_70301_a(this.fuel) != null) {
                if (this.burnTime == 0 && this.canSmelt()) {
                    this.currentItemBurnTime = this.burnTime = TileAlloyFurnace.getItemBurnTime(this.func_70301_a(this.fuel));
                    if (this.burnTime > 0) {
                        flag1 = true;
                        if (this.func_70301_a(this.fuel) != null) {
                            this.func_70298_a(this.fuel, 1);
                        }
                    }
                }
                if (this.isBurning() && this.canSmelt()) {
                    ++this.cookTime;
                    if (this.cookTime == 200) {
                        this.cookTime = 0;
                        this.smeltItem();
                        flag1 = true;
                    }
                } else {
                    this.cookTime = 0;
                }
            }
            if (flag != this.burnTime > 0) {
                flag1 = true;
            }
        }
        if (flag1) {
            this.func_70296_d();
        }
    }

    public boolean hasAllInputs(IBaseRecipeType recipeType) {
        if (recipeType == null) {
            return false;
        }
        for (ItemStack input : recipeType.getInputs()) {
            Boolean hasItem = false;
            for (int inputslot = 0; inputslot < 2; ++inputslot) {
                if (!ItemUtils.isItemEqual((ItemStack)input, (ItemStack)this.inventory.func_70301_a(inputslot), (boolean)true, (boolean)true, (boolean)recipeType.useOreDic()) || this.inventory.func_70301_a((int)inputslot).field_77994_a < input.field_77994_a) continue;
                hasItem = true;
            }
            if (hasItem.booleanValue()) continue;
            return false;
        }
        return true;
    }

    private boolean canSmelt() {
        if (this.func_70301_a(this.input1) == null || this.func_70301_a(this.input2) == null) {
            return false;
        }
        ItemStack itemstack = null;
        for (IBaseRecipeType recipeType : RecipeHandler.getRecipeClassFromName((String)Reference.alloySmelteRecipe)) {
            if (!this.hasAllInputs(recipeType)) continue;
            itemstack = recipeType.getOutput(0);
            break;
        }
        if (itemstack == null) {
            return false;
        }
        if (this.func_70301_a(this.output) == null) {
            return true;
        }
        if (!this.func_70301_a(this.output).func_77969_a(itemstack)) {
            return false;
        }
        int result = this.func_70301_a((int)this.output).field_77994_a + itemstack.field_77994_a;
        return result <= this.func_70297_j_() && result <= this.func_70301_a(this.output).func_77976_d();
    }

    public void smeltItem() {
        if (this.canSmelt()) {
            ItemStack itemstack = null;
            for (IBaseRecipeType recipeType : RecipeHandler.getRecipeClassFromName((String)Reference.alloySmelteRecipe)) {
                if (this.hasAllInputs(recipeType)) {
                    itemstack = recipeType.getOutput(0);
                    break;
                }
                if (itemstack == null) continue;
                break;
            }
            if (this.func_70301_a(this.output) == null) {
                this.func_70299_a(this.output, itemstack.func_77946_l());
            } else if (this.func_70301_a(this.output).func_77973_b() == itemstack.func_77973_b()) {
                this.func_70298_a(this.output, -itemstack.field_77994_a);
            }
            for (IBaseRecipeType recipeType : RecipeHandler.getRecipeClassFromName((String)Reference.alloySmelteRecipe)) {
                boolean hasAllRecipes = true;
                if (!this.hasAllInputs(recipeType)) {
                    hasAllRecipes = false;
                }
                if (!hasAllRecipes) continue;
                block2: for (ItemStack input : recipeType.getInputs()) {
                    for (int inputSlot = 0; inputSlot < 2; ++inputSlot) {
                        if (!ItemUtils.isItemEqual((ItemStack)input, (ItemStack)this.inventory.func_70301_a(inputSlot), (boolean)true, (boolean)true, (boolean)recipeType.useOreDic())) continue;
                        this.inventory.func_70298_a(inputSlot, input.field_77994_a);
                        continue block2;
                    }
                }
            }
        }
    }

    public boolean isBurning() {
        return this.burnTime > 0;
    }

    public int getBurnTimeRemainingScaled(int scale) {
        if (this.currentItemBurnTime == 0) {
            this.currentItemBurnTime = 200;
        }
        return this.burnTime * scale / this.currentItemBurnTime;
    }

    public int getCookProgressScaled(int scale) {
        return this.cookTime * scale / 200;
    }

    public boolean wrenchCanSetFacing(EntityPlayer entityPlayer, EnumFacing side) {
        return false;
    }

    public EnumFacing getFacing() {
        return this.getFacingEnum();
    }

    public boolean wrenchCanRemove(EntityPlayer entityPlayer) {
        return entityPlayer.func_70093_af();
    }

    public float getWrenchDropRate() {
        return 1.0f;
    }

    public ItemStack getWrenchDrop(EntityPlayer entityPlayer) {
        return new ItemStack(ModBlocks.AlloyFurnace, 1);
    }

    public boolean isComplete() {
        return false;
    }

    public Inventory getInventory() {
        return this.inventory;
    }

    public int[] func_180463_a(EnumFacing side) {
        return new int[]{0, 1, 2};
    }

    public boolean func_180462_a(int index, ItemStack itemStackIn, EnumFacing direction) {
        return index == 0 || index == 1;
    }

    public boolean func_180461_b(int index, ItemStack stack, EnumFacing direction) {
        return index == 2;
    }
}

