/*
 * Decompiled with CFR 0.152.
 */
package techreborn.tiles;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import reborncore.api.power.EnumPowerTier;
import reborncore.api.recipe.IRecipeCrafterProvider;
import reborncore.api.tile.IInventoryProvider;
import reborncore.common.IWrenchable;
import reborncore.common.powerSystem.TilePowerAcceptor;
import reborncore.common.recipes.RecipeCrafter;
import reborncore.common.util.Inventory;
import techreborn.api.Reference;
import techreborn.init.ModBlocks;

public class TileAssemblingMachine
extends TilePowerAcceptor
implements IWrenchable,
ISidedInventory,
IInventoryProvider,
IRecipeCrafterProvider {
    public int tickTime;
    public Inventory inventory = new Inventory(8, "TileAssemblingMachine", 64, (TileEntity)this);
    public RecipeCrafter crafter;

    public TileAssemblingMachine() {
        super(2);
        int[] inputs = new int[]{0, 1};
        int[] outputs = new int[]{2};
        this.crafter = new RecipeCrafter(Reference.assemblingMachineRecipe, (TileEntity)this, 2, 2, this.inventory, inputs, outputs);
    }

    public void updateEntity() {
        super.updateEntity();
        this.charge(3);
    }

    public boolean wrenchCanSetFacing(EntityPlayer entityPlayer, EnumFacing side) {
        return false;
    }

    public EnumFacing getFacing() {
        return this.getFacingEnum();
    }

    public boolean wrenchCanRemove(EntityPlayer entityPlayer) {
        return entityPlayer.func_70093_af();
    }

    public float getWrenchDropRate() {
        return 1.0f;
    }

    public ItemStack getWrenchDrop(EntityPlayer entityPlayer) {
        return new ItemStack(ModBlocks.AssemblyMachine, 1);
    }

    public boolean isComplete() {
        return false;
    }

    public int getProgressScaled(int scale) {
        if (this.crafter.currentTickTime != 0) {
            return this.crafter.currentTickTime * scale / this.crafter.currentNeededTicks;
        }
        return 0;
    }

    public double getMaxPower() {
        return 10000.0;
    }

    public boolean canAcceptEnergy(EnumFacing direction) {
        return true;
    }

    public boolean canProvideEnergy(EnumFacing direction) {
        return false;
    }

    public double getMaxOutput() {
        return 0.0;
    }

    public double getMaxInput() {
        return 128.0;
    }

    public EnumPowerTier getTier() {
        return EnumPowerTier.LOW;
    }

    public Inventory getInventory() {
        return this.inventory;
    }

    public RecipeCrafter getRecipeCrafter() {
        return this.crafter;
    }

    public int[] func_180463_a(EnumFacing side) {
        return new int[]{0, 1, 2};
    }

    public boolean func_180462_a(int index, ItemStack itemStackIn, EnumFacing direction) {
        return index == 0 || index == 1;
    }

    public boolean func_180461_b(int index, ItemStack stack, EnumFacing direction) {
        return index == 2;
    }
}

