/*
 * Decompiled with CFR 0.152.
 */
package techreborn.tiles;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import reborncore.api.power.EnumPowerTier;
import reborncore.api.tile.IInventoryProvider;
import reborncore.common.IWrenchable;
import reborncore.common.powerSystem.TilePowerAcceptor;
import reborncore.common.util.Inventory;
import reborncore.common.util.ItemUtils;
import techreborn.init.ModBlocks;
import techreborn.init.ModItems;
import techreborn.items.ItemParts;

public class TileMatterFabricator
extends TilePowerAcceptor
implements IWrenchable,
IInventoryProvider {
    public static int fabricationRate = 10000;
    public int tickTime;
    public Inventory inventory = new Inventory(7, "TileMatterFabricator", 64, (TileEntity)this);
    public int progresstime = 0;
    private int amplifier = 0;

    public TileMatterFabricator() {
        super(6);
    }

    public boolean wrenchCanSetFacing(EntityPlayer entityPlayer, EnumFacing side) {
        return false;
    }

    public EnumFacing getFacing() {
        return this.getFacingEnum();
    }

    public boolean wrenchCanRemove(EntityPlayer entityPlayer) {
        return entityPlayer.func_70093_af();
    }

    public float getWrenchDropRate() {
        return 1.0f;
    }

    public ItemStack getWrenchDrop(EntityPlayer entityPlayer) {
        return new ItemStack(ModBlocks.MatterFabricator, 1);
    }

    public boolean isComplete() {
        return false;
    }

    public int maxProgresstime() {
        return fabricationRate;
    }

    public void updateEntity() {
        super.updateEntity();
        if (!this.field_145850_b.field_72995_K) {
            for (int i = 0; i < 6; ++i) {
                ItemStack stack = this.inventory.func_70301_a(i);
                if (this.amplifier >= 10000 || stack == null) continue;
                int amp = (int)((long)(this.getValue(stack) / 32));
                if (!ItemUtils.isItemEqual((ItemStack)stack, (ItemStack)this.inventory.func_70301_a(i), (boolean)true, (boolean)true) || !this.canUseEnergy(1.0)) continue;
                this.useEnergy(1.0);
                this.amplifier += amp;
                this.inventory.func_70298_a(i, 1);
            }
            if (this.amplifier > 0) {
                if ((double)this.amplifier > this.getEnergy()) {
                    this.progresstime = (int)((double)this.progresstime + this.getEnergy());
                    this.amplifier = (int)((double)this.amplifier - this.getEnergy());
                    this.decreaseStoredEnergy(this.getEnergy(), true);
                } else {
                    this.progresstime += this.amplifier;
                    this.decreaseStoredEnergy(this.amplifier, true);
                    this.amplifier = 0;
                }
            }
            if (this.progresstime > this.maxProgresstime() && this.spaceForOutput()) {
                this.progresstime -= this.maxProgresstime();
                this.addOutputProducts();
            }
        }
    }

    private boolean spaceForOutput() {
        return this.inventory.func_70301_a(6) == null || ItemUtils.isItemEqual((ItemStack)this.inventory.func_70301_a(6), (ItemStack)new ItemStack(ModItems.uuMatter), (boolean)true, (boolean)true) && this.inventory.func_70301_a((int)6).field_77994_a < 64;
    }

    private void addOutputProducts() {
        if (this.inventory.func_70301_a(6) == null) {
            this.inventory.func_70299_a(6, new ItemStack(ModItems.uuMatter));
        } else if (ItemUtils.isItemEqual((ItemStack)this.inventory.func_70301_a(6), (ItemStack)new ItemStack(ModItems.uuMatter), (boolean)true, (boolean)true)) {
            this.inventory.func_70301_a((int)6).field_77994_a = Math.min(64, 1 + this.inventory.func_70301_a((int)6).field_77994_a);
        }
    }

    public boolean decreaseStoredEnergy(double aEnergy, boolean aIgnoreTooLessEnergy) {
        if (this.getEnergy() - aEnergy < 0.0 && !aIgnoreTooLessEnergy) {
            return false;
        }
        this.setEnergy(this.getEnergy() - aEnergy);
        if (this.getEnergy() < 0.0) {
            this.setEnergy(0.0);
            return false;
        }
        return true;
    }

    public int getValue(ItemStack itemStack) {
        if (itemStack.func_77973_b() == ModItems.parts && itemStack.func_77952_i() == ItemParts.getPartByName("scrap").func_77952_i()) {
            return 5000;
        }
        if (itemStack.func_77973_b() == ModItems.scrapBox) {
            return 45000;
        }
        return 0;
    }

    public double getMaxPower() {
        return 1.0E8;
    }

    public boolean canAcceptEnergy(EnumFacing direction) {
        return true;
    }

    public boolean canProvideEnergy(EnumFacing direction) {
        return false;
    }

    public double getMaxOutput() {
        return 0.0;
    }

    public double getMaxInput() {
        return 4096.0;
    }

    public EnumPowerTier getTier() {
        return EnumPowerTier.EXTREME;
    }

    public Inventory getInventory() {
        return this.inventory;
    }
}

