/*
 * Decompiled with CFR 0.152.
 */
package techreborn.tiles.generator;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;
import reborncore.api.power.EnumPowerTier;
import reborncore.api.tile.IInventoryProvider;
import reborncore.common.IWrenchable;
import reborncore.common.powerSystem.TilePowerAcceptor;
import reborncore.common.util.FluidUtils;
import reborncore.common.util.Inventory;
import reborncore.common.util.Tank;
import techreborn.config.ConfigTechReborn;
import techreborn.init.ModBlocks;

public class TileSemifluidGenerator
extends TilePowerAcceptor
implements IWrenchable,
IFluidHandler,
IInventoryProvider {
    public static final int euTick = 8;
    public Tank tank = new Tank("TileSemifluidGenerator", 10000, (TileEntity)this);
    public Inventory inventory = new Inventory(3, "TileSemifluidGenerator", 64, (TileEntity)this);
    Map<String, Integer> fluids = new HashMap<String, Integer>();
    double pendingWithdraw = 0.0;

    public TileSemifluidGenerator() {
        super(ConfigTechReborn.ThermalGeneratorTier);
        this.fluids.put("creosote", 3000);
        this.fluids.put("biomass", 8000);
        this.fluids.put("oil", 64000);
        this.fluids.put("fluidsodium", 30000);
        this.fluids.put("fluidlithium", 60000);
        this.fluids.put("biofuel", 32000);
        this.fluids.put("bioethanol", 32000);
        this.fluids.put("fuel", 128000);
    }

    public boolean wrenchCanSetFacing(EntityPlayer entityPlayer, EnumFacing side) {
        return false;
    }

    public EnumFacing getFacing() {
        return this.getFacingEnum();
    }

    public boolean wrenchCanRemove(EntityPlayer entityPlayer) {
        return entityPlayer.func_70093_af();
    }

    public float getWrenchDropRate() {
        return 1.0f;
    }

    public ItemStack getWrenchDrop(EntityPlayer entityPlayer) {
        return new ItemStack(ModBlocks.Semifluidgenerator, 1);
    }

    public int fill(EnumFacing from, FluidStack resource, boolean doFill) {
        int fill = this.tank.fill(resource, doFill);
        this.tank.compareAndUpdate();
        return fill;
    }

    public FluidStack drain(EnumFacing from, FluidStack resource, boolean doDrain) {
        FluidStack drain = this.tank.drain(resource.amount, doDrain);
        this.tank.compareAndUpdate();
        return drain;
    }

    public FluidStack drain(EnumFacing from, int maxDrain, boolean doDrain) {
        FluidStack drain = this.tank.drain(maxDrain, doDrain);
        this.tank.compareAndUpdate();
        return drain;
    }

    public boolean canFill(EnumFacing from, Fluid fluid) {
        if (fluid != null) {
            return this.fluids.containsKey(FluidRegistry.getFluidName((Fluid)fluid));
        }
        return false;
    }

    public boolean canDrain(EnumFacing from, Fluid fluid) {
        return this.tank.getFluid() == null || this.tank.getFluid().getFluid() == fluid;
    }

    public FluidTankInfo[] getTankInfo(EnumFacing from) {
        return new FluidTankInfo[]{this.tank.getInfo()};
    }

    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        this.tank.readFromNBT(tagCompound);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tagCompound) {
        super.func_189515_b(tagCompound);
        this.tank.writeToNBT(tagCompound);
        return tagCompound;
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity packet) {
        this.field_145850_b.func_147458_c(this.func_174877_v().func_177958_n(), this.func_174877_v().func_177956_o(), this.func_174877_v().func_177952_p(), this.func_174877_v().func_177958_n(), this.func_174877_v().func_177956_o(), this.func_174877_v().func_177952_p());
        this.func_145839_a(packet.func_148857_g());
    }

    public void updateEntity() {
        super.updateEntity();
        if (!this.field_145850_b.field_72995_K) {
            FluidUtils.drainContainers((IFluidHandler)this, (IInventory)this.inventory, (int)0, (int)1);
        }
        if (this.tank.getFluidAmount() > 0 && this.getMaxPower() - this.getEnergy() >= 8.0 && this.tank.getFluidType() != null && this.fluids.containsKey(this.tank.getFluidType().getName())) {
            Integer euPerBucket = this.fluids.get(this.tank.getFluidType().getName());
            float millibucketsPerTick = 8000.0f / (float)euPerBucket.intValue();
            this.pendingWithdraw += (double)millibucketsPerTick;
            int currentWithdraw = (int)this.pendingWithdraw;
            this.pendingWithdraw -= (double)currentWithdraw;
            this.tank.drain(currentWithdraw, true);
            this.addEnergy(8.0);
        }
        if (this.tank.getFluidType() != null && this.func_70301_a(2) == null) {
            this.inventory.func_70299_a(2, new ItemStack(this.tank.getFluidType().getBlock()));
        } else if (this.tank.getFluidType() == null && this.func_70301_a(2) != null) {
            this.func_70299_a(2, null);
        }
    }

    public double getMaxPower() {
        return ConfigTechReborn.ThermalGeneratorCharge;
    }

    public boolean canAcceptEnergy(EnumFacing direction) {
        return false;
    }

    public boolean canProvideEnergy(EnumFacing direction) {
        return true;
    }

    public double getMaxOutput() {
        return 8.0;
    }

    public double getMaxInput() {
        return 0.0;
    }

    public EnumPowerTier getTier() {
        return EnumPowerTier.LOW;
    }

    public Inventory getInventory() {
        return this.inventory;
    }
}

