/*
 * Decompiled with CFR 0.152.
 */
package techreborn;

import java.io.File;
import net.minecraft.block.BlockDispenser;
import net.minecraft.command.ICommand;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.IWorldGenerator;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLFingerprintViolationEvent;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import org.apache.commons.lang3.time.StopWatch;
import reborncore.RebornCore;
import reborncore.api.recipe.RecipeHandler;
import reborncore.common.IModInfo;
import reborncore.common.multiblock.MultiblockEventHandler;
import reborncore.common.multiblock.MultiblockServerTickHandler;
import reborncore.common.network.RegisterPacketEvent;
import reborncore.common.packets.AddDiscriminatorEvent;
import reborncore.common.util.LogHelper;
import reborncore.common.util.VersionChecker;
import techreborn.api.TechRebornAPI;
import techreborn.client.GuiHandler;
import techreborn.command.TechRebornDevCommand;
import techreborn.compat.CompatManager;
import techreborn.compat.ICompatModule;
import techreborn.config.ConfigTechReborn;
import techreborn.dispenser.BehaviorDispenseScrapbox;
import techreborn.entitys.EntityNukePrimed;
import techreborn.events.BlockBreakHandler;
import techreborn.events.OreUnifier;
import techreborn.events.TRTickHandler;
import techreborn.init.ModBlocks;
import techreborn.init.ModFluids;
import techreborn.init.ModItems;
import techreborn.init.ModLoot;
import techreborn.init.ModParts;
import techreborn.init.ModPoweredItems;
import techreborn.init.ModRecipes;
import techreborn.init.ModSounds;
import techreborn.init.OreDict;
import techreborn.init.SubItemRetriever;
import techreborn.lib.ModInfo;
import techreborn.packets.PacketAesu;
import techreborn.packets.PacketIdsu;
import techreborn.packets.PacketSyncSideConfig;
import techreborn.proxies.CommonProxy;
import techreborn.tiles.idsu.IDSUManager;
import techreborn.utils.StackWIPHandler;
import techreborn.world.TechRebornWorldGen;
import techreborn.world.VeinWorldGenerator;

@Mod(modid="techreborn", name="Tech Reborn", version="2.3.3.181", dependencies="required-after:forge;required-after:reborncore;after:jei@[3.13,);after:ic2", guiFactory="techreborn.config.TechRebornGUIFactory", acceptedMinecraftVersions="[1.11]", certificateFingerprint="8727a3141c8ec7f173b87aa78b9b9807867c4e6b")
public class Core {
    public static ConfigTechReborn config;
    @SidedProxy(clientSide="techreborn.proxies.ClientProxy", serverSide="techreborn.proxies.CommonProxy")
    public static CommonProxy proxy;
    @Mod.Instance
    public static Core INSTANCE;
    public static LogHelper logHelper;
    public static TechRebornWorldGen worldGen;
    public static File configDir;
    public VersionChecker versionChecker;

    public Core() {
        FluidRegistry.enableUniversalBucket();
    }

    @Mod.EventHandler
    public void preinit(FMLPreInitializationEvent event) throws IllegalAccessException, InstantiationException {
        event.getModMetadata().version = "2.3.3.181";
        INSTANCE = this;
        FMLCommonHandler.instance().bus().register((Object)this);
        MinecraftForge.EVENT_BUS.register((Object)this);
        configDir = new File(event.getModConfigurationDirectory(), "techreborn");
        if (!configDir.exists()) {
            configDir.mkdir();
        }
        config = ConfigTechReborn.initialize(new File(configDir, "main.cfg"));
        worldGen = new TechRebornWorldGen();
        Core.worldGen.configFile = new File(configDir, "ores.json");
        Core.worldGen.hConfigFile = new File(configDir, "ores.hjson");
        ModPoweredItems.preInit();
        TechRebornAPI.subItemRetriever = new SubItemRetriever();
        ModBlocks.init();
        ModFluids.init();
        ModItems.init();
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation("techreborn", "nuke"), EntityNukePrimed.class, (String)"nuke", (int)0, (Object)INSTANCE, (int)160, (int)5, (boolean)true);
        CompatManager.isIC2Loaded = Loader.isModLoaded((String)"ic2");
        for (ICompatModule compatModule : CompatManager.INSTANCE.compatModules) {
            compatModule.preInit(event);
        }
        OreDict.init();
        proxy.preInit(event);
        this.versionChecker = new VersionChecker("TechReborn", (IModInfo)new ModInfo());
        this.versionChecker.checkVersionThreaded();
        logHelper.info((Object)"PreInitialization Complete");
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) throws IllegalAccessException, InstantiationException {
        VeinWorldGenerator.registerTRVeins();
        if (ConfigTechReborn.veinOres) {
            GameRegistry.registerWorldGenerator((IWorldGenerator)VeinWorldGenerator.INSTANCE, (int)0);
        }
        ModLoot.init();
        ModParts.init();
        ModSounds.init();
        for (ICompatModule compatModule : CompatManager.INSTANCE.compatModules) {
            compatModule.init(event);
        }
        MinecraftForge.EVENT_BUS.register((Object)new StackWIPHandler());
        MinecraftForge.EVENT_BUS.register((Object)new BlockBreakHandler());
        StopWatch watch = new StopWatch();
        watch.start();
        ModRecipes.init();
        logHelper.all((Object)(watch + " : main recipes"));
        watch.stop();
        proxy.init(event);
        worldGen.load();
        if (!ConfigTechReborn.veinOres) {
            GameRegistry.registerWorldGenerator((IWorldGenerator)worldGen, (int)0);
        }
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)INSTANCE, (IGuiHandler)new GuiHandler());
        MinecraftForge.EVENT_BUS.register((Object)new MultiblockEventHandler());
        IDSUManager.INSTANCE = new IDSUManager();
        MinecraftForge.EVENT_BUS.register((Object)IDSUManager.INSTANCE);
        MinecraftForge.EVENT_BUS.register((Object)new MultiblockServerTickHandler());
        MinecraftForge.EVENT_BUS.register((Object)new TRTickHandler());
        MinecraftForge.EVENT_BUS.register((Object)new OreUnifier());
        if (ConfigTechReborn.ScrapboxDispenser) {
            BlockDispenser.field_149943_a.func_82595_a((Object)ModItems.SCRAP_BOX, (Object)new BehaviorDispenseScrapbox());
        }
        logHelper.info((Object)"Initialization Complete");
    }

    @Mod.EventHandler
    public void postinit(FMLPostInitializationEvent event) throws Exception {
        for (ICompatModule compatModule : CompatManager.INSTANCE.compatModules) {
            compatModule.postInit(event);
        }
        proxy.postInit(event);
        ModRecipes.postInit();
        logHelper.info((Object)(RecipeHandler.recipeList.size() + " recipes loaded"));
    }

    @Mod.EventHandler
    public void serverStarting(FMLServerStartingEvent event) {
        event.registerServerCommand((ICommand)new TechRebornDevCommand());
        for (ICompatModule compatModule : CompatManager.INSTANCE.compatModules) {
            compatModule.serverStarting(event);
        }
    }

    @SubscribeEvent
    public void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent cfgChange) {
        if (cfgChange.getModID().equals("TechReborn")) {
            ConfigTechReborn.Configs();
        }
    }

    @SubscribeEvent
    public void addDiscriminator(AddDiscriminatorEvent event) {
        event.getPacketHandler().addDiscriminator(event.getPacketHandler().nextDiscriminator, PacketAesu.class);
        event.getPacketHandler().addDiscriminator(event.getPacketHandler().nextDiscriminator, PacketIdsu.class);
    }

    @SubscribeEvent
    public void LoadPackets(RegisterPacketEvent event) {
        event.registerPacket(PacketSyncSideConfig.class, Side.SERVER);
    }

    @Mod.EventHandler
    public void onFingerprintViolation(FMLFingerprintViolationEvent event) {
        FMLLog.warning((String)"Invalid fingerprint detected for TechReborn!", (Object[])new Object[0]);
        RebornCore.proxy.invalidFingerprints.add("Invalid fingerprint detected for TechReborn!");
    }

    static {
        logHelper = new LogHelper((IModInfo)new ModInfo());
    }
}

